/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.io.PrintWriter;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.TracingMessageConsumer;

public class MessageTracer
implements Function<MessageConsumer, MessageConsumer> {
    private final PrintWriter printWriter;
    private final Map<String, TracingMessageConsumer.RequestMetadata> sentRequests = new HashMap<String, TracingMessageConsumer.RequestMetadata>();
    private final Map<String, TracingMessageConsumer.RequestMetadata> receivedRequests = new HashMap<String, TracingMessageConsumer.RequestMetadata>();

    MessageTracer(PrintWriter printWriter) {
        this.printWriter = Objects.requireNonNull(printWriter);
    }

    @Override
    public MessageConsumer apply(MessageConsumer messageConsumer) {
        return new TracingMessageConsumer(messageConsumer, this.sentRequests, this.receivedRequests, this.printWriter, Clock.systemDefaultZone());
    }
}

