/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

public abstract class HCLCollection<T>
extends HCLExpression {
    public final List<T> elements;

    public HCLCollection(List<T> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public static final class Object
    extends HCLCollection<ObjectElement> {
        private final List<? extends HCLExpression> parts;
        private final List<? extends HCLExpression> keys;
        private final List<? extends HCLExpression> values;

        public Object(List<ObjectElement> elements) {
            super(elements);
            ArrayList<HCLExpression> p = new ArrayList<HCLExpression>(elements.size() * 2);
            ArrayList<HCLExpression> k = new ArrayList<HCLExpression>(elements.size());
            ArrayList<HCLExpression> v = new ArrayList<HCLExpression>(elements.size());
            for (ObjectElement e : elements) {
                k.add(e.key);
                v.add(e.value);
                p.add(e.key);
                p.add(e.value);
            }
            this.parts = Collections.unmodifiableList(p);
            this.keys = Collections.unmodifiableList(k);
            this.values = Collections.unmodifiableList(v);
        }

        @Override
        public String asString() {
            StringJoiner sj = new StringJoiner(",", "{", "}");
            for (ObjectElement element : this.elements) {
                sj.add(element.toString());
            }
            return sj.toString();
        }

        public List<? extends HCLExpression> getKeys() {
            return this.keys;
        }

        public List<? extends HCLExpression> getValues() {
            return this.values;
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return this.parts;
        }
    }

    public static final class ObjectElement {
        public final HCLExpression key;
        public final HCLExpression value;
        public final int group;

        public ObjectElement(HCLExpression key, HCLExpression value, int group) {
            this.key = key;
            this.value = value;
            this.group = group;
        }

        public String toString() {
            return this.key.asString() + "=" + this.value.asString();
        }
    }

    public static final class Tuple
    extends HCLCollection<HCLExpression> {
        public Tuple(List<HCLExpression> elements) {
            super(elements);
        }

        @Override
        public String asString() {
            StringJoiner sj = new StringJoiner(",", "[", "]");
            for (HCLExpression element : this.elements) {
                sj.add(element.asString());
            }
            return sj.toString();
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return this.elements;
        }
    }
}

