/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import org.netbeans.installer.product.Registry;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.FinalizationException;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class FinalizeRegistryAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(FinalizeRegistryAction.class, "FRA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(FinalizeRegistryAction.class, "FRA.description");
    public static final String DEFAULT_REGISTRY_FINALIZATION_FAILED_MESSAGE = ResourceUtils.getString(FinalizeRegistryAction.class, "FRA.registry.finalization.failed");
    public static final String REGISTRY_FINALIZATION_FAILED_PROPERTY = "registry.finalization.failed";

    public FinalizeRegistryAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(REGISTRY_FINALIZATION_FAILED_PROPERTY, DEFAULT_REGISTRY_FINALIZATION_FAILED_MESSAGE);
    }

    @Override
    public void execute() {
        try {
            Registry.getInstance().finalizeRegistry(new Progress());
        }
        catch (FinalizationException e) {
            ErrorManager.notifyError(StringUtils.format(this.getProperty(REGISTRY_FINALIZATION_FAILED_PROPERTY), new Object[0]), e);
        }
    }

    @Override
    public WizardAction.WizardActionUi getWizardUi() {
        return null;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }
}

