"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupFindingsRoutes = setupFindingsRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupFindingsRoutes(services, router) {
  const {
    findingsService
  } = services;
  router.get({
    path: `${_constants.API.GET_FINDINGS}`,
    validate: {
      query: _configSchema.schema.object({
        detectorType: _configSchema.schema.maybe(_configSchema.schema.string()),
        detectorId: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    }
  }, findingsService.getFindings);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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