/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger.smali;

import jadx.gui.device.debugger.smali.RegisterInfo;

public class SmaliRegister
extends RegisterInfo {
    private final int num;
    private String paramName;
    private final int endOffset;
    private int startOffset;
    private boolean isParam;
    private int runtimeNum;

    public SmaliRegister(int num, int insnCount) {
        this.num = num;
        this.endOffset = insnCount;
        this.startOffset = insnCount;
    }

    public int getRuntimeRegNum() {
        return this.runtimeNum;
    }

    public void setRuntimeRegNum(int runtimeNum) {
        this.runtimeNum = runtimeNum;
    }

    @Override
    public boolean isInitialized(long codeOffset) {
        return codeOffset > (long)this.getStartOffset() && codeOffset < (long)this.getEndOffset();
    }

    protected void setParam(String name) {
        this.paramName = name;
        this.isParam = true;
    }

    protected void setStartOffset(int off) {
        if (off < this.startOffset) {
            this.startOffset = off;
        }
    }

    public String getName() {
        return this.paramName != null ? this.paramName : "v" + this.num;
    }

    public int getRegNum() {
        return this.num;
    }

    public String getType() {
        return "";
    }

    public String getSignature() {
        return null;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isMarkedAsParameter() {
        return this.isParam;
    }
}

