/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTPermission;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import sun.awt.AppContext;
import sun.awt.DesktopBrowse;
import sun.awt.SunToolkit;

public class Desktop {
    private DesktopPeer peer = Toolkit.getDefaultToolkit().createDesktopPeer(this);

    private Desktop() {
    }

    public static synchronized Desktop getDesktop() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("Desktop API is not supported on the current platform");
        }
        AppContext appContext = AppContext.getAppContext();
        Desktop desktop = (Desktop)appContext.get(Desktop.class);
        if (desktop == null) {
            desktop = new Desktop();
            appContext.put(Desktop.class, desktop);
        }
        return desktop;
    }

    public static boolean isDesktopSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            return ((SunToolkit)toolkit).isDesktopSupported();
        }
        return false;
    }

    public boolean isSupported(Action action) {
        return this.peer.isSupported(action);
    }

    private static void checkFileValidation(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file: " + file.getPath() + " doesn't exist.");
        }
    }

    private void checkActionSupport(Action action) {
        if (!this.isSupported(action)) {
            throw new UnsupportedOperationException("The " + action.name() + " action is not supported on the current platform!");
        }
    }

    private void checkAWTPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
        }
    }

    public void open(File file) throws IOException {
        file = new File(file.getPath());
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.OPEN);
        Desktop.checkFileValidation(file);
        this.peer.open(file);
    }

    public void edit(File file) throws IOException {
        file = new File(file.getPath());
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.EDIT);
        file.canWrite();
        Desktop.checkFileValidation(file);
        this.peer.edit(file);
    }

    public void print(File file) throws IOException {
        file = new File(file.getPath());
        this.checkExec();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        this.checkActionSupport(Action.PRINT);
        Desktop.checkFileValidation(file);
        this.peer.print(file);
    }

    public void browse(URI uRI) throws IOException {
        SecurityException securityException = null;
        try {
            this.checkAWTPermission();
            this.checkExec();
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
        }
        this.checkActionSupport(Action.BROWSE);
        if (uRI == null) {
            throw new NullPointerException();
        }
        if (securityException == null) {
            this.peer.browse(uRI);
            return;
        }
        URL uRL = null;
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Unable to convert URI to URL", malformedURLException);
        }
        DesktopBrowse desktopBrowse = DesktopBrowse.getInstance();
        if (desktopBrowse == null) {
            throw securityException;
        }
        desktopBrowse.browse(uRL);
    }

    public void mail() throws IOException {
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.MAIL);
        URI uRI = null;
        try {
            uRI = new URI("mailto:?");
            this.peer.mail(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void mail(URI uRI) throws IOException {
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.MAIL);
        if (uRI == null) {
            throw new NullPointerException();
        }
        if (!"mailto".equalsIgnoreCase(uRI.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not \"mailto\"");
        }
        this.peer.mail(uRI);
    }

    private void checkExec() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
        }
    }

    public static enum Action {
        OPEN,
        EDIT,
        PRINT,
        MAIL,
        BROWSE;

    }
}

