/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.NullMethod;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassProvider;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Java::JavaPackage"}, parent="Module")
public class JavaPackage
extends RubyModule {
    final String packageName;

    static RubyClass createJavaPackageClass(Ruby runtime2, RubyModule Java2) {
        BlankSlateWrapper superClass = new BlankSlateWrapper(runtime2, runtime2.getModule(), runtime2.getKernel());
        RubyClass JavaPackage2 = RubyClass.newClass(runtime2, superClass);
        JavaPackage2.setMetaClass(runtime2.getModule());
        JavaPackage2.setAllocator(ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ((MetaClass)JavaPackage2.makeMetaClass(superClass)).setAttached(JavaPackage2);
        JavaPackage2.setBaseName("JavaPackage");
        JavaPackage2.setParent(Java2);
        JavaPackage2.defineAnnotatedMethods(JavaPackage.class);
        return JavaPackage2;
    }

    static RubyModule newPackage(Ruby runtime2, CharSequence name2, RubyModule parent) {
        JavaPackage pkgModule = new JavaPackage(runtime2, name2);
        pkgModule.addClassProvider(JavaClassProvider.INSTANCE);
        return pkgModule;
    }

    static CharSequence buildPackageName(RubyModule parentPackage, String name2) {
        return ((JavaPackage)parentPackage).packageRelativeName(name2);
    }

    private JavaPackage(Ruby runtime2, CharSequence packageName) {
        super(runtime2, runtime2.getJavaSupport().getJavaPackageClass(), false);
        this.packageName = packageName.toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    @JRubyMethod(name={"package_name"}, alias={"to_s"})
    public RubyString package_name() {
        return this.getRuntime().newString(this.packageName);
    }

    @Override
    public RubyString to_s() {
        return this.package_name();
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, obj == this || this.isInstance(obj));
    }

    @JRubyMethod(name={"const_missing"})
    public IRubyObject const_missing(ThreadContext context, IRubyObject name2) {
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    @JRubyMethod(name={"const_get"})
    public final IRubyObject const_get(ThreadContext context, IRubyObject name2) {
        IRubyObject constant = this.getConstantNoConstMissing(name2.toString(), false, false);
        if (constant != null) {
            return constant;
        }
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    @JRubyMethod(name={"const_get"})
    public final IRubyObject const_get(ThreadContext context, IRubyObject name2, IRubyObject inherit) {
        IRubyObject constant = this.getConstantNoConstMissing(name2.toString(), inherit.isTrue(), false);
        if (constant != null) {
            return constant;
        }
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    public final IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    @Override
    public final boolean hasConstant(String name2) {
        return this.constantTableContains(name2);
    }

    @Override
    public final IRubyObject fetchConstant(String name2, boolean includePrivate) {
        RubyModule.ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            throw this.getRuntime().newNameError("private constant " + this.getName() + "::" + name2 + " referenced", name2);
        }
        return entry.value;
    }

    @Override
    public final IRubyObject deleteConstant(String name2) {
        assert (name2 != null) : "name is null";
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    final CharSequence packageRelativeName(CharSequence name2) {
        int length2 = this.packageName.length();
        StringBuilder fullName = new StringBuilder(length2 + 1 + name2.length());
        fullName.append(this.packageName);
        if (length2 > 0) {
            fullName.append('.');
        }
        return fullName.append(name2);
    }

    private RubyModule relativeJavaClassOrPackage(ThreadContext context, IRubyObject name2, boolean cacheMethod) {
        return Java.getProxyOrPackageUnderPackage(context, this, name2.toString(), cacheMethod);
    }

    RubyModule relativeJavaProxyClass(Ruby runtime2, IRubyObject name2) {
        String fullName = this.packageRelativeName(name2.toString()).toString();
        return Java.getProxyClass(runtime2, Java.getJavaClass(runtime2, fullName), true);
    }

    @JRubyMethod(name={"respond_to?"})
    public IRubyObject respond_to_p(ThreadContext context, IRubyObject name2) {
        return this.respond_to(context, name2, false);
    }

    @JRubyMethod(name={"respond_to?"})
    public IRubyObject respond_to_p(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        return this.respond_to(context, name2, includePrivate.isTrue());
    }

    private IRubyObject respond_to(ThreadContext context, IRubyObject mname, boolean includePrivate) {
        RubySymbol name2 = TypeConverter.checkID(mname);
        if (this.getMetaClass().respondsToMethod(name2.idString(), !includePrivate)) {
            return context.tru;
        }
        return context.nil;
    }

    private RubyBoolean checkMetaClassBoundMethod(ThreadContext context, String name2, boolean includePrivate) {
        DynamicMethod method2 = this.getMetaClass().searchMethod(name2);
        if (!method2.isUndefined() && !method2.isNotImplemented()) {
            if (!includePrivate && method2.getVisibility() == Visibility.PRIVATE) {
                return context.fals;
            }
            return context.tru;
        }
        return null;
    }

    @JRubyMethod(name={"respond_to_missing?"})
    public IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject name2) {
        return this.respond_to_missing(context, name2, false);
    }

    @JRubyMethod(name={"respond_to_missing?"})
    public IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        return this.respond_to_missing(context, name2, includePrivate.isTrue());
    }

    private RubyBoolean respond_to_missing(ThreadContext context, IRubyObject mname, boolean includePrivate) {
        return RubyBoolean.newBoolean(context, BlankSlateWrapper.handlesMethod(TypeConverter.checkID(mname).idString()) == null);
    }

    @JRubyMethod(name={"method_missing"})
    public IRubyObject method_missing(ThreadContext context, IRubyObject name2) {
        return Java.getProxyOrPackageUnderPackage(context, this, name2.toString(), true);
    }

    @JRubyMethod(name={"method_missing"}, rest=true)
    public IRubyObject method_missing(ThreadContext context, IRubyObject[] args2) {
        if (args2.length > 1) {
            throw JavaPackage.packageMethodArgumentMismatch(context.runtime, this, args2[0].toString(), args2.length - 1);
        }
        return this.method_missing(context, args2[0]);
    }

    static RaiseException packageMethodArgumentMismatch(Ruby runtime2, RubyModule pkg, String method2, int argsLength) {
        String packageName = ((JavaPackage)pkg).packageName;
        return runtime2.newArgumentError("Java package '" + packageName + "' does not have a method `" + method2 + "' with " + argsLength + (argsLength == 1 ? " argument" : " arguments"));
    }

    public final boolean isAvailable() {
        return this.getPackage() != null;
    }

    private Package getPackage() {
        return Package.getPackage(this.packageName);
    }

    @JRubyMethod(name={"available?"})
    public IRubyObject available_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isAvailable());
    }

    @JRubyMethod(name={"sealed?"})
    public IRubyObject sealed_p(ThreadContext context) {
        Package pkg = this.getPackage();
        if (pkg == null) {
            return context.nil;
        }
        return RubyBoolean.newBoolean(context, pkg.isSealed());
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2.isAssignableFrom(Package.class)) {
            return target2.cast(this.getPackage());
        }
        return super.toJava(target2);
    }

    static final class BlankSlateWrapper
    extends IncludedModuleWrapper {
        BlankSlateWrapper(Ruby runtime2, RubyClass superClass, RubyModule delegate) {
            super(runtime2, superClass, delegate);
        }

        @Override
        protected DynamicMethod searchMethodCommon(String id2) {
            if ("superclass".equals(id2)) {
                return new MethodValue(id2, this.superClass);
            }
            return (id2 = BlankSlateWrapper.handlesMethod(id2)) != null ? this.superClass.searchMethodInner(id2) : NullMethod.INSTANCE;
        }

        private static String handlesMethod(String name2) {
            switch (name2) {
                case "class": 
                case "singleton_class": {
                    return name2;
                }
                case "object_id": 
                case "name": {
                    return name2;
                }
                case "const_set": {
                    return name2;
                }
                case "inspect": 
                case "to_s": {
                    return name2;
                }
                case "throw": 
                case "catch": {
                    return name2;
                }
                case "singleton_method_added": 
                case "singleton_method_undefined": 
                case "singleton_method_removed": 
                case "define_singleton_method": {
                    return name2;
                }
                case "__constants__": {
                    return "constants";
                }
                case "__methods__": {
                    return "methods";
                }
            }
            int last2 = name2.length() - 1;
            if (last2 >= 0) {
                switch (name2.charAt(last2)) {
                    case '!': 
                    case '=': 
                    case '?': {
                        return name2;
                    }
                }
                switch (name2.charAt(0)) {
                    case '<': 
                    case '=': 
                    case '>': {
                        return name2;
                    }
                    case '_': {
                        if (last2 <= 0 || name2.charAt(1) != '_') break;
                        return name2;
                    }
                }
            }
            return null;
        }

        @Override
        public void addSubclass(RubyClass subclass) {
        }

        private static class MethodValue
        extends DynamicMethod {
            private final IRubyObject value;

            MethodValue(String name2, IRubyObject value2) {
                super(name2);
                this.value = value2;
            }

            @Override
            public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return this.call(context, self2, clazz, name2);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
                return this.value;
            }

            @Override
            public DynamicMethod dup() {
                try {
                    return (DynamicMethod)super.clone();
                }
                catch (CloneNotSupportedException ex) {
                    throw new AssertionError((Object)ex);
                }
            }

            @Override
            @Deprecated
            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            @Override
            public Signature getSignature() {
                return Signature.NO_ARGUMENTS;
            }
        }
    }

    private static class JavaClassProvider
    implements ClassProvider {
        static final JavaClassProvider INSTANCE = new JavaClassProvider();

        private JavaClassProvider() {
        }

        @Override
        public RubyClass defineClassUnder(RubyModule pkg, String name2, RubyClass superClazz) {
            if (superClazz != null) {
                return null;
            }
            String subPackageName = JavaPackage.buildPackageName(pkg, name2).toString();
            Ruby runtime2 = pkg.getRuntime();
            Class javaClass = Java.getJavaClass(runtime2, subPackageName);
            return (RubyClass)Java.getProxyClass(runtime2, javaClass);
        }

        @Override
        public RubyModule defineModuleUnder(RubyModule pkg, String name2) {
            String subPackageName = JavaPackage.buildPackageName(pkg, name2).toString();
            Ruby runtime2 = pkg.getRuntime();
            Class javaClass = Java.getJavaClass(runtime2, subPackageName);
            return Java.getInterfaceModule(runtime2, javaClass);
        }
    }
}

