/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetUpdateTagAction
extends BaseCodeInsightAction
implements DumbAware,
PopupAction {
    private static final String EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY = "emmet.recent.update.abbreviations";
    private static final String EMMET_LAST_UPDATE_ABBREVIATIONS_KEY = "emmet.last.update.abbreviations";
    private static final EmmetAbbreviationBalloon.EmmetContextHelp CONTEXT_HELP = new EmmetAbbreviationBalloon.EmmetContextHelp(XmlBundle.messagePointer("emmet.context.help.tooltip", new Object[0]));

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project2, final @NotNull Editor editor, final @NotNull PsiFile file) {
                XmlTag tag;
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((tag = EmmetUpdateTagAction.findTag(editor, file)) != null) {
                    new EmmetAbbreviationBalloon(EmmetUpdateTagAction.EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY, EmmetUpdateTagAction.EMMET_LAST_UPDATE_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

                        @Override
                        public void onEnter(@NotNull String abbreviation) {
                            if (abbreviation == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            try {
                                EmmetUpdateTagAction.this.doUpdateTag(abbreviation, tag, file, editor);
                            }
                            catch (EmmetException emmetException) {
                                // empty catch block
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1$1", "onEnter"));
                        }
                    }, CONTEXT_HELP).show(new CustomTemplateCallback(editor, file));
                }
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void doUpdateTag(@NotNull String abbreviation, @NotNull XmlTag tag, @NotNull PsiFile file, @NotNull Editor editor) throws EmmetException {
        if (abbreviation == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(3);
        }
        if (!tag.isValid()) {
            return;
        }
        ReadAction.nonBlocking(() -> EmmetUpdateTagAction.expandTemplate(abbreviation, file, editor)).finishOnUiThread(ModalityState.current(), templateText -> {
            LinkedHashSet<String> classNames = new LinkedHashSet<String>();
            ContainerUtil.addAll(classNames, HtmlUtil.splitClassNames(tag.getAttributeValue("class")));
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            Ref newTagName = Ref.create();
            EmmetUpdateTagAction.processTags(file.getProject(), templateText, (PairProcessor<? super XmlTag, ? super Boolean>)((PairProcessor)(tag1, firstTag) -> {
                if (firstTag.booleanValue() && !abbreviation.isEmpty() && StringUtil.isJavaIdentifierPart((char)abbreviation.charAt(0))) {
                    newTagName.set((Object)tag1.getName());
                }
                for (String clazz : HtmlUtil.splitClassNames(tag1.getAttributeValue("class"))) {
                    if (StringUtil.startsWithChar((CharSequence)clazz, (char)'+')) {
                        classNames.add(clazz.substring(1));
                        continue;
                    }
                    if (StringUtil.startsWithChar((CharSequence)clazz, (char)'-')) {
                        classNames.remove(clazz.substring(1));
                        continue;
                    }
                    classNames.clear();
                    classNames.add(clazz);
                }
                if (!firstTag.booleanValue()) {
                    classNames.add(tag1.getName());
                }
                for (XmlAttribute xmlAttribute : tag1.getAttributes()) {
                    if ("class".equalsIgnoreCase(xmlAttribute.getName())) continue;
                    attributes.put(xmlAttribute.getName(), StringUtil.notNullize((String)xmlAttribute.getValue()));
                }
                return true;
            }));
            WriteCommandAction.writeCommandAction((Project)file.getProject(), (PsiFile[])new PsiFile[]{file}).run(EmmetUpdateTagAction.doUpdateTagAttributes(tag, file, (String)newTagName.get(), classNames, attributes));
        }).expireWhen(() -> editor.isDisposed() || !file.isValid()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private static String expandTemplate(@NotNull String abbreviation, @NotNull PsiFile file, @NotNull Editor editor) throws EmmetException {
        if (abbreviation == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(6);
        }
        CollectCustomTemplateCallback callback2 = new CollectCustomTemplateCallback(editor, file);
        ZenCodingTemplate.expand(abbreviation, callback2, XmlZenCodingGeneratorImpl.INSTANCE, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        TemplateImpl template = callback2.getGeneratedTemplate();
        return template != null ? template.getTemplateText() : null;
    }

    private static void processTags(@NotNull Project project2, @Nullable String templateText, @NotNull PairProcessor<? super XmlTag, ? super Boolean> processor2) {
        if (project2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(8);
        }
        if (StringUtil.isNotEmpty((String)templateText)) {
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project2);
            XmlFile xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)HtmlFileType.INSTANCE, (CharSequence)templateText);
            XmlTag tag = xmlFile.getRootTag();
            boolean firstTag = true;
            while (tag != null) {
                processor2.process((Object)tag, (Object)firstTag);
                firstTag = false;
                tag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class);
            }
        }
    }

    @NotNull
    private static ThrowableRunnable<RuntimeException> doUpdateTagAttributes(@NotNull XmlTag tag, @NotNull PsiFile file, @Nullable String newTagName, @NotNull Collection<String> classes, @NotNull Map<String, String> attributes) {
        if (tag == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(10);
        }
        if (classes == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(12);
        }
        ThrowableRunnable throwableRunnable = () -> {
            if (tag.isValid() && !ReadonlyStatusHandler.getInstance((Project)file.getProject()).ensureFilesWritable(Collections.singletonList(file.getVirtualFile())).hasReadonlyFiles()) {
                tag.setAttribute("class", StringUtil.join((Collection)classes, (String)" ").trim());
                for (Map.Entry attribute : attributes.entrySet()) {
                    XmlAttribute existingAttribute;
                    String attributeName = (String)attribute.getKey();
                    if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'+')) {
                        existingAttribute = tag.getAttribute(attributeName.substring(1));
                        if (existingAttribute != null) {
                            existingAttribute.setValue(StringUtil.notNullize((String)(existingAttribute.getValue() + (String)attribute.getValue())));
                            continue;
                        }
                        tag.setAttribute(attributeName.substring(1), (String)attribute.getValue());
                        continue;
                    }
                    if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'-')) {
                        existingAttribute = tag.getAttribute(attributeName.substring(1));
                        if (existingAttribute == null) continue;
                        existingAttribute.delete();
                        continue;
                    }
                    tag.setAttribute(attributeName, (String)attribute.getValue());
                }
                if (newTagName != null) {
                    tag.setName(newTagName);
                }
            }
        };
        if (throwableRunnable == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(13);
        }
        return throwableRunnable;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(14);
        }
        super.update(event);
        event.getPresentation().setVisible(event.getPresentation().isEnabled());
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(16);
        }
        if (file == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(17);
        }
        return super.isValidForFile(project2, editor, file) && EmmetOptions.getInstance().isEmmetEnabled() && EmmetUpdateTagAction.findTag(editor, file) != null;
    }

    @Nullable
    private static XmlTag findTag(@NotNull Editor editor, @NotNull PsiFile file) {
        XmlTag tag;
        if (editor == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(18);
        }
        if (file == null) {
            EmmetUpdateTagAction.$$$reportNull$$$0(19);
        }
        return (tag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), (Class[])new Class[]{XmlTag.class})) != null && HtmlUtil.isHtmlTag(tag) ? tag : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdateTagAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateTag";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTags";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateTagAttributes";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findTag";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13 -> new IllegalStateException(string2);
        };
    }
}

