/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.CompareWithLocalDialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsCompareWithAction<T extends Repository>
extends DumbAwareAction {
    @NotNull
    protected abstract AbstractRepositoryManager<T> getRepositoryManager(@NotNull Project var1);

    protected abstract boolean nothingToCompare(@NotNull T var1);

    @Nullable
    protected abstract JBPopup createPopup(@NotNull Project var1, @NotNull T var2, @NotNull VirtualFile var3);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VirtualFile file = (VirtualFile)JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).single();
        if (file == null) {
            return;
        }
        T repository = this.getRepositoryManager(project2).getRepositoryForFileQuick(file);
        if (repository == null) {
            return;
        }
        assert (!repository.isFresh());
        JBPopup popup2 = this.createPopup(project2, repository, file);
        if (popup2 == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> popup2.showCenteredInCurrentWindow(project2)));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        Project project2 = e.getProject();
        VirtualFile file = (VirtualFile)JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).single();
        presentation2.setVisible(project2 != null);
        presentation2.setEnabled(project2 != null && file != null && this.isEnabled(this.getRepositoryManager(project2).getRepositoryForFileQuick(file)));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private boolean isEnabled(@Nullable T repository) {
        return repository != null && !repository.isFresh() && !this.nothingToCompare(repository);
    }

    @NotNull
    protected static JBPopup createPopup(@NotNull @NlsContexts.PopupTitle String title2, @NotNull List<String> options, @NotNull Consumer<? super String> onChosen) {
        if (title2 == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(3);
        }
        if (options == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(4);
        }
        if (onChosen == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(5);
        }
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(options).setTitle(title2).setMovable(true).setItemChosenCallback(onChosen::accept).setAutoselectOnMouseMove(true).setNamerForFiltering(o -> o).setRenderer(BuilderKt.textListCellRenderer(name -> name)).withFixedRendererSize(new Dimension(JBUI.scale((int)350), JBUI.CurrentTheme.List.rowHeight())).createPopup();
        if (jBPopup == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(6);
        }
        return jBPopup;
    }

    protected static void showDiffBetweenRevision(final @NotNull Project project2, @NotNull VirtualFile file, final @NotNull @Nls String revNumTitle1, final @NotNull @Nls String revNumTitle2, final @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project2 == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(8);
        }
        if (revNumTitle1 == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(9);
        }
        if (revNumTitle2 == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(10);
        }
        if (changesLoader == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(11);
        }
        if (file.isDirectory()) {
            String dialogTitle = VcsBundle.message("history.dialog.title.difference.between.versions.in", revNumTitle1, revNumTitle2, file.getName());
            CompareWithLocalDialog.showChanges(project2, dialogTitle, CompareWithLocalDialog.LocalContent.AFTER, changesLoader);
        } else {
            ChangeDiffRequestChain.Async requestChain = new ChangeDiffRequestChain.Async(){

                @NotNull
                protected ListSelection<ChangeDiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException {
                    ListSelection listSelection;
                    try {
                        Collection changes2 = (Collection)changesLoader.compute();
                        HashMap<Key, String> changeContext = new HashMap<Key, String>(2);
                        changeContext.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, revNumTitle1);
                        changeContext.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, revNumTitle2);
                        listSelection = ListSelection.createAt(new ArrayList(changes2), (int)0).map(change -> ChangeDiffRequestProducer.create(project2, change, changeContext));
                    }
                    catch (VcsException e) {
                        throw new DiffRequestProducerException((Throwable)e);
                    }
                    if (listSelection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return listSelection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/actions/DvcsCompareWithAction$1", "loadRequestProducers"));
                }
            };
            DiffManager.getInstance().showDiff(project2, (DiffRequestChain)requestChain, DiffDialogHints.DEFAULT);
        }
    }

    @NotNull
    protected static String getPresentableCurrentBranchName(Repository repository) {
        String branchName = repository.getCurrentBranchName();
        if (branchName != null) {
            String string2 = branchName;
            if (string2 == null) {
                DvcsCompareWithAction.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String revision = repository.getCurrentRevision();
        if (revision != null) {
            String string3 = DvcsUtil.getShortHash(revision);
            if (string3 == null) {
                DvcsCompareWithAction.$$$reportNull$$$0(13);
            }
            return string3;
        }
        String string4 = VcsBundle.message("diff.title.local", new Object[0]);
        if (string4 == null) {
            DvcsCompareWithAction.$$$reportNull$$$0(14);
        }
        return string4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/actions/DvcsCompareWithAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revNumTitle1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revNumTitle2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/actions/DvcsCompareWithAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableCurrentBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDiffBetweenRevision";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 12, 13, 14 -> new IllegalStateException(string2);
        };
    }
}

