/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.RevisionData;
import com.intellij.history.integration.ui.models.RevisionDataKt;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HistoryDialogModel {
    protected final Project myProject;
    protected final LocalHistoryFacade myVcs;
    protected final VirtualFile myFile;
    protected final IdeaGateway myGateway;
    private String myFilter;
    protected boolean myBefore = true;
    private RevisionData myRevisionData;
    private int myRightRevisionIndex;
    private int myLeftRevisionIndex;
    private Entry[] myLeftEntryCache;
    private Entry[] myRightEntryCache;

    public HistoryDialogModel(Project p, IdeaGateway gw, LocalHistoryFacade vcs, VirtualFile f) {
        this.myProject = p;
        this.myVcs = vcs;
        this.myFile = f;
        this.myGateway = gw;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return FileUtil.toSystemDependentName((String)this.myFile.getPath());
    }

    @NotNull
    protected RevisionData getRevisionData() {
        if (this.myRevisionData == null) {
            this.myRevisionData = this.collectRevisionData();
        }
        RevisionData revisionData = this.myRevisionData;
        if (revisionData == null) {
            HistoryDialogModel.$$$reportNull$$$0(0);
        }
        return revisionData;
    }

    @NotNull
    public List<RevisionItem> getRevisions() {
        List<RevisionItem> list2 = this.getRevisionData().getRevisions();
        if (list2 == null) {
            HistoryDialogModel.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public Revision getCurrentRevision() {
        Revision revision = this.getRevisionData().getCurrentRevision();
        if (revision == null) {
            HistoryDialogModel.$$$reportNull$$$0(2);
        }
        return revision;
    }

    @NotNull
    protected RevisionData collectRevisionData() {
        RevisionData revisionData = RevisionDataKt.collectRevisionData(this.myProject, this.myGateway, this.myVcs, this.myFile, this.myFilter, this.myBefore);
        if (revisionData == null) {
            HistoryDialogModel.$$$reportNull$$$0(3);
        }
        return revisionData;
    }

    public void processContents(@NotNull PairProcessor<? super Revision, ? super String> processor2) {
        if (processor2 == null) {
            HistoryDialogModel.$$$reportNull$$$0(4);
        }
        RevisionDataKt.processContents(this.myVcs, this.myGateway, this.myFile, ContainerUtil.map(this.getRevisions(), item2 -> item2.revision), this.myBefore, processor2);
    }

    @Nullable
    public String myFilter() {
        return this.myFilter;
    }

    public void setFilter(@Nullable String filter2) {
        this.myFilter = StringUtil.isEmptyOrSpaces((String)filter2) ? null : filter2;
        this.clearRevisions();
    }

    public void clearRevisions() {
        this.myRevisionData = null;
        this.resetEntriesCache();
    }

    private void resetEntriesCache() {
        this.myLeftEntryCache = null;
        this.myRightEntryCache = null;
    }

    public Revision getLeftRevision() {
        if (this.getRevisions().isEmpty()) {
            return this.getCurrentRevision();
        }
        return this.getRevisions().get((int)this.myLeftRevisionIndex).revision;
    }

    public Revision getRightRevision() {
        if (this.isCurrentRevisionSelected() || this.getRevisions().isEmpty()) {
            return this.getCurrentRevision();
        }
        return this.getRevisions().get((int)this.myRightRevisionIndex).revision;
    }

    @Nullable
    protected Entry getLeftEntry() {
        if (this.myLeftEntryCache == null) {
            this.myLeftEntryCache = new Entry[]{this.getLeftRevision().findEntry()};
        }
        return this.myLeftEntryCache[0];
    }

    @Nullable
    protected Entry getRightEntry() {
        if (this.myRightEntryCache == null) {
            this.myRightEntryCache = new Entry[]{this.getRightRevision().findEntry()};
        }
        return this.myRightEntryCache[0];
    }

    public boolean selectRevisions(int first, int second) {
        int l;
        int r;
        if (first == second) {
            r = -1;
            l = first == -1 ? 0 : first;
        } else {
            r = first;
            l = second;
        }
        if (this.myRightRevisionIndex == r && this.myLeftRevisionIndex == l) {
            return false;
        }
        this.myRightRevisionIndex = r;
        this.myLeftRevisionIndex = l;
        this.resetEntriesCache();
        return true;
    }

    public boolean resetSelection() {
        return this.selectRevisions(0, 0);
    }

    public boolean isCurrentRevisionSelected() {
        return this.myRightRevisionIndex == -1;
    }

    public List<Change> getChanges() {
        List<Difference> dd = this.getDifferences();
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (Difference d : dd) {
            result2.add(this.createChange(d));
        }
        return result2;
    }

    protected List<Difference> getDifferences() {
        return Revision.getDifferencesBetween(this.getLeftRevision(), this.getRightRevision());
    }

    protected Change createChange(@NotNull Difference d) {
        if (d == null) {
            HistoryDialogModel.$$$reportNull$$$0(5);
        }
        return new Change(d.getLeftContentRevision(this.myGateway), d.getRightContentRevision(this.myGateway));
    }

    public abstract Reverter createReverter();

    public boolean isRevertEnabled() {
        return this.isCorrectSelectionForRevertAndPatch();
    }

    public boolean isCreatePatchEnabled() {
        return this.isCorrectSelectionForRevertAndPatch();
    }

    private boolean isCorrectSelectionForRevertAndPatch() {
        return this.myLeftRevisionIndex != -1;
    }

    public boolean canPerformCreatePatch() {
        return !this.getLeftEntry().hasUnavailableContent() && !this.getRightEntry().hasUnavailableContent();
    }

    @ApiStatus.Internal
    @NotNull
    public abstract LocalHistoryCounter.Kind getKind();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/models/HistoryDialogModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentRevision";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRevisionData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/models/HistoryDialogModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processContents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

