/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.views.RecentChangeDialog;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class RecentChangesPopup {
    public static void show(final Project project2, final @NotNull IdeaGateway gw, final @NotNull LocalHistoryFacade vcs) {
        if (gw == null) {
            RecentChangesPopup.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RecentChangesPopup.$$$reportNull$$$0(1);
        }
        List cc = (List)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<List<RecentChange>, RuntimeException>(project2, LocalHistoryBundle.message("recent.changes.loading", new Object[0]), true){

            protected List<RecentChange> compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (List)LocalHistoryCounter.INSTANCE.logLoadItems(project2, LocalHistoryCounter.Kind.Recent, () -> vcs.getRecentChanges((RootEntry)ReadAction.compute(() -> gw.createTransientRootEntry())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/history/integration/ui/views/RecentChangesPopup$1", "compute"));
            }
        });
        String title2 = LocalHistoryBundle.message("recent.changes.popup.title", new Object[0]);
        if (cc.isEmpty()) {
            Messages.showInfoMessage((Project)project2, (String)LocalHistoryBundle.message("recent.changes.to.changes", new Object[0]), (String)title2);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(cc).setSelectionMode(0).setRenderer((ListCellRenderer)new RecentChangesListCellRenderer()).setTitle(title2).setItemChosenCallback(change -> new RecentChangeDialog(project2, gw, (RecentChange)change).show()).createPopup().showCenteredInCurrentWindow(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "gw";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "vcs";
                break;
            }
        }
        objectArray[1] = "com/intellij/history/integration/ui/views/RecentChangesPopup";
        objectArray[2] = "show";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RecentChangesListCellRenderer
    implements ListCellRenderer<RecentChange> {
        private final JPanel myPanel = new JPanel(new FlowLayout(3, 10, 2));
        private final JLabel myActionLabel = new JLabel("", 2);
        private final JLabel myDateLabel = new JLabel("", 2);
        private final JPanel mySpacePanel = new JPanel();

        RecentChangesListCellRenderer() {
            this.myPanel.add(this.myDateLabel);
            this.myPanel.add(this.mySpacePanel);
            this.myPanel.add(this.myActionLabel);
            Dimension d = new Dimension(10, this.mySpacePanel.getPreferredSize().height);
            this.mySpacePanel.setMinimumSize(d);
            this.mySpacePanel.setMaximumSize(d);
            this.mySpacePanel.setPreferredSize(d);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends RecentChange> list2, @NotNull RecentChange value2, int index, boolean isSelected, boolean cellHasFocus) {
            if (value2 == null) {
                RecentChangesListCellRenderer.$$$reportNull$$$0(0);
            }
            this.myActionLabel.setText(value2.getChangeName());
            this.myDateLabel.setText(DateFormatUtil.formatDateTime((long)value2.getTimestamp()));
            this.updateColors(isSelected);
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground((boolean)true) : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground((boolean)true) : UIUtil.getTableForeground();
            RecentChangesListCellRenderer.setColors(bg, fg, this.myPanel, this.myActionLabel, this.myDateLabel, this.mySpacePanel);
        }

        private static void setColors(Color bg, Color fg, JComponent ... cc) {
            if (cc == null) {
                RecentChangesListCellRenderer.$$$reportNull$$$0(1);
            }
            for (JComponent c : cc) {
                c.setBackground(bg);
                c.setForeground(fg);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/history/integration/ui/views/RecentChangesPopup$RecentChangesListCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

