/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodosTreeBuilder;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitChecksTodosTreeBuilder
extends CustomChangelistTodosTreeBuilder {
    private static final Logger LOG = Logger.getInstance(CommitChecksTodosTreeBuilder.class);
    private final Set<VirtualFile> myIncludedFiles;
    @Nullable
    private final Set<String> myIncludedChangeListsIds;

    public CommitChecksTodosTreeBuilder(@NotNull JTree tree2, @NotNull Project project2, @NotNull Collection<Change> changes2, @NotNull Collection<? extends TodoItem> todoItems) {
        if (tree2 == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(1);
        }
        if (changes2 == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(2);
        }
        if (todoItems == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(3);
        }
        super(tree2, project2, todoItems);
        this.myIncludedFiles = CommitChecksTodosTreeBuilder.collectIncludedFiles(todoItems);
        this.myIncludedChangeListsIds = CommitChecksTodosTreeBuilder.collectIncludedChangeListsIds(project2, changes2);
        if (this.myIncludedChangeListsIds != null && this.myIncludedChangeListsIds.size() > 1) {
            LOG.warn("Processing TODO for multiple changelists might be incorrect" + this.myIncludedChangeListsIds);
        }
    }

    @NotNull
    private static Set<VirtualFile> collectIncludedFiles(@NotNull Collection<? extends TodoItem> todoItems) {
        if (todoItems == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (TodoItem todoItem : todoItems) {
            PsiFile psiFile2 = todoItem.getFile();
            files2.add(psiFile2.getVirtualFile());
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    private static Set<String> collectIncludedChangeListsIds(@NotNull Project project2, @NotNull Collection<? extends Change> changes2) {
        if (project2 == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(6);
        }
        if (changes2 == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(7);
        }
        if (!ChangeListManager.getInstance(project2).areChangeListsEnabled()) {
            return null;
        }
        HashSet<String> ids2 = new HashSet<String>();
        for (Change change : changes2) {
            if (change instanceof ChangeListChange) {
                ChangeListChange changeListChange = (ChangeListChange)change;
                ids2.add(changeListChange.getChangeListId());
                continue;
            }
            return null;
        }
        return ids2;
    }

    @Override
    @NotNull
    protected Set<TodoItem> doFindAllTodoItems(@Nullable TodoFilter todoFilter) {
        ArrayList<Change> allChanges = new ArrayList<Change>();
        if (this.myIncludedChangeListsIds == null) {
            allChanges.addAll(ChangeListManager.getInstance(this.myProject).getAllChanges());
        } else {
            for (String string2 : this.myIncludedChangeListsIds) {
                LocalChangeList changeList = ChangeListManager.getInstance(this.myProject).getChangeList(string2);
                if (changeList == null) continue;
                allChanges.addAll(changeList.getChanges());
            }
        }
        ArrayList<Change> changes2 = new ArrayList<Change>();
        for (Change change : allChanges) {
            FilePath afterPath = ChangesUtil.getAfterPath(change);
            VirtualFile changeFile2 = afterPath != null ? afterPath.getVirtualFile() : null;
            if (changeFile2 == null || !this.myIncludedFiles.contains(changeFile2)) continue;
            changes2.add(change);
        }
        TodoCheckinHandlerWorker todoCheckinHandlerWorker = new TodoCheckinHandlerWorker(this.myProject, PartialChangesUtil.wrapPartialChanges(this.myProject, changes2), todoFilter);
        todoCheckinHandlerWorker.execute();
        Set<TodoItem> set = todoCheckinHandlerWorker.inOneList();
        if (set == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<TodoItem> doFindTodoForFile(@NotNull PsiFile psiFile2, @Nullable TodoFilter todoFilter) {
        VirtualFile file;
        if (psiFile2 == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(9);
        }
        if (!this.myIncludedFiles.contains(file = psiFile2.getVirtualFile())) {
            Set<TodoItem> set = Collections.emptySet();
            if (set == null) {
                CommitChecksTodosTreeBuilder.$$$reportNull$$$0(10);
            }
            return set;
        }
        Change change = ChangeListManager.getInstance(this.myProject).getChange(file);
        if (change == null) {
            Set<TodoItem> set = Collections.emptySet();
            if (set == null) {
                CommitChecksTodosTreeBuilder.$$$reportNull$$$0(11);
            }
            return set;
        }
        List<Change> changes2 = Collections.singletonList(change);
        TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, PartialChangesUtil.wrapPartialChanges(this.myProject, changes2), todoFilter);
        worker.execute();
        Set<TodoItem> set = worker.inOneList();
        if (set == null) {
            CommitChecksTodosTreeBuilder.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoItems";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/CommitChecksTodosTreeBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/CommitChecksTodosTreeBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIncludedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindAllTodoItems";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindTodoForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectIncludedFiles";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectIncludedChangeListsIds";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFindTodoForFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 8, 10, 11, 12 -> new IllegalStateException(string2);
        };
    }
}

