/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.Stack;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlParsing {
    private final PsiBuilder myBuilder;
    private final Stack<HtmlParserStackItem> myItemsStack = new Stack();
    private static final String COMPLETION_NAME = StringUtil.toLowerCase((String)"IntellijIdeaRulezzz");

    public HtmlParsing(PsiBuilder builder2) {
        this.myBuilder = builder2;
    }

    public void parseDocument() {
        PsiBuilder.Marker document2 = this.mark();
        while (this.token() == XmlTokenType.XML_COMMENT_START) {
            this.parseComment();
        }
        this.parseProlog();
        PsiBuilder.Marker error = null;
        while (this.shouldContinueMainLoop()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                error = HtmlParsing.flushError(error);
                this.parseTag();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                error = HtmlParsing.flushError(error);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                error = HtmlParsing.flushError(error);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF || tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_REAL_WHITE_SPACE || tt == XmlTokenType.XML_DATA_CHARACTERS) {
                error = HtmlParsing.flushError(error);
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_END_TAG_START) {
                PsiBuilder.Marker tagEndError = this.myBuilder.mark();
                this.advance();
                if (this.token() == XmlTokenType.XML_NAME) {
                    this.advance();
                    if (this.token() == XmlTokenType.XML_TAG_END) {
                        this.advance();
                    }
                }
                tagEndError.error(XmlPsiBundle.message("xml.parsing.closing.tag.matches.nothing", new Object[0]));
                continue;
            }
            if (this.hasCustomTopLevelContent()) {
                error = this.parseCustomTopLevelContent(error);
                continue;
            }
            if (error == null) {
                error = this.mark();
            }
            this.advance();
        }
        this.flushIncompleteStackItemsWhile(item2 -> true);
        if (error != null) {
            error.error(XmlPsiBundle.message("xml.parsing.top.level.element.is.not.completed", new Object[0]));
        }
        document2.done(XmlElementType.HTML_DOCUMENT);
    }

    protected final void completeTopStackItem() {
        this.popItemFromStack().done(this.myBuilder, null, false);
    }

    protected final void completeTopStackItemBefore(@Nullable PsiBuilder.Marker beforeMarker) {
        this.popItemFromStack().done(this.myBuilder, beforeMarker, false);
    }

    protected final void flushIncompleteStackItemsWhile(Predicate<HtmlParserStackItem> itemFilter) {
        this.flushIncompleteStackItemsWhile(null, itemFilter);
    }

    protected final void flushIncompleteStackItemsWhile(@Nullable PsiBuilder.Marker beforeMarker, Predicate<HtmlParserStackItem> itemFilter) {
        while (!this.myItemsStack.isEmpty() && itemFilter.test((HtmlParserStackItem)this.myItemsStack.peek())) {
            ((HtmlParserStackItem)this.myItemsStack.pop()).done(this.myBuilder, beforeMarker, true);
        }
    }

    protected boolean hasCustomTopLevelContent() {
        return false;
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTopLevelContent(@Nullable PsiBuilder.Marker error) {
        return error;
    }

    protected boolean hasCustomTagContent() {
        return false;
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTagContent(@Nullable PsiBuilder.Marker xmlText) {
        return xmlText;
    }

    protected boolean hasCustomTagHeaderContent() {
        return false;
    }

    protected void parseCustomTagHeaderContent() {
    }

    @Nullable
    protected static PsiBuilder.Marker flushError(PsiBuilder.Marker error) {
        if (error != null) {
            error.error(XmlPsiBundle.message("xml.parsing.unexpected.tokens", new Object[0]));
        }
        return null;
    }

    private void parseDoctype() {
        assert (this.token() == XmlTokenType.XML_DOCTYPE_START) : "Doctype start expected";
        PsiBuilder.Marker doctype = this.mark();
        this.advance();
        while (this.token() != XmlTokenType.XML_DOCTYPE_END && !this.eof()) {
            this.advance();
        }
        if (this.eof()) {
            this.error(XmlPsiBundle.message("xml.parsing.unexpected.end.of.file", new Object[0]));
        } else {
            this.advance();
        }
        doctype.done(XmlElementType.XML_DOCTYPE);
    }

    public void parseTag() {
        assert (this.token() == XmlTokenType.XML_START_TAG_START) : "Tag start expected";
        PsiBuilder.Marker xmlText = null;
        while (this.shouldContinueMainLoop() && this.shouldContinueParsingTag()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                PsiBuilder.Marker tagStart = this.mark();
                this.advance();
                String originalTagName = this.parseOpenTagName();
                HtmlTagInfo info = this.createHtmlTagInfo(originalTagName, tagStart);
                while (this.openingTagAutoClosesTagInStack(info)) {
                    this.completeTopStackItemBefore(tagStart);
                }
                this.pushItemToStack(info);
                this.parseTagHeader(info.getNormalizedName());
                if (this.token() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    this.advance();
                    this.doneTag();
                    continue;
                }
                if (this.token() != XmlTokenType.XML_TAG_END) {
                    this.error(XmlPsiBundle.message("xml.parsing.tag.start.is.not.closed", new Object[0]));
                    this.doneTag();
                    continue;
                }
                this.advance();
                if (!this.isSingleTag(info)) continue;
                PsiBuilder.Marker footer = this.mark();
                while (this.token() == XmlTokenType.XML_REAL_WHITE_SPACE) {
                    this.advance();
                }
                if (this.token() == XmlTokenType.XML_END_TAG_START) {
                    this.advance();
                    if (this.token() == XmlTokenType.XML_NAME && info.getNormalizedName().equalsIgnoreCase(this.myBuilder.getTokenText())) {
                        this.advance();
                        footer.drop();
                        if (this.token() == XmlTokenType.XML_TAG_END) {
                            this.advance();
                        }
                        this.doneTag();
                        continue;
                    }
                }
                footer.rollbackTo();
                this.doneTag();
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN || tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                xmlText = this.startText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_CDATA_START) {
                xmlText = this.startText(xmlText);
                this.parseCData();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                xmlText = this.startText(xmlText);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                xmlText = this.startText(xmlText);
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(XmlPsiBundle.message("xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                continue;
            }
            if (tt instanceof ICustomParsingType || tt instanceof ILazyParseableElementType) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.maybeRemapCurrentToken(tt);
                this.advance();
                continue;
            }
            if (this.token() == XmlTokenType.XML_END_TAG_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                PsiBuilder.Marker footer = this.mark();
                this.advance();
                String endTagName = this.parseEndTagName();
                if (endTagName != null) {
                    HtmlTagInfo tagOnStack;
                    HtmlParserStackItem itemOnStack;
                    endTagName = this.normalizeTagName(endTagName);
                    HtmlParserStackItem htmlParserStackItem = itemOnStack = !this.myItemsStack.isEmpty() ? (HtmlParserStackItem)this.myItemsStack.peek() : null;
                    if (itemOnStack instanceof HtmlTagInfo && !(tagOnStack = (HtmlTagInfo)itemOnStack).getNormalizedName().equals(endTagName) && !StringUtil.toLowerCase((String)endTagName).endsWith(COMPLETION_NAME) || !(itemOnStack instanceof HtmlTagInfo)) {
                        if (itemOnStack instanceof HtmlTagInfo) {
                            HtmlTagInfo tagOnStack2 = (HtmlTagInfo)itemOnStack;
                            if (this.isTagFurtherInStack(endTagName)) {
                                footer.rollbackTo();
                                if (!this.canClosingTagAutoClose(tagOnStack2, endTagName)) {
                                    this.error(XmlPsiBundle.message("xml.parsing.named.element.is.not.closed", tagOnStack2.getOriginalName()));
                                }
                                this.doneTag();
                                continue;
                            }
                        }
                        if (this.token() == XmlTokenType.XML_TAG_END) {
                            this.advance();
                        }
                        footer.error(XmlPsiBundle.message("xml.parsing.closing.tag.matches.nothing", new Object[0]));
                        continue;
                    }
                    while (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_START_TAG_START && this.token() != XmlTokenType.XML_END_TAG_START && !this.eof()) {
                        this.error(XmlPsiBundle.message("xml.parsing.unexpected.token", new Object[0]));
                        this.advance();
                    }
                } else {
                    this.error(XmlPsiBundle.message("xml.parsing.closing.tag.name.missing", new Object[0]));
                }
                footer.drop();
                if (this.token() == XmlTokenType.XML_TAG_END) {
                    this.advance();
                } else {
                    this.error(XmlPsiBundle.message("xml.parsing.closing.tag.is.not.done", new Object[0]));
                }
                if (!this.hasTags()) continue;
                this.doneTag();
                continue;
            }
            if ((this.token() == XmlTokenType.XML_REAL_WHITE_SPACE || this.token() == XmlTokenType.XML_DATA_CHARACTERS) && this.stackSize() == 0) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.advance();
                continue;
            }
            if (this.hasCustomTagContent()) {
                xmlText = this.parseCustomTagContent(xmlText);
                continue;
            }
            xmlText = this.startText(xmlText);
            this.advance();
        }
        HtmlParsing.terminateText(xmlText);
    }

    @NotNull
    protected HtmlTagInfo createHtmlTagInfo(@NotNull String originalTagName, @NotNull PsiBuilder.Marker startMarker) {
        if (originalTagName == null) {
            HtmlParsing.$$$reportNull$$$0(0);
        }
        if (startMarker == null) {
            HtmlParsing.$$$reportNull$$$0(1);
        }
        String normalizedTagName = this.normalizeTagName(originalTagName);
        return new HtmlTagInfoImpl(normalizedTagName, originalTagName, startMarker);
    }

    @NotNull
    protected String parseOpenTagName() {
        String originalTagName;
        if (this.token() != XmlTokenType.XML_NAME) {
            this.error(XmlPsiBundle.message("xml.parsing.tag.name.expected", new Object[0]));
            originalTagName = "";
        } else {
            originalTagName = Objects.requireNonNull(this.myBuilder.getTokenText());
            this.advance();
        }
        String string2 = originalTagName;
        if (string2 == null) {
            HtmlParsing.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    protected String parseEndTagName() {
        String endName;
        if (this.token() == XmlTokenType.XML_NAME) {
            endName = Objects.requireNonNull(this.myBuilder.getTokenText());
            this.advance();
        } else {
            endName = null;
        }
        return endName;
    }

    private void parseTagHeader(String tagName) {
        boolean freeMakerTag = !tagName.isEmpty() && '#' == tagName.charAt(0);
        do {
            IElementType tt = this.token();
            if (freeMakerTag) {
                if (tt == XmlTokenType.XML_EMPTY_ELEMENT_END || tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_END_TAG_START || tt == XmlTokenType.XML_START_TAG_START) break;
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_NAME) {
                this.parseAttribute();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF || tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                this.parseReference();
                continue;
            }
            if (!this.hasCustomTagHeaderContent()) break;
            this.parseCustomTagHeaderContent();
        } while (!this.eof());
    }

    @ApiStatus.OverrideOnly
    protected boolean shouldContinueMainLoop() {
        return !this.eof();
    }

    protected boolean shouldContinueParsingTag() {
        return true;
    }

    protected final boolean hasTags() {
        return !this.myItemsStack.isEmpty() && this.myItemsStack.peek() instanceof HtmlTagInfo;
    }

    protected final void pushItemToStack(@NotNull HtmlParserStackItem item2) {
        if (item2 == null) {
            HtmlParsing.$$$reportNull$$$0(3);
        }
        this.myItemsStack.add((Object)item2);
    }

    @NotNull
    protected final HtmlParserStackItem popItemFromStack() {
        HtmlParserStackItem htmlParserStackItem = (HtmlParserStackItem)this.myItemsStack.pop();
        if (htmlParserStackItem == null) {
            HtmlParsing.$$$reportNull$$$0(4);
        }
        return htmlParserStackItem;
    }

    protected String normalizeTagName(@NotNull String originalTagName) {
        if (originalTagName == null) {
            HtmlParsing.$$$reportNull$$$0(5);
        }
        return StringUtil.toLowerCase((String)originalTagName);
    }

    protected final int stackSize() {
        return this.myItemsStack.size();
    }

    @NotNull
    protected final HtmlParserStackItem peekStackItem() {
        HtmlParserStackItem htmlParserStackItem = (HtmlParserStackItem)this.myItemsStack.peek();
        if (htmlParserStackItem == null) {
            HtmlParsing.$$$reportNull$$$0(6);
        }
        return htmlParserStackItem;
    }

    @NotNull
    protected final HtmlTagInfo peekTagInfo() {
        HtmlTagInfo htmlTagInfo = (HtmlTagInfo)this.myItemsStack.peek();
        if (htmlTagInfo == null) {
            HtmlParsing.$$$reportNull$$$0(7);
        }
        return htmlTagInfo;
    }

    protected final void processStackItems(@NotNull Processor<? super HtmlParserStackItem> processor2) {
        if (processor2 == null) {
            HtmlParsing.$$$reportNull$$$0(8);
        }
        for (int i = this.myItemsStack.size() - 1; i >= 0; --i) {
            if (processor2.process(this.myItemsStack.get(i))) continue;
            return;
        }
    }

    private boolean isTagFurtherInStack(@NotNull String tagName) {
        if (tagName == null) {
            HtmlParsing.$$$reportNull$$$0(9);
        }
        for (int i = this.myItemsStack.size() - 1; i >= 0; --i) {
            HtmlParserStackItem item2 = (HtmlParserStackItem)this.myItemsStack.get(i);
            if (item2 instanceof HtmlTagInfo) {
                HtmlTagInfo tagInfo = (HtmlTagInfo)item2;
                if (!tagInfo.getNormalizedName().equals(tagName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected final void doneTag() {
        if (!(this.peekStackItem() instanceof HtmlTagInfo)) {
            throw new IllegalStateException("Unexpected item on stack: " + this.myItemsStack);
        }
        this.completeTopStackItem();
    }

    protected IElementType getHtmlTagElementType(@NotNull HtmlTagInfo info, int tagLevel) {
        if (info == null) {
            HtmlParsing.$$$reportNull$$$0(10);
        }
        return XmlElementType.HTML_TAG;
    }

    private boolean openingTagAutoClosesTagInStack(HtmlTagInfo openingTag) {
        Ref result2 = new Ref((Object)false);
        this.processStackItems((Processor<? super HtmlParserStackItem>)((Processor)item2 -> {
            if (item2 instanceof HtmlTagInfo) {
                HtmlTagInfo tagToClose = (HtmlTagInfo)item2;
                ThreeState canClose = this.canOpeningTagAutoClose(tagToClose, openingTag);
                if (canClose != ThreeState.UNSURE) {
                    result2.set((Object)canClose.toBoolean());
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }));
        return (Boolean)result2.get();
    }

    protected boolean isSingleTag(@NotNull HtmlTagInfo tagInfo) {
        if (tagInfo == null) {
            HtmlParsing.$$$reportNull$$$0(11);
        }
        return HtmlUtil.isSingleHtmlTag(tagInfo.getNormalizedName(), true);
    }

    protected boolean isEndTagRequired(@NotNull HtmlTagInfo tagInfo) {
        if (tagInfo == null) {
            HtmlParsing.$$$reportNull$$$0(12);
        }
        return !HtmlUtil.isTagWithOptionalEnd(tagInfo.getNormalizedName(), true) && !"html".equals(tagInfo.getNormalizedName()) && !"body".equals(tagInfo.getNormalizedName());
    }

    @NotNull
    protected ThreeState canOpeningTagAutoClose(@NotNull HtmlTagInfo tagToClose, @NotNull HtmlTagInfo openingTag) {
        if (tagToClose == null) {
            HtmlParsing.$$$reportNull$$$0(13);
        }
        if (openingTag == null) {
            HtmlParsing.$$$reportNull$$$0(14);
        }
        ThreeState threeState = HtmlUtil.canOpeningTagAutoClose(tagToClose.getNormalizedName(), openingTag.getNormalizedName(), true);
        if (threeState == null) {
            HtmlParsing.$$$reportNull$$$0(15);
        }
        return threeState;
    }

    protected boolean canClosingTagAutoClose(@NotNull HtmlTagInfo tagToClose, @NotNull String closingTag) {
        if (tagToClose == null) {
            HtmlParsing.$$$reportNull$$$0(16);
        }
        if (closingTag == null) {
            HtmlParsing.$$$reportNull$$$0(17);
        }
        return HtmlUtil.canClosingTagAutoClose(tagToClose.getNormalizedName(), closingTag, true);
    }

    @NotNull
    protected PsiBuilder.Marker startText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText == null) {
            xmlText = this.mark();
        }
        PsiBuilder.Marker marker = xmlText;
        if (marker == null) {
            HtmlParsing.$$$reportNull$$$0(18);
        }
        return marker;
    }

    @Nullable
    protected static PsiBuilder.Marker terminateText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText != null) {
            xmlText.done(XmlElementType.XML_TEXT);
        }
        return null;
    }

    protected void parseCData() {
        assert (this.token() == XmlTokenType.XML_CDATA_START);
        PsiBuilder.Marker cdata = this.mark();
        while (this.token() != XmlTokenType.XML_CDATA_END && !this.eof()) {
            this.advance();
        }
        if (!this.eof()) {
            this.advance();
        }
        cdata.done(XmlElementType.XML_CDATA);
    }

    protected void parseComment() {
        IElementType tt;
        PsiBuilder.Marker comment = this.mark();
        this.advance();
        while (true) {
            if ((tt = this.token()) == XmlTokenType.XML_COMMENT_CHARACTERS || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_START || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_START_END || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_END_START || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_END) {
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN || tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                this.parseReference();
                continue;
            }
            if (tt != XmlTokenType.XML_BAD_CHARACTER) break;
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlPsiBundle.message("xml.parsing.bad.character", new Object[0]));
        }
        if (tt == XmlTokenType.XML_COMMENT_END) {
            this.advance();
        }
        comment.done(XmlElementType.XML_COMMENT);
    }

    protected void parseReference() {
        if (this.token() == XmlTokenType.XML_CHAR_ENTITY_REF) {
            this.advance();
        } else if (this.token() == XmlTokenType.XML_ENTITY_REF_TOKEN) {
            PsiBuilder.Marker ref = this.mark();
            this.advance();
            ref.done(XmlElementType.XML_ENTITY_REF);
        } else assert (false) : "Unexpected token";
    }

    protected void parseAttribute() {
        assert (this.token() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.mark();
        this.advance();
        if (this.token() == XmlTokenType.XML_EQ) {
            this.advance();
            this.parseAttributeValue();
        }
        att.done(this.getHtmlAttributeElementType());
    }

    protected IElementType getHtmlAttributeElementType() {
        return XmlElementType.XML_ATTRIBUTE;
    }

    protected void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.mark();
        if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.token()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlPsiBundle.message("xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                    continue;
                }
                if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                this.maybeRemapCurrentToken(tt);
                this.advance();
            }
            if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message("xml.parsing.unclosed.attribute.value", new Object[0]));
            }
        } else if (this.hasCustomAttributeValue()) {
            this.parseCustomAttributeValue();
        } else {
            IElementType tt = this.token();
            if (tt != XmlTokenType.XML_TAG_END && tt != XmlTokenType.XML_EMPTY_ELEMENT_END) {
                if (tt != null) {
                    this.maybeRemapCurrentToken(tt);
                }
                this.advance();
            }
        }
        attValue.done(this.getHtmlAttributeValueElementType());
    }

    protected IElementType getHtmlAttributeValueElementType() {
        return XmlElementType.XML_ATTRIBUTE_VALUE;
    }

    protected boolean hasCustomAttributeValue() {
        return false;
    }

    protected void parseCustomAttributeValue() {
    }

    protected void parseProlog() {
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlTokenType.XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (tt != XmlTokenType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        PsiBuilder.Marker prolog = this.mark();
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlTokenType.XML_PI_START) {
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_DOCTYPE_START) {
                this.parseDoctype();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (tt != XmlTokenType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        prolog.done(XmlElementType.XML_PROLOG);
    }

    protected void parseProcessingInstruction() {
        assert (this.token() == XmlTokenType.XML_PI_START);
        PsiBuilder.Marker pi = this.mark();
        this.advance();
        if (this.token() == XmlTokenType.XML_NAME || this.token() == XmlTokenType.XML_PI_TARGET) {
            this.advance();
        }
        while (this.token() == XmlTokenType.XML_NAME) {
            this.advance();
            if (this.token() == XmlTokenType.XML_EQ) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message("xml.parsing.expected.attribute.eq.sign", new Object[0]));
            }
            this.parseAttributeValue();
        }
        if (this.token() == XmlTokenType.XML_PI_END) {
            this.advance();
        } else {
            this.error(XmlPsiBundle.message("xml.parsing.unterminated.processing.instruction", new Object[0]));
        }
        pi.done(XmlElementType.XML_PROCESSING_INSTRUCTION);
    }

    protected final PsiBuilder getBuilder() {
        return this.myBuilder;
    }

    protected final IElementType token() {
        return this.myBuilder.getTokenType();
    }

    protected final boolean eof() {
        return this.myBuilder.eof();
    }

    protected final void advance() {
        this.myBuilder.advanceLexer();
    }

    protected final PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    protected void error(@NotNull @NlsContexts.ParsingError String message2) {
        if (message2 == null) {
            HtmlParsing.$$$reportNull$$$0(19);
        }
        this.myBuilder.error(message2);
    }

    @ApiStatus.Experimental
    protected void maybeRemapCurrentToken(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            HtmlParsing.$$$reportNull$$$0(20);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startMarker";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/html/HtmlParsing";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagInfo";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagToClose";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingTag";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/html/HtmlParsing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseOpenTagName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "popItemFromStack";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "peekStackItem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "peekTagInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "canOpeningTagAutoClose";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "startText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlTagInfo";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pushItemToStack";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTagName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processStackItems";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTagFurtherInStack";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlTagElementType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSingleTag";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEndTagRequired";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canOpeningTagAutoClose";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canClosingTagAutoClose";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "maybeRemapCurrentToken";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6, 7, 15, 18 -> new IllegalStateException(string2);
        };
    }

    public static interface HtmlParserStackItem {
        public void done(@NotNull PsiBuilder var1, @Nullable PsiBuilder.Marker var2, boolean var3);
    }

    public static interface HtmlTagInfo
    extends HtmlParserStackItem {
        @NotNull
        public String getNormalizedName();

        @NotNull
        public String getOriginalName();
    }

    protected class HtmlTagInfoImpl
    implements HtmlTagInfo {
        @NotNull
        private final String normalizedName;
        @NotNull
        private final String originalName;
        @NotNull
        private final PsiBuilder.Marker startMarker;

        protected HtmlTagInfoImpl(@NotNull String normalizedName, @NotNull String originalName, PsiBuilder.Marker marker) {
            if (normalizedName == null) {
                HtmlTagInfoImpl.$$$reportNull$$$0(0);
            }
            if (originalName == null) {
                HtmlTagInfoImpl.$$$reportNull$$$0(1);
            }
            if (marker == null) {
                HtmlTagInfoImpl.$$$reportNull$$$0(2);
            }
            this.normalizedName = normalizedName;
            this.originalName = originalName;
            this.startMarker = marker;
        }

        @Override
        @NotNull
        public String getNormalizedName() {
            String string2 = this.normalizedName;
            if (string2 == null) {
                HtmlTagInfoImpl.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getOriginalName() {
            String string2 = this.originalName;
            if (string2 == null) {
                HtmlTagInfoImpl.$$$reportNull$$$0(4);
            }
            return string2;
        }

        @Override
        public void done(@NotNull PsiBuilder builder2, @Nullable PsiBuilder.Marker beforeMarker, boolean incomplete) {
            if (builder2 == null) {
                HtmlTagInfoImpl.$$$reportNull$$$0(5);
            }
            IElementType myElementType = HtmlParsing.this.getHtmlTagElementType(this, HtmlParsing.this.myItemsStack.size() + 1);
            if (beforeMarker == null) {
                if (incomplete && HtmlParsing.this.isEndTagRequired(this)) {
                    builder2.error(XmlPsiBundle.message("xml.parsing.named.element.is.not.closed", this.getOriginalName()));
                }
                this.startMarker.done(myElementType);
            } else {
                if (incomplete && HtmlParsing.this.isEndTagRequired(this)) {
                    beforeMarker.precede().errorBefore(XmlPsiBundle.message("xml.parsing.named.element.is.not.closed", this.getOriginalName()), beforeMarker);
                }
                this.startMarker.doneBefore(myElementType, beforeMarker);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "normalizedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/html/HtmlParsing$HtmlTagInfoImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/html/HtmlParsing$HtmlTagInfoImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4 -> new IllegalStateException(string2);
            };
        }
    }
}

