/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\b\u0010\u0012\u001a\u00020\nH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0014J\b\u0010\u0015\u001a\u00020\nH\u0014J\b\u0010\u0016\u001a\u00020\nH\u0014J\b\u0010\u0017\u001a\u00020\u000fH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesTreeEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "targetComponent", "Ljavax/swing/JComponent;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljavax/swing/JComponent;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "handleDoubleClick", "", "e", "Ljava/awt/event/MouseEvent;", "handleEnterKey", "handleEscapeKey", "", "handleNextDiffShortcut", "handleSingleClick", "isOpenPreviewWithNextDiffShortcut", "isOpenPreviewWithSingleClick", "isOpenPreviewWithSingleClickEnabled", "isPreviewOnDoubleClick", "isPreviewOnEnter", "returnFocusToTree", "PreviewOnNextDiffAction", "intellij.platform.vcs.impl"})
public abstract class ChangesTreeEditorDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    private final ChangesTree tree;

    public ChangesTreeEditorDiffPreview(@NotNull ChangesTree tree2, @NotNull JComponent targetComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        Project project2 = tree2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        super(project2);
        this.tree = tree2;
        this.tree.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$0(this, arg_0)));
        this.tree.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$1(this, arg_0)));
        this.tree.addSelectionListener(() -> ChangesTreeEditorDiffPreview._init_$lambda$2(this));
        new PreviewOnNextDiffAction().registerCustomShortcutSet(targetComponent, (Disposable)this);
        UIUtil.putClientProperty((JComponent)((JComponent)((Object)this.tree)), (Key)ExpandableItemsHandler.IGNORE_ITEM_SELECTION, (Object)true);
    }

    public /* synthetic */ ChangesTreeEditorDiffPreview(ChangesTree changesTree, JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jComponent = (JComponent)((Object)changesTree);
        }
        this(changesTree, jComponent);
    }

    @NotNull
    protected final ChangesTree getTree() {
        return this.tree;
    }

    protected boolean isPreviewOnDoubleClick() {
        return true;
    }

    protected boolean handleDoubleClick(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isPreviewOnDoubleClick()) {
            return false;
        }
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.tree)), (MouseEvent)e)) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isPreviewOnEnter() {
        return true;
    }

    protected boolean handleEnterKey() {
        if (!this.isPreviewOnEnter()) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isOpenPreviewWithSingleClickEnabled() {
        return false;
    }

    protected boolean isOpenPreviewWithSingleClick() {
        if (!this.isOpenPreviewWithSingleClickEnabled()) {
            return false;
        }
        if (ToolWindowManager.Companion.getInstance(this.getProject()).isEditorComponentActive()) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.tree), (Object)IdeFocusManager.getInstance((Project)this.tree.getProject()).getFocusOwner());
    }

    protected void handleSingleClick() {
        if (!this.isOpenPreviewWithSingleClick()) {
            return;
        }
        boolean opened = this.openPreview(false);
        if (!opened) {
            this.closePreview();
        }
    }

    protected boolean isOpenPreviewWithNextDiffShortcut() {
        return false;
    }

    protected void handleNextDiffShortcut() {
        if (!this.isOpenPreviewWithNextDiffShortcut()) {
            return;
        }
        this.openPreview(true);
    }

    @Override
    protected void handleEscapeKey() {
        this.closePreview();
        this.returnFocusToTree();
    }

    protected void returnFocusToTree() {
    }

    private static final boolean _init_$lambda$0(ChangesTreeEditorDiffPreview this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)e);
        return this$0.handleDoubleClick(e);
    }

    private static final boolean _init_$lambda$1(ChangesTreeEditorDiffPreview this$0, KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.handleEnterKey();
    }

    private static final void _init_$lambda$2(ChangesTreeEditorDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleSingleClick();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesTreeEditorDiffPreview$PreviewOnNextDiffAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/openapi/vcs/changes/ChangesTreeEditorDiffPreview;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.vcs.impl"})
    private final class PreviewOnNextDiffAction
    extends DumbAwareAction {
        public PreviewOnNextDiffAction() {
            this.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(ChangesTreeEditorDiffPreview.this.isOpenPreviewWithNextDiffShortcut());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChangesTreeEditorDiffPreview.this.handleNextDiffShortcut();
        }
    }
}

