/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesCheckerKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0013\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreFilesChecker;", "Lcom/intellij/openapi/vcs/VcsMappingListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "directoryMappingChanged", "", "generateVcsIgnoreFileInRootIfNeeded", "getProjectConfigDirOrProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsIgnoreFilesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsIgnoreFilesChecker.kt\ncom/intellij/openapi/vcs/changes/VcsIgnoreFilesChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class VcsIgnoreFilesChecker
implements VcsMappingListener {
    @NotNull
    private final Project project;

    public VcsIgnoreFilesChecker(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void directoryMappingChanged() {
        ProjectLevelVcsManager.getInstance(this.project).runAfterInitialization(() -> VcsIgnoreFilesChecker.directoryMappingChanged$lambda$1(this));
    }

    private final void generateVcsIgnoreFileInRootIfNeeded(Project project2) {
        if (project2.isDisposed()) {
            return;
        }
        VirtualFile virtualFile = this.getProjectConfigDirOrProjectFile(project2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile projectFile = virtualFile;
        VirtualFile virtualFile2 = VcsUtil.getVcsRootFor(project2, projectFile);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile projectFileVcsRoot = virtualFile2;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor(project2, projectFileVcsRoot);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        VcsIgnoreFilesCheckerKt.access$getLOG$p().debug("Propose manage VCS ignore in " + projectFileVcsRoot.getPath() + " for vcs " + vcs.getName());
        VcsImplUtil.proposeUpdateIgnoreFile(project2, vcs, projectFileVcsRoot);
    }

    private final VirtualFile getProjectConfigDirOrProjectFile(Project $this$getProjectConfigDirOrProjectFile) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)$this$getProjectConfigDirOrProjectFile)) {
            Path path2 = ProjectKt.getStateStore((Project)$this$getProjectConfigDirOrProjectFile).getDirectoryStorePath();
            if (path2 != null) {
                Path path3 = path2;
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
                LocalFileSystem localFileSystem2 = localFileSystem;
                Path p0 = path3;
                boolean bl = false;
                virtualFile = localFileSystem2.findFileByNioFile(p0);
            } else {
                virtualFile = null;
            }
        } else {
            virtualFile = $this$getProjectConfigDirOrProjectFile.getProjectFile();
        }
        return virtualFile;
    }

    private static final void directoryMappingChanged$lambda$1$lambda$0(VcsIgnoreFilesChecker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.generateVcsIgnoreFileInRootIfNeeded(this$0.project);
    }

    private static final void directoryMappingChanged$lambda$1(VcsIgnoreFilesChecker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)this$0.project), () -> VcsIgnoreFilesChecker.directoryMappingChanged$lambda$1$lambda$0(this$0));
    }
}

