/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableGoToChangePopupAction<T>
extends GoToChangePopupBuilder.BaseGoToChangePopupAction {
    @NotNull
    protected abstract ListSelection<? extends T> getChanges();

    @Nullable
    protected abstract PresentableChange getPresentation(@NotNull T var1);

    protected boolean canNavigate() {
        return this.getChanges().getList().size() > 1;
    }

    protected abstract void onSelected(@NotNull T var1);

    @NotNull
    protected JBPopup createPopup(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        Ref popup2 = new Ref();
        final MyChangesBrowser cb = new MyChangesBrowser(project2, (Ref<? extends JBPopup>)popup2);
        popup2.set((Object)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)cb, cb.getPreferredFocusedComponent()).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setDimensionServiceKey(project2, "Diff.GoToChangePopup", false).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                cb.shutdown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$1", "onClosed"));
            }
        }).createPopup());
        JBPopup jBPopup = (JBPopup)popup2.get();
        if (jBPopup == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(1);
        }
        return jBPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private class MyChangesBrowser
    extends AsyncChangesBrowserBase {
        @NotNull
        private final Ref<? extends JBPopup> myRef;
        @NotNull
        private final ListSelection<? extends T> myChanges;

        MyChangesBrowser(@NotNull Project project2, Ref<? extends JBPopup> popupRef) {
            if (project2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (popupRef == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project2, false, false);
            this.hideViewerBorder();
            this.myRef = popupRef;
            this.myChanges = PresentableGoToChangePopupAction.this.getChanges();
            this.myViewer.setSelectionMode(1);
            this.init();
            AsyncChangesTree viewer = this.getViewer();
            viewer.requestRefresh();
            if (this.myChanges.getSelectedIndex() != -1) {
                UiNotifyConnector.doWhenFirstShown((JComponent)this, () -> viewer.invokeAfterRefresh(() -> {
                    DefaultMutableTreeNode toSelect = TreeUtil.findNode(this.myViewer.getRoot(), node -> node instanceof GenericChangesBrowserNode && ((GenericChangesBrowserNode)node).getIndex() == this.myChanges.getSelectedIndex());
                    if (toSelect != null) {
                        TreeUtil.selectNode((JTree)((Object)this.myViewer), (TreeNode)toSelect);
                    }
                }));
            }
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            return new MyAsyncChangesTreeModel(this.myProject, this.myChanges.getList());
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        protected void onDoubleClick() {
            ((JBPopup)this.myRef.get()).cancel();
            ChangesBrowserNode selection = (ChangesBrowserNode)VcsTreeModelData.selected((JTree)((Object)this.myViewer)).iterateNodes().first();
            GenericChangesBrowserNode node = (GenericChangesBrowserNode)ObjectUtils.tryCast((Object)selection, GenericChangesBrowserNode.class);
            if (node == null) {
                return;
            }
            Object newSelection = this.myChanges.getList().get(node.getIndex());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> PresentableGoToChangePopupAction.this.onSelected(newSelection));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupRef";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder(@NotNull Project project2, @NotNull ChangesGroupingPolicyFactory grouping) {
            if (project2 == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            if (grouping == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            super(project2, grouping);
        }

        public void setGenericNodes(@NotNull Collection<? extends GenericChangesBrowserNode> nodes, @Nullable ChangesBrowserNode.Tag tag) {
            if (nodes == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            ChangesBrowserNode<?> parentNode = this.createTagNode(tag);
            for (GenericChangesBrowserNode node : ContainerUtil.sorted(nodes, Comparator.comparing(data2 -> data2.getFilePath(), PATH_COMPARATOR))) {
                this.insertChangeNode(node.getFilePath(), parentNode, (ChangesBrowserNode<?>)node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGenericNodes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GenericChangesBrowserNode
    extends ChangesBrowserNode<FilePath>
    implements Comparable<GenericChangesBrowserNode> {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final FileStatus myFileStatus;
        private final int myIndex;

        GenericChangesBrowserNode(@NotNull FilePath filePath, @NotNull FileStatus fileStatus, int index) {
            if (filePath == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(0);
            }
            if (fileStatus == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(1);
            }
            super(filePath);
            this.myFilePath = filePath;
            this.myFileStatus = fileStatus;
            this.myIndex = index;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myFileStatus;
            if (fileStatus == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Override
        protected boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        protected boolean isDirectory() {
            return this.myFilePath.isDirectory();
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            if (renderer2 == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(4);
            }
            renderer2.appendFileName(this.myFilePath.getVirtualFile(), this.myFilePath.getName(), this.myFileStatus.getColor());
            if (renderer2.isShowFlatten()) {
                this.appendParentPath(renderer2, this.myFilePath.getParentPath());
            }
            if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
                this.appendCount(renderer2);
            }
            renderer2.setIcon(this.myFilePath, this.myFilePath.isDirectory() || !this.isLeaf());
        }

        @Override
        public String getTextPresentation() {
            return this.myFilePath.getName();
        }

        @Override
        public String toString() {
            return FileUtil.toSystemDependentName((String)this.myFilePath.getPath());
        }

        @Override
        public int compareTo(@NotNull GenericChangesBrowserNode o) {
            if (o == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(5);
            }
            return GenericChangesBrowserNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileStatus";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$GenericChangesBrowserNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$GenericChangesBrowserNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyAsyncChangesTreeModel
    extends SimpleAsyncChangesTreeModel {
        private final Project myProject;
        private final List<? extends T> myChanges;

        private MyAsyncChangesTreeModel(@NotNull Project project2, List<? extends T> changes2) {
            if (project2 == null) {
                MyAsyncChangesTreeModel.$$$reportNull$$$0(0);
            }
            if (changes2 == null) {
                MyAsyncChangesTreeModel.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myChanges = changes2;
        }

        @Override
        @NotNull
        public DefaultTreeModel buildTreeModelSync(@NotNull ChangesGroupingPolicyFactory grouping) {
            if (grouping == null) {
                MyAsyncChangesTreeModel.$$$reportNull$$$0(2);
            }
            MultiMap groups = MultiMap.createLinked();
            for (int i = 0; i < this.myChanges.size(); ++i) {
                PresentableChange change = PresentableGoToChangePopupAction.this.getPresentation(this.myChanges.get(i));
                if (change == null) continue;
                FilePath filePath = change.getFilePath();
                FileStatus fileStatus = change.getFileStatus();
                ChangesBrowserNode.Tag tag = change.getTag();
                groups.putValue((Object)tag, (Object)new GenericChangesBrowserNode(filePath, fileStatus, i));
            }
            MyTreeModelBuilder builder2 = new MyTreeModelBuilder(this.myProject, grouping);
            for (ChangesBrowserNode.Tag tag : groups.keySet()) {
                builder2.setGenericNodes(groups.get((Object)tag), tag);
            }
            DefaultTreeModel defaultTreeModel = builder2.build();
            if (defaultTreeModel == null) {
                MyAsyncChangesTreeModel.$$$reportNull$$$0(3);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyAsyncChangesTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyAsyncChangesTreeModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModelSync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModelSync";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    public static abstract class Default<T extends PresentableChange>
    extends PresentableGoToChangePopupAction<T> {
        @Override
        protected PresentableChange getPresentation(@NotNull T change) {
            if (change == null) {
                Default.$$$reportNull$$$0(0);
            }
            return change;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$Default", "getPresentation"));
        }
    }
}

