/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class CommonBinaryFilePatchInProgress<T extends FilePatch>
extends AbstractFilePatchInProgress<T> {
    protected CommonBinaryFilePatchInProgress(T patch, Collection<VirtualFile> autoBases, VirtualFile baseDir2) {
        super(patch, autoBases, baseDir2);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision != null) {
            return this.myNewContentRevision;
        }
        if (this.myPatch.getAfterFileName() != null) {
            FilePath newFilePath = this.getFilePath();
            this.myNewContentRevision = this.createNewContentRevision(newFilePath);
        }
        return this.myNewContentRevision;
    }

    @NotNull
    protected abstract BinaryContentRevision createNewContentRevision(@NotNull FilePath var1);

    @NotNull
    protected abstract Change createChange(Project var1);

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project2, PatchReader baseContents) {
        return new DiffRequestProducer(){

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator == null) {
                    1.$$$reportNull$$$0(1);
                }
                DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project2, CommonBinaryFilePatchInProgress.this.createChange(project2), this.getName(), context, indicator);
                if (diffRequest == null) {
                    1.$$$reportNull$$$0(2);
                }
                return diffRequest;
            }

            @NotNull
            public String getName() {
                File file1 = new File(VfsUtilCore.virtualToIoFile((VirtualFile)CommonBinaryFilePatchInProgress.this.getBase()), CommonBinaryFilePatchInProgress.this.myPatch.getAfterName() == null ? CommonBinaryFilePatchInProgress.this.myPatch.getBeforeName() : CommonBinaryFilePatchInProgress.this.myPatch.getAfterName());
                String string2 = FileUtil.toSystemDependentName((String)file1.getPath());
                if (string2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string2;
            }

            @NotNull
            public FileType getContentType() {
                FileType fileType = CommonBinaryFilePatchInProgress.this.getFilePath().getFileType();
                if (fileType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return fileType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "process";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2, 3, 4 -> new IllegalStateException(string2);
                };
            }
        };
    }
}

