/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesCommitExecutor
extends LocalCommitExecutor {
    private static final Logger LOG = Logger.getInstance(ShelveChangesCommitExecutor.class);
    private final Project myProject;

    public ShelveChangesCommitExecutor(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    @Nls
    public String getActionText() {
        String string2 = VcsBundle.message("shelve.changes.action", new Object[0]);
        if (string2 == null) {
            ShelveChangesCommitExecutor.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
        if (commitContext == null) {
            ShelveChangesCommitExecutor.$$$reportNull$$$0(1);
        }
        return new ShelveChangesCommitSession();
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.shelve";
    }

    @Override
    public boolean supportsPartialCommit() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCommitSession";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }

    private class ShelveChangesCommitSession
    implements CommitSession {
        private ShelveChangesCommitSession() {
        }

        @Override
        public void execute(@NotNull Collection<? extends Change> changes2, @Nullable String commitMessage) {
            if (changes2 == null) {
                ShelveChangesCommitSession.$$$reportNull$$$0(0);
            }
            if (changes2.size() > 0 && !ChangesUtil.hasFileChanges(changes2)) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message("shelve.changes.only.directories", new Object[0]), (String)VcsBundle.message("shelve.changes.action", new Object[0])), null, (Project)ShelveChangesCommitExecutor.this.myProject);
                return;
            }
            try {
                ShelvedChangeList list2 = ShelveChangesManager.getInstance(ShelveChangesCommitExecutor.this.myProject).shelveChanges(changes2, commitMessage, true, false, true);
                ShelvedChangesViewManager.getInstance(ShelveChangesCommitExecutor.this.myProject).activateView(list2);
                Change[] changesArray = changes2.toArray(Change.EMPTY_CHANGE_ARRAY);
                LocalChangeList changeList = ChangesUtil.getChangeListIfOnlyOne(ShelveChangesCommitExecutor.this.myProject, changesArray);
                if (changeList != null) {
                    ChangeListManager.getInstance(ShelveChangesCommitExecutor.this.myProject).scheduleAutomaticEmptyChangeListDeletion(changeList, true);
                }
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message("create.patch.error.title", ex.getMessage()), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.nonModal(), (Project)ShelveChangesCommitExecutor.this.myProject);
            }
        }

        @Override
        public String getHelpId() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor$ShelveChangesCommitSession", "execute"));
        }
    }
}

