/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncChangesTreeImpl<T>
extends AsyncChangesTree {
    @NotNull
    private List<T> myChanges;
    @NotNull
    private final Class<T> myClazz;

    public AsyncChangesTreeImpl(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems, @NotNull Class<T> clazz) {
        if (project2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(1);
        }
        super(project2, showCheckboxes, highlightProblems);
        this.myChanges = Collections.emptyList();
        this.myClazz = clazz;
    }

    public AsyncChangesTreeImpl(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems, @NotNull Class<T> clazz, @NotNull List<? extends T> changes2) {
        if (project2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(3);
        }
        if (changes2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(4);
        }
        this(project2, showCheckboxes, highlightProblems, clazz);
        if (showCheckboxes) {
            this.setIncludedChanges(changes2);
        }
        this.setChangesToDisplay(changes2);
    }

    public void setChangesToDisplay(@NotNull Collection<? extends T> changes2) {
        if (changes2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChanges = new ArrayList<T>(changes2);
        this.rebuildTree();
    }

    @Override
    @NotNull
    protected AsyncChangesTreeModel getChangesTreeModel() {
        AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> this.buildTreeModel((ChangesGroupingPolicyFactory)grouping, (List<? extends T>)this.myChanges));
        if (asyncChangesTreeModel == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(6);
        }
        return asyncChangesTreeModel;
    }

    @NotNull
    @RequiresBackgroundThread
    protected abstract DefaultTreeModel buildTreeModel(@NotNull ChangesGroupingPolicyFactory var1, @NotNull List<? extends T> var2);

    @NotNull
    public List<T> getChanges() {
        List list2 = ContainerUtil.filterIsInstance(this.myChanges, this.myClazz);
        if (list2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public List<T> getDisplayedChanges() {
        List<T> list2 = VcsTreeModelData.all((JTree)((Object)this)).userObjects(this.myClazz);
        if (list2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public List<T> getSelectedChanges() {
        List<T> list2 = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(this.myClazz);
        if (list2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public Collection<T> getIncludedChanges() {
        List<T> list2 = VcsTreeModelData.included(this).userObjects(this.myClazz);
        if (list2 == null) {
            AsyncChangesTreeImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesTreeModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedChanges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChangesToDisplay";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }

    public static class VirtualFiles
    extends AsyncChangesTreeImpl<VirtualFile> {
        public VirtualFiles(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems) {
            if (project2 == null) {
                VirtualFiles.$$$reportNull$$$0(0);
            }
            super(project2, showCheckboxes, highlightProblems, VirtualFile.class);
        }

        public VirtualFiles(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems, @NotNull List<? extends VirtualFile> files2) {
            if (project2 == null) {
                VirtualFiles.$$$reportNull$$$0(1);
            }
            if (files2 == null) {
                VirtualFiles.$$$reportNull$$$0(2);
            }
            super(project2, showCheckboxes, highlightProblems, VirtualFile.class, files2);
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull ChangesGroupingPolicyFactory grouping, @NotNull List<? extends VirtualFile> changes2) {
            if (grouping == null) {
                VirtualFiles.$$$reportNull$$$0(3);
            }
            if (changes2 == null) {
                VirtualFiles.$$$reportNull$$$0(4);
            }
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromVirtualFiles(this.myProject, grouping, changes2);
            if (defaultTreeModel == null) {
                VirtualFiles.$$$reportNull$$$0(5);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl$VirtualFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl$VirtualFiles";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5 -> new IllegalStateException(string2);
            };
        }
    }

    public static class FilePaths
    extends AsyncChangesTreeImpl<FilePath> {
        public FilePaths(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems) {
            if (project2 == null) {
                FilePaths.$$$reportNull$$$0(0);
            }
            super(project2, showCheckboxes, highlightProblems, FilePath.class);
        }

        public FilePaths(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems, @NotNull List<? extends FilePath> paths) {
            if (project2 == null) {
                FilePaths.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                FilePaths.$$$reportNull$$$0(2);
            }
            super(project2, showCheckboxes, highlightProblems, FilePath.class, paths);
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull ChangesGroupingPolicyFactory grouping, @NotNull List<? extends FilePath> changes2) {
            if (grouping == null) {
                FilePaths.$$$reportNull$$$0(3);
            }
            if (changes2 == null) {
                FilePaths.$$$reportNull$$$0(4);
            }
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromFilePaths(this.myProject, grouping, changes2);
            if (defaultTreeModel == null) {
                FilePaths.$$$reportNull$$$0(5);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl$FilePaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl$FilePaths";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5 -> new IllegalStateException(string2);
            };
        }
    }

    public static class Changes
    extends AsyncChangesTreeImpl<Change> {
        public Changes(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems) {
            if (project2 == null) {
                Changes.$$$reportNull$$$0(0);
            }
            super(project2, showCheckboxes, highlightProblems, Change.class);
        }

        public Changes(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems, @NotNull List<? extends Change> changes2) {
            if (project2 == null) {
                Changes.$$$reportNull$$$0(1);
            }
            if (changes2 == null) {
                Changes.$$$reportNull$$$0(2);
            }
            super(project2, showCheckboxes, highlightProblems, Change.class, changes2);
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull ChangesGroupingPolicyFactory grouping, @NotNull List<? extends Change> changes2) {
            if (grouping == null) {
                Changes.$$$reportNull$$$0(3);
            }
            if (changes2 == null) {
                Changes.$$$reportNull$$$0(4);
            }
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges(this.myProject, grouping, changes2, null);
            if (defaultTreeModel == null) {
                Changes.$$$reportNull$$$0(5);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl$Changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/AsyncChangesTreeImpl$Changes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5 -> new IllegalStateException(string2);
            };
        }
    }
}

