/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImplKt;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002/0B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020\u0017H\u0016J\u0012\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0015H\u0003J\b\u0010*\u001a\u00020\u0017H\u0003J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\bH\u0003J\b\u0010,\u001a\u00020\u0017H\u0003J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\bH\u0002J\b\u0010.\u001a\u00020\u0017H\u0007RN\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0014\u001a6\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0006\u0012\u0004\u0018\u00010\u0015 \t*\u001a\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl;", "Lcom/intellij/openapi/vcs/FileStatusManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedStatuses", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/FileStatus;", "", "dirtyDocuments", "Lit/unimi/dsi/fastutil/objects/Object2BooleanOpenHashMap;", "dirtyLock", "", "dirtyStatuses", "Ljava/util/HashSet;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "whetherExactlyParentToChanged", "", "addFileStatusListener", "", "listener", "Lcom/intellij/openapi/vcs/FileStatusListener;", "parentDisposable", "calcDirectoryStatus", "virtualFile", "status", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FileStatus;)Ljava/lang/Boolean;", "calcStatus", "dispose", "fileStatusChanged", "file", "fileStatusesChanged", "getRecursiveStatus", "getStatus", "getVcsFileStatus", "initFileStatusFor", "processModifiedDocument", "isDocumentModified", "processModifiedDocuments", "refreshFileStatusFromDocument", "updateCachedFileStatuses", "updateFileStatusFor", "waitFor", "FileStatusManagerDocumentListener", "MyChangeListListener", "intellij.platform.vcs.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nFileStatusManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStatusManagerImpl.kt\ncom/intellij/openapi/vcs/impl/FileStatusManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n46#2,5:367\n46#2,5:372\n46#2,5:377\n46#2,5:382\n46#2,5:388\n1#3:387\n*S KotlinDebug\n*F\n+ 1 FileStatusManagerImpl.kt\ncom/intellij/openapi/vcs/impl/FileStatusManagerImpl\n*L\n121#1:367,5\n129#1:372,5\n135#1:377,5\n138#1:382,5\n269#1:388,5\n*E\n"})
public final class FileStatusManagerImpl
extends FileStatusManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final Object dirtyLock;
    @NotNull
    private final HashSet<VirtualFile> dirtyStatuses;
    @NotNull
    private final Object2BooleanOpenHashMap<VirtualFile> dirtyDocuments;
    private final Map<VirtualFile, FileStatus> cachedStatuses;
    private final Map<VirtualFile, Boolean> whetherExactlyParentToChanged;

    public FileStatusManagerImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.queue = new MergingUpdateQueue("FileStatusManagerImpl", 100, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.dirtyLock = new Object();
        this.dirtyStatuses = new HashSet();
        this.dirtyDocuments = new Object2BooleanOpenHashMap();
        this.cachedStatuses = Collections.synchronizedMap(new HashMap());
        this.whetherExactlyParentToChanged = Collections.synchronizedMap(new HashMap());
        MessageBusConnection connection = this.project.getMessageBus().connect();
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> FileStatusManagerImpl._init_$lambda$0(this, arg_0));
        Topic<VcsMappingListener> topic2 = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"VCS_CONFIGURATION_CHANGED");
        connection.subscribe(topic2, this::fileStatusesChanged);
        Topic<ChangeListListener> topic3 = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        connection.subscribe(topic3, (Object)new MyChangeListListener());
        FileStatusProvider.EP_NAME.addChangeListener((AreaInstance)this.project, this::fileStatusesChanged, (Disposable)this.project);
        StartupManager.getInstance((Project)this.project).runAfterOpened(this::fileStatusesChanged);
    }

    private final FileStatus calcStatus(VirtualFile virtualFile) {
        Throwable e$iv;
        Logger $this$debug_u24default$iv;
        FileStatus status;
        for (FileStatusProvider extension : FileStatusProvider.EP_NAME.getExtensions((AreaInstance)this.project)) {
            FileStatus status2 = extension.getFileStatus(virtualFile);
            if (status2 == null) continue;
            Logger logger = FileStatusManager.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger $this$debug_u24default$iv2 = logger;
            Throwable e$iv2 = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv2;
                boolean bl = false;
                logger2.debug("File status for file [" + virtualFile + "] from provider " + extension.getClass().getName() + ": " + status2, e$iv2);
            }
            return status2;
        }
        if (virtualFile.isInLocalFileSystem() && (status = this.getVcsFileStatus(virtualFile)) != null) {
            Logger logger = FileStatusManager.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger $this$debug_u24default$iv3 = logger;
            Throwable e$iv3 = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                Logger logger3 = $this$debug_u24default$iv3;
                boolean bl = false;
                logger3.debug("File status for file [" + virtualFile + "] from vcs provider: " + status, e$iv3);
            }
            return status;
        }
        if (virtualFile.isValid() && virtualFile.is(VFileProperty.SPECIAL)) {
            Logger logger = FileStatusManager.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            $this$debug_u24default$iv = logger;
            e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger4 = $this$debug_u24default$iv;
                boolean bl = false;
                logger4.debug("Default ignored status for special file [" + virtualFile + "]", e$iv);
            }
            FileStatus fileStatus = FileStatus.IGNORED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"IGNORED");
            return fileStatus;
        }
        Logger logger = FileStatusManager.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        $this$debug_u24default$iv = logger;
        e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger5 = $this$debug_u24default$iv;
            boolean bl = false;
            logger5.debug("Default not_changed status for file [" + virtualFile + "]", e$iv);
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
        return fileStatus;
    }

    private final FileStatus getVcsFileStatus(VirtualFile virtualFile) {
        if (ProjectLevelVcsManager.getInstance(this.project).getVcsFor(virtualFile) == null) {
            if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                return FileStatus.SUPPRESSED;
            }
            return null;
        }
        FileStatus fileStatus = ChangeListManager.getInstance(this.project).getStatus(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus status = fileStatus;
        if (!Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED)) {
            return status;
        }
        return FileStatusManagerImplKt.access$isDocumentModified(virtualFile) ? FileStatus.MODIFIED : null;
    }

    private final Boolean calcDirectoryStatus(VirtualFile virtualFile, FileStatus status) {
        if (!Intrinsics.areEqual((Object)FileStatus.NOT_CHANGED, (Object)status) || !VcsConfiguration.getInstance((Project)this.project).SHOW_DIRTY_RECURSIVELY) {
            return null;
        }
        ThreeState threeState = ChangeListManager.getInstance(this.project).haveChangesUnder(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"haveChangesUnder(...)");
        ThreeState state = threeState;
        return ThreeState.YES == state ? Boolean.valueOf(true) : (ThreeState.UNSURE == state ? Boolean.valueOf(false) : null);
    }

    public void dispose() {
        this.cachedStatuses.clear();
    }

    public void addFileStatusListener(@NotNull FileStatusListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(parentDisposable);
        Topic topic = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileStatusesChanged() {
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            this.cachedStatuses.clear();
            this.whetherExactlyParentToChanged.clear();
            this.dirtyStatuses.clear();
            Unit unit = Unit.INSTANCE;
        }
        ApplicationManager.getApplication().invokeLater(() -> FileStatusManagerImpl.fileStatusesChanged$lambda$6(this), ModalityState.any(), this.project.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileStatusChanged(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        if (!file.isValid()) {
            Object object = this.dirtyLock;
            synchronized (object) {
                boolean $i$a$-synchronized-FileStatusManagerImpl$fileStatusChanged$32 = false;
                this.cachedStatuses.remove(file);
                Boolean $i$a$-synchronized-FileStatusManagerImpl$fileStatusChanged$32 = this.whetherExactlyParentToChanged.remove(file);
            }
            return;
        }
        if (!FileStatusManagerImplKt.access$isSupported(file)) {
            return;
        }
        if (this.cachedStatuses.get(file) == null) {
            return;
        }
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.dirtyStatuses.add(file);
        }
        this.queue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"file status update", this::updateCachedFileStatuses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void updateCachedFileStatuses() {
        List toRefresh = null;
        Iterator iterator = this.dirtyLock;
        synchronized (iterator) {
            boolean $i$a$-synchronized-FileStatusManagerImpl$updateCachedFileStatuses$22 = false;
            toRefresh = CollectionsKt.toList((Iterable)this.dirtyStatuses);
            this.dirtyStatuses.clear();
            Unit $i$a$-synchronized-FileStatusManagerImpl$updateCachedFileStatuses$22 = Unit.INSTANCE;
        }
        ArrayList<VirtualFile> updatedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : toRefresh) {
            boolean wasUpdated = this.updateFileStatusFor(file);
            if (!wasUpdated) continue;
            updatedFiles.add(file);
        }
        ApplicationManager.getApplication().invokeLater(() -> FileStatusManagerImpl.updateCachedFileStatuses$lambda$10(this, updatedFiles), ModalityState.any(), this.project.getDisposed());
    }

    private final boolean updateFileStatusFor(VirtualFile file) {
        FileStatus newStatus = this.calcStatus(file);
        FileStatus oldStatus = this.cachedStatuses.put(file, newStatus);
        if (oldStatus == newStatus) {
            return false;
        }
        this.whetherExactlyParentToChanged.put(file, this.calcDirectoryStatus(file, newStatus));
        return true;
    }

    private final FileStatus initFileStatusFor(VirtualFile file) {
        FileStatus newStatus = this.calcStatus(file);
        this.cachedStatuses.put(file, newStatus);
        this.whetherExactlyParentToChanged.put(file, this.calcDirectoryStatus(file, newStatus));
        return newStatus;
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file) {
        FileStatus fileStatus;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileStatusManagerImplKt.access$isSupported(file)) {
            FileStatus fileStatus2 = FileStatus.SUPPRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"SUPPRESSED");
            return fileStatus2;
        }
        FileStatus status = this.cachedStatuses.get(file);
        Logger logger = FileStatusManager.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("Cached status for file [" + file + "] is " + status, e$iv);
        }
        if ((fileStatus = status) == null) {
            fileStatus = this.initFileStatusFor(file);
        }
        return fileStatus;
    }

    @NotNull
    public FileStatus getRecursiveStatus(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileStatus status = this.getStatus(file);
        if (status != FileStatus.NOT_CHANGED) {
            return status;
        }
        if (file.isValid() && file.isDirectory()) {
            FileStatus fileStatus;
            Boolean bl = this.whetherExactlyParentToChanged.get(file);
            if (bl == null) {
                FileStatus fileStatus2 = FileStatus.NOT_CHANGED;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"NOT_CHANGED");
                return fileStatus2;
            }
            boolean immediate = bl;
            if (immediate) {
                FileStatus fileStatus3 = FileStatus.NOT_CHANGED_IMMEDIATE;
                fileStatus = fileStatus3;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus3, (String)"NOT_CHANGED_IMMEDIATE");
            } else {
                FileStatus fileStatus4 = FileStatus.NOT_CHANGED_RECURSIVE;
                fileStatus = fileStatus4;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus4, (String)"NOT_CHANGED_RECURSIVE");
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
        return fileStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void refreshFileStatusFromDocument(VirtualFile file) {
        if (FileStatusManager.LOG.isDebugEnabled()) {
            Document document2 = FileDocumentManager.getInstance().getDocument(file);
            Document document3 = document2;
            FileStatusManager.LOG.debug("[refreshFileStatusFromDocument] file modificationStamp: " + file.getModificationStamp() + ", document modificationStamp: " + (document3 != null ? Long.valueOf(document3.getModificationStamp()) : null));
        }
        boolean isDocumentModified = FileStatusManagerImplKt.access$isDocumentModified(file);
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.dirtyDocuments.put((Object)file, isDocumentModified);
        }
        this.queue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"refresh from document", this::processModifiedDocuments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void processModifiedDocuments() {
        Object2BooleanOpenHashMap toRefresh = null;
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            toRefresh = new Object2BooleanOpenHashMap((Object2BooleanMap)this.dirtyDocuments);
            this.dirtyDocuments.clear();
            Unit unit = Unit.INSTANCE;
        }
        ((Object2BooleanMap)toRefresh).forEach((arg_0, arg_1) -> FileStatusManagerImpl.processModifiedDocuments$lambda$14((Function2)new Function2<VirtualFile, Boolean, Unit>((Object)this){

            public final void invoke(@NotNull VirtualFile p0, boolean p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                FileStatusManagerImpl.access$processModifiedDocument((FileStatusManagerImpl)((Object)this.receiver), p0, p1);
            }
        }, arg_0, arg_1));
    }

    @RequiresBackgroundThread
    private final void processModifiedDocument(VirtualFile file, boolean isDocumentModified) {
        ChangeProvider cp;
        if (FileStatusManager.LOG.isDebugEnabled()) {
            Document document2 = (Document)ApplicationManager.getApplication().runReadAction(() -> FileStatusManagerImpl.processModifiedDocument$lambda$15(file));
            Document document3 = document2;
            FileStatusManager.LOG.debug("[processModifiedDocument] isModified: " + isDocumentModified + ", file modificationStamp: " + file.getModificationStamp() + ", document modificationStamp: " + (document3 != null ? Long.valueOf(document3.getModificationStamp()) : null));
        }
        VirtualFile virtualFile = VcsUtil.resolveSymlinkIfNeeded(this.project, file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"resolveSymlinkIfNeeded(...)");
        VirtualFile vcsFile = virtualFile;
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance(this.project).getVcsFor(vcsFile);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        FileStatus cachedStatus = this.cachedStatuses.get(vcsFile);
        if (cachedStatus == FileStatus.MODIFIED && !isDocumentModified) {
            ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)readonlyStatusHandler, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl");
            boolean unlockWithPrompt = ((ReadonlyStatusHandlerImpl)readonlyStatusHandler).getState().SHOW_DIALOG;
            if (!unlockWithPrompt) {
                RollbackEnvironment rollbackEnvironment;
                RollbackEnvironment rollbackEnvironment2 = rollbackEnvironment = vcs.getRollbackEnvironment();
                if (rollbackEnvironment2 != null) {
                    rollbackEnvironment2.rollbackIfUnchanged(vcsFile);
                }
            }
        }
        if (cachedStatus != null) {
            boolean isStatusChanged;
            boolean bl = isStatusChanged = cachedStatus != FileStatus.NOT_CHANGED;
            if (isStatusChanged != isDocumentModified) {
                this.fileStatusChanged(vcsFile);
            }
        }
        if ((cp = vcs.getChangeProvider()) != null && cp.isModifiedDocumentTrackingRequired()) {
            boolean isClmStatusChanged;
            FileStatus fileStatus = ChangeListManager.getInstance(this.project).getStatus(vcsFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            boolean bl = isClmStatusChanged = status != FileStatus.NOT_CHANGED;
            if (isClmStatusChanged != isDocumentModified) {
                VcsDirtyScopeManager.getInstance(this.project).fileDirty(vcsFile);
            }
        }
    }

    @TestOnly
    public final void waitFor() {
        this.queue.waitForAllExecuted(10L, TimeUnit.SECONDS);
        if (this.queue.isFlushing()) {
            this.queue.waitForAllExecuted(10L, TimeUnit.SECONDS);
        }
    }

    private static final void _init_$lambda$0(FileStatusManagerImpl this$0, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.fileStatusesChanged();
    }

    private static final void fileStatusesChanged$lambda$6(FileStatusManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic topic = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((FileStatusListener)messageBus.syncPublisher(topic)).fileStatusesChanged();
    }

    private static final void updateCachedFileStatuses$lambda$10(FileStatusManagerImpl this$0, ArrayList $updatedFiles) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$updatedFiles, (String)"$updatedFiles");
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic topic = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        FileStatusListener publisher2 = (FileStatusListener)messageBus.syncPublisher(topic);
        for (VirtualFile file : $updatedFiles) {
            publisher2.fileStatusChanged(file);
        }
    }

    private static final void processModifiedDocuments$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Document processModifiedDocument$lambda$15(VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return FileDocumentManager.getInstance().getDocument($file);
    }

    public static final /* synthetic */ void access$processModifiedDocument(FileStatusManagerImpl $this, VirtualFile file, boolean isDocumentModified) {
        $this.processModifiedDocument(file, isDocumentModified);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl$FileStatusManagerDocumentListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "()V", "CHANGED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "bulkUpdateFinished", "", "document", "Lcom/intellij/openapi/editor/Document;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "refreshFileStatus", "unsavedDocumentDropped", "intellij.platform.vcs.impl"})
    public static final class FileStatusManagerDocumentListener
    implements FileDocumentManagerListener,
    DocumentListener {
        @NotNull
        private final Key<Boolean> CHANGED;

        public FileStatusManagerDocumentListener() {
            Key key2 = Key.create((String)"FileStatusManagerDocumentListener.document.changed");
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
            this.CHANGED = key2;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Document document2 = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            Document document3 = document2;
            if (document3.isInBulkUpdate()) {
                document3.putUserData(this.CHANGED, (Object)true);
            } else {
                this.refreshFileStatus(document3);
            }
        }

        public void bulkUpdateFinished(@NotNull Document document2) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            if (document2.getUserData(this.CHANGED) != null) {
                document2.putUserData(this.CHANGED, null);
                this.refreshFileStatus(document2);
            }
        }

        public void unsavedDocumentDropped(@NotNull Document document2) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            this.refreshFileStatus(document2);
        }

        private final void refreshFileStatus(Document document2) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            if (!file.isInLocalFileSystem()) {
                return;
            }
            if (!FileStatusManagerImplKt.access$isSupported(file)) {
                return;
            }
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager == null) {
                return;
            }
            ProjectManager projectManager2 = projectManager;
            Project[] projectArray = projectManager2.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project2 : projectArray) {
                FileStatusManagerImpl manager;
                FileStatusManagerImpl fileStatusManagerImpl = manager = (FileStatusManagerImpl)((Object)project2.getServiceIfCreated(FileStatusManager.class));
                if (fileStatusManagerImpl == null) continue;
                fileStatusManagerImpl.refreshFileStatusFromDocument(file);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "(Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl;)V", "changeListAdded", "", "list", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "changeListRemoved", "changeListUpdateDone", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    implements ChangeListListener {
        @Override
        public void changeListAdded(@NotNull ChangeList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            FileStatusManagerImpl.this.fileStatusesChanged();
        }

        @Override
        public void changeListRemoved(@NotNull ChangeList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            FileStatusManagerImpl.this.fileStatusesChanged();
        }

        @Override
        public void changeListUpdateDone() {
            FileStatusManagerImpl.this.fileStatusesChanged();
        }
    }
}

