/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.RevisionIdKt;
import com.intellij.platform.lvcs.impl.diff.EntryDiffContentKt;
import com.intellij.util.text.DateFormatUtil;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\rH\u0002J\u0013\u0010\"\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0017\u0010'\u001a\u00070&\u00a2\u0006\u0002\b(2\b\u0010)\u001a\u0004\u0018\u00010\u0014H\u0004J\b\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "difference", "Lcom/intellij/history/core/revisions/Difference;", "isOldContentUsed", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lcom/intellij/history/core/revisions/Difference;Z)V", "getDifference", "()Lcom/intellij/history/core/revisions/Difference;", "getGateway", "()Lcom/intellij/history/integration/IdeaGateway;", "leftItem", "Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "getLeftItem", "()Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rightItem", "getRightItem", "getScope", "()Lcom/intellij/platform/lvcs/impl/ActivityScope;", "createContent", "Lcom/intellij/diff/contents/DiffContent;", "entry", "Lcom/intellij/history/core/tree/Entry;", "isCurrent", "equals", "other", "", "getName", "", "getTitle", "Lorg/jetbrains/annotations/Nls;", "item", "hashCode", "", "process", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lvcs.impl"})
public class DifferenceDiffRequestProducer
implements DiffRequestProducer {
    @Nullable
    private final Project project;
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final ActivityScope scope;
    @NotNull
    private final Difference difference;
    private final boolean isOldContentUsed;
    @Nullable
    private final ChangeSetActivityItem leftItem;
    @Nullable
    private final ChangeSetActivityItem rightItem;

    public DifferenceDiffRequestProducer(@Nullable Project project2, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope2, @NotNull ChangeSetSelection selection, @NotNull Difference difference, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)difference, (String)"difference");
        this.project = project2;
        this.gateway = gateway;
        this.scope = scope2;
        this.difference = difference;
        this.isOldContentUsed = isOldContentUsed;
        this.leftItem = selection.getLeftItem();
        this.rightItem = selection.getRightItem();
    }

    @Nullable
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final IdeaGateway getGateway() {
        return this.gateway;
    }

    @NotNull
    protected ActivityScope getScope() {
        return this.scope;
    }

    @NotNull
    protected final Difference getDifference() {
        return this.difference;
    }

    @Nullable
    protected final ChangeSetActivityItem getLeftItem() {
        return this.leftItem;
    }

    @Nullable
    protected final ChangeSetActivityItem getRightItem() {
        return this.rightItem;
    }

    @NotNull
    public String getName() {
        Entry entry2;
        Entry entry3 = this.difference.getLeft();
        if (entry3 == null) {
            entry3 = this.difference.getRight();
        }
        if ((entry2 = entry3) == null) {
            return ActivityScopeKt.getPresentableName(this.getScope());
        }
        String string2 = FileUtil.toSystemDependentName((String)entry2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        return string2;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        DiffContent leftContent = this.createContent(this.difference.getLeft(), RevisionIdKt.getRevisionId(this.leftItem) instanceof RevisionId.Current);
        DiffContent rightContent = this.createContent(this.difference.getRight(), RevisionIdKt.getRevisionId(this.rightItem) instanceof RevisionId.Current);
        String leftContentTitle = this.getTitle(this.leftItem);
        String rightContentTitle = this.getTitle(this.rightItem);
        return (DiffRequest)new SimpleDiffRequest(this.getName(), leftContent, rightContent, leftContentTitle, rightContentTitle);
    }

    private final DiffContent createContent(Entry entry2, boolean isCurrent) {
        if (entry2 == null) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
            return (DiffContent)emptyContent;
        }
        if (isCurrent) {
            return (DiffContent)ActionsKt.runReadAction((Function0)((Function0)new Function0<DiffContent>(this, entry2){
                final /* synthetic */ DifferenceDiffRequestProducer this$0;
                final /* synthetic */ Entry $entry;
                {
                    this.this$0 = $receiver;
                    this.$entry = $entry;
                    super(0);
                }

                @NotNull
                public final DiffContent invoke() {
                    Project project2 = this.this$0.getProject();
                    IdeaGateway ideaGateway = this.this$0.getGateway();
                    String string2 = this.$entry.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    return EntryDiffContentKt.createCurrentDiffContent(project2, ideaGateway, string2);
                }
            }));
        }
        return EntryDiffContentKt.createDiffContent(this.project, this.gateway, entry2);
    }

    @NotNull
    protected final String getTitle(@Nullable ChangeSetActivityItem item2) {
        if (item2 == null) {
            String string2 = LocalHistoryBundle.message("current.revision", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        String string3 = DateFormatUtil.formatDateTime((long)item2.getTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"formatDateTime(...)");
        String formattedTimestamp = string3;
        if (this.isOldContentUsed) {
            Object[] objectArray = new Object[]{formattedTimestamp};
            String string4 = LocalHistoryBundle.message("activity.diff.content.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            return string4;
        }
        return formattedTimestamp;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DifferenceDiffRequestProducer)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getScope(), (Object)((DifferenceDiffRequestProducer)other).getScope())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.leftItem, (Object)((DifferenceDiffRequestProducer)other).leftItem)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rightItem, (Object)((DifferenceDiffRequestProducer)other).rightItem)) {
            return false;
        }
        return this.isOldContentUsed == ((DifferenceDiffRequestProducer)other).isOldContentUsed;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getScope(), this.leftItem, this.rightItem, this.isOldContentUsed};
        return Objects.hash(objectArray);
    }
}

