/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ReportFeedbackService;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.VcsEditorTabFilesManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.lvcs.impl.ActivityData;
import com.intellij.platform.lvcs.impl.ActivityDiffData;
import com.intellij.platform.lvcs.impl.ActivityItem;
import com.intellij.platform.lvcs.impl.ActivityPresentation;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ActivitySelection;
import com.intellij.platform.lvcs.impl.settings.ActivityViewApplicationSettings;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.platform.lvcs.impl.ui.ActivityList;
import com.intellij.platform.lvcs.impl.ui.ActivityModelListener;
import com.intellij.platform.lvcs.impl.ui.ActivityService;
import com.intellij.platform.lvcs.impl.ui.ActivityToolWindow;
import com.intellij.platform.lvcs.impl.ui.ActivityView;
import com.intellij.platform.lvcs.impl.ui.ActivityViewDataKeys;
import com.intellij.platform.lvcs.impl.ui.ActivityViewModel;
import com.intellij.platform.lvcs.impl.ui.CombinedActivityDiffPreview;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.ui.ProgressStripe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005*\u0001\u0012\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u0001+B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0015\u0010$\u001a\u00070#\u00a2\u0006\u0002\b%2\u0006\u0010&\u001a\u00020'H\u0002J\r\u0010(\u001a\u00020'H\u0000\u00a2\u0006\u0002\b)J\u0014\u0010*\u001a\u00020\u001f*\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/ActivityView;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "activityScope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope;)V", "activityList", "Lcom/intellij/platform/lvcs/impl/ui/ActivityList;", "getActivityScope", "()Lcom/intellij/platform/lvcs/impl/ActivityScope;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "editorDiffPreview", "com/intellij/platform/lvcs/impl/ui/ActivityView$editorDiffPreview$1", "Lcom/intellij/platform/lvcs/impl/ui/ActivityView$editorDiffPreview$1;", "model", "Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "()Ljavax/swing/JComponent;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "createSearchField", "Lcom/intellij/find/SearchTextArea;", "dispose", "", "getData", "", "dataId", "", "getEmptyText", "Lcom/intellij/openapi/util/NlsContexts$StatusText;", "isLoading", "", "showDiff", "showDiff$intellij_platform_lvcs_impl", "updateEmptyText", "Companion", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nActivityView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityView.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityView\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,296:1\n31#2,2:297\n42#3,3:299\n*S KotlinDebug\n*F\n+ 1 ActivityView.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityView\n*L\n59#1:297,2\n191#1:299,3\n*E\n"})
public final class ActivityView
extends JBPanel<ActivityView>
implements DataProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ActivityScope activityScope;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ActivityViewModel model;
    @NotNull
    private final ActivityList activityList;
    @NotNull
    private final editorDiffPreview.1 editorDiffPreview;
    @NotNull
    private static final String NOTIFICATION_DISMISSED_KEY = "lvcs.experimental.ui.notification.dismissed";
    @NotNull
    private static final String URL_PREFIX = "https://youtrack.jetbrains.com/newIssue?project=IDEA&c=Subsystem+Version+Control.+Local+History&c=Type+Support+Request&description=";

    public ActivityView(@NotNull Project project2, @NotNull IdeaGateway gateway, @NotNull ActivityScope activityScope) {
        ProgressBarLoadingDecorator progressBarLoadingDecorator;
        ActivityList $this$activityList_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)activityScope, (String)"activityScope");
        super((LayoutManager)new BorderLayout());
        this.project = project2;
        this.activityScope = activityScope;
        Object $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service22 = false;
        Class<ActivityService> serviceClass$iv = ActivityService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((ActivityService)object).getCoroutineScope(), null, (boolean)false, (int)3, null);
        this.model = new ActivityViewModel(this.project, gateway, this.activityScope, this.coroutineScope);
        Object $i$f$service22 = $this$service$iv = new ActivityList((Function1<? super ActivityItem, ActivityPresentation>)((Function1)new Function1<ActivityItem, ActivityPresentation>(this){
            final /* synthetic */ ActivityView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ActivityPresentation invoke(@NotNull ActivityItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ActivityView.access$getModel$p(this.this$0).getActivityProvider$intellij_platform_lvcs_impl().getPresentation(it);
            }
        }));
        ActivityView activityView = this;
        boolean $i$a$-apply-ActivityView$activityList$32 = false;
        this.updateEmptyText($this$activityList_u24lambda_u240, true);
        activityView.activityList = $this$service$iv;
        $this$service$iv = this.project;
        $this$activityList_u24lambda_u240 = this.activityList;
        Object $i$a$-apply-ActivityView$activityList$32 = this.activityScope;
        this.editorDiffPreview = new CombinedActivityDiffPreview(this, (Project)$this$service$iv, $this$activityList_u24lambda_u240, (ActivityScope)$i$a$-apply-ActivityView$activityList$32){
            final /* synthetic */ ActivityView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (JComponent)((Object)$super_call_param$2), $super_call_param$3, (Disposable)$receiver);
            }

            @Nullable
            public ActivityDiffData loadDiffDataSynchronously() {
                return ActivityView.access$getModel$p(this.this$0).loadDiffDataSynchronously$intellij_platform_lvcs_impl();
            }

            public void returnFocusToSourceComponent() {
                IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)((Object)ActivityView.access$getActivityList$p(this.this$0)), true);
            }
        };
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.activityList)), (String)"ActivityView.Popup", (String)"ActivityView.Popup");
        Object $this$_init__u24lambda_u241 = $i$a$-apply-ActivityView$activityList$32 = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.activityList)), (int)20, (int)31);
        boolean bl = false;
        ((JComponent)$this$_init__u24lambda_u241).setBorder(IdeBorderFactory.createBorder((int)2));
        Object object2 = $i$a$-apply-ActivityView$activityList$32;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apply(...)");
        Object scrollPane = object2;
        final ProgressStripe progressStripe = new ProgressStripe((JComponent)scrollPane, this);
        this.add((Component)((Object)progressStripe), "Center");
        BorderLayoutPanel toolbarComponent = new BorderLayoutPanel();
        if (this.model.isScopeFilterSupported$intellij_platform_lvcs_impl() || this.model.isActivityFilterSupported$intellij_platform_lvcs_impl()) {
            ProgressBarLoadingDecorator progressBarLoadingDecorator2;
            SearchTextArea searchField2 = this.createSearchField();
            ProgressBarLoadingDecorator it = progressBarLoadingDecorator2 = new ProgressBarLoadingDecorator(searchField2, this){

                protected boolean isOnTop() {
                    return false;
                }
            };
            boolean bl2 = false;
            toolbarComponent.add((Component)it.getComponent(), (Object)"Center");
            progressBarLoadingDecorator = progressBarLoadingDecorator2;
        } else {
            progressBarLoadingDecorator = null;
        }
        ProgressBarLoadingDecorator filterProgress2 = progressBarLoadingDecorator;
        AnAction anAction = ActionManager.getInstance().getAction("ActivityView.Toolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup toolbarGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ActivityView.Toolbar", toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setTargetComponent((JComponent)((Object)this));
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbarComponent.add((Component)toolbar2.getComponent(), (Object)"East");
        EditorNotificationPanel notificationPanel = this.createNotificationPanel();
        if (notificationPanel != null) {
            toolbarComponent.add((Component)notificationPanel, (Object)"North");
        }
        this.add((Component)toolbarComponent, "North");
        this.activityList.addListener(new ActivityList.Listener(){

            @Override
            public void onSelectionChanged(@NotNull ActivitySelection selection) {
                Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                model.setSelection(selection);
            }

            @Override
            public boolean onEnter() {
                this.showDiff$intellij_platform_lvcs_impl();
                return true;
            }

            @Override
            public boolean onDoubleClick() {
                this.showDiff$intellij_platform_lvcs_impl();
                return true;
            }
        }, this);
        this.model.addListener(new ActivityModelListener(filterProgress2){
            final /* synthetic */ filterProgress.1 $filterProgress;
            {
                this.$filterProgress = $filterProgress;
            }

            @Override
            public void onItemsLoadingStarted() {
                this.updateEmptyText(activityList, true);
                progressStripe.startLoading();
            }

            @Override
            public void onItemsLoadingStopped(@NotNull ActivityData data2) {
                Intrinsics.checkNotNullParameter((Object)((Object)data2), (String)"data");
                activityList.setData(data2);
                this.updateEmptyText(activityList, false);
                progressStripe.stopLoading();
            }

            @Override
            public void onDiffDataLoaded(@Nullable ActivityDiffData diffData2) {
                CombinedActivityDiffPreview.setDiffData$default(editorDiffPreview, diffData2, false, 2, null);
            }

            @Override
            public void onFilteringStarted() {
                filterProgress.1 v0 = this.$filterProgress;
                if (v0 != null) {
                    v0.startLoading(false);
                }
                this.updateEmptyText(activityList, true);
            }

            @Override
            public void onFilteringStopped(@Nullable Set<? extends ActivityItem> result2) {
                filterProgress.1 v0 = this.$filterProgress;
                if (v0 != null) {
                    v0.stopLoading();
                }
                activityList.setVisibleItems(result2);
                this.updateEmptyText(activityList, false);
            }
        }, this);
    }

    @NotNull
    public final ActivityScope getActivityScope() {
        return this.activityScope;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (ActivityViewDataKeys.INSTANCE.getSELECTION().is(dataId)) {
            return this.activityList.getSelection();
        }
        if (ActivityViewDataKeys.INSTANCE.getSCOPE().is(dataId)) {
            return this.activityScope;
        }
        if (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId)) {
            return this.editorDiffPreview;
        }
        return null;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return (JComponent)((Object)this.activityList);
    }

    private final SearchTextArea createSearchField() {
        JBTextArea textArea = new JBTextArea();
        textArea.getEmptyText().setText(this.model.isScopeFilterSupported$intellij_platform_lvcs_impl() ? LocalHistoryBundle.message("activity.filter.empty.text.fileName", new Object[0]) : (this.model.isActivityFilterSupported$intellij_platform_lvcs_impl() ? LocalHistoryBundle.message("activity.filter.empty.text.content", new Object[0]) : ""));
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)((JTextComponent)textArea));
        SearchTextArea searchTextArea = new SearchTextArea((JTextArea)textArea, true);
        searchTextArea.setBorder(JBUI.Borders.compound((Border)IdeBorderFactory.createBorder((int)4), (Border)searchTextArea.getBorder()));
        new DumbAwareAction(this, searchTextArea){
            final /* synthetic */ ActivityView this$0;
            final /* synthetic */ SearchTextArea $searchTextArea;
            {
                this.this$0 = $receiver;
                this.$searchTextArea = $searchTextArea;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IdeFocusManager.getInstance((Project)ActivityView.access$getProject$p(this.this$0)).requestFocus((Component)this.$searchTextArea.getTextArea(), true);
            }
        }.registerCustomShortcutSet((ShortcutSet)Utils.shortcutSetOf((List)Utils.shortcutsOf((String)"Find")), (JComponent)((Object)this.activityList));
        Integer[] integerArray = new Integer[]{27};
        new DumbAwareAction(searchTextArea, this){
            final /* synthetic */ SearchTextArea $searchTextArea;
            final /* synthetic */ ActivityView this$0;
            {
                this.$searchTextArea = $searchTextArea;
                this.this$0 = $receiver;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$searchTextArea.getTextArea().setText("");
                IdeFocusManager.getInstance((Project)ActivityView.access$getProject$p(this.this$0)).requestFocus((Component)((Object)ActivityView.access$getActivityList$p(this.this$0)), true);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(integerArray), (JComponent)searchTextArea.getTextArea());
        searchTextArea.getTextArea().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this, searchTextArea){
            final /* synthetic */ ActivityView this$0;
            final /* synthetic */ SearchTextArea $searchTextArea;
            {
                this.this$0 = $receiver;
                this.$searchTextArea = $searchTextArea;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!ActivityView.access$getModel$p(this.this$0).isFilterSet()) {
                    LocalHistoryCounter.INSTANCE.logFilterUsed(this.this$0.getActivityScope());
                }
                ActivityView.access$getModel$p(this.this$0).setFilter(this.$searchTextArea.getTextArea().getText());
            }
        });
        return searchTextArea;
    }

    private final EditorNotificationPanel createNotificationPanel() {
        if (PropertiesComponent.getInstance().getBoolean(NOTIFICATION_DISMISSED_KEY)) {
            return null;
        }
        EditorNotificationPanel notificationPanel = new EditorNotificationPanel(JBUI.CurrentTheme.Banner.INFO_BACKGROUND);
        notificationPanel.setText(LocalHistoryBundle.message("activity.notification.text", new Object[0]));
        notificationPanel.setBorder(JBUI.Borders.compound((Border)IdeBorderFactory.createBorder((int)8), (Border)notificationPanel.getBorder()));
        notificationPanel.createActionLabel(LocalHistoryBundle.message("activity.notification.feedback.link", new Object[0]), () -> ActivityView.createNotificationPanel$lambda$3(this));
        notificationPanel.add((Component)new InplaceButton(new IconButton(LocalHistoryBundle.message("activity.notification.dismiss.tooltip", new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered), arg_0 -> ActivityView.createNotificationPanel$lambda$4(notificationPanel, arg_0)), (Object)"East");
        Object[] objectArray = new Object[]{ShowSettingsUtil.getSettingsMenuName(), LocalHistoryBundle.message("activity.configurable.title", new Object[0])};
        JLabel disableLabel = new JLabel(LocalHistoryBundle.message("activity.notification.disable.text", objectArray));
        disableLabel.setForeground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground());
        disableLabel.setBorder((Border)JBUI.Borders.emptyTop((int)2));
        notificationPanel.add((Component)disableLabel, (Object)"South");
        return notificationPanel;
    }

    private final void updateEmptyText(ActivityList $this$updateEmptyText, boolean isLoading) {
        $this$updateEmptyText.setEmptyText(this.getEmptyText(isLoading));
    }

    private final String getEmptyText(boolean isLoading) {
        if (isLoading) {
            String string2 = LocalHistoryBundle.message("activity.list.empty.text.loading", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        if (this.model.isFilterSet()) {
            if (this.activityScope instanceof ActivityScope.Recent) {
                String string3 = LocalHistoryBundle.message("activity.list.empty.text.recent.matching", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                return string3;
            }
            Object[] objectArray = new Object[]{ActivityScopeKt.getPresentableName(this.activityScope)};
            String string4 = LocalHistoryBundle.message("activity.list.empty.text.in.scope.matching", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            return string4;
        }
        if (this.activityScope instanceof ActivityScope.Recent) {
            String string5 = LocalHistoryBundle.message("activity.list.empty.text.recent", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            return string5;
        }
        Object[] objectArray = new Object[]{ActivityScopeKt.getPresentableName(this.activityScope)};
        String string6 = LocalHistoryBundle.message("activity.list.empty.text.in.scope", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        return string6;
    }

    public final boolean showDiff$intellij_platform_lvcs_impl() {
        return this.editorDiffPreview.performDiffAction();
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    private static final void createNotificationPanel$lambda$3(ActivityView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        boolean $i$f$service = false;
        Class<ReportFeedbackService> serviceClass$iv = ReportFeedbackService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        BuildersKt.launch$default((CoroutineScope)((ReportFeedbackService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ ActivityView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Project project2 = ActivityView.access$getProject$p(this.this$0);
                        String string2 = IdeBundle.message((String)"reportProblemAction.progress.title.submitting", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        this.label = 1;
                        Object object3 = TasksKt.withBackgroundProgress((Project)project2, (String)string2, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ ActivityView this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = SendFeedbackAction.Companion.getDescription(ActivityView.access$getProject$p(this.this$0), (Continuation)this);
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        description = (String)v0;
                                        BrowserUtil.browse((String)("https://youtrack.jetbrains.com/newIssue?project=IDEA&c=Subsystem+Version+Control.+Local+History&c=Type+Support+Request&description=" + URLEncoder.encode(description, StandardCharsets.UTF_8)), (Project)ActivityView.access$getProject$p(this.this$0));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void createNotificationPanel$lambda$4(EditorNotificationPanel $notificationPanel, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$notificationPanel, (String)"$notificationPanel");
            PropertiesComponent.getInstance().setValue(NOTIFICATION_DISMISSED_KEY, true);
            Container container = $notificationPanel.getParent();
            if (container == null) break block0;
            container.remove((Component)$notificationPanel);
        }
    }

    @JvmStatic
    public static final void show(@NotNull Project project2, @NotNull IdeaGateway gateway, @NotNull ActivityScope activityScope) {
        Companion.show(project2, gateway, activityScope);
    }

    @JvmStatic
    public static final boolean isViewEnabled() {
        return Companion.isViewEnabled();
    }

    @JvmStatic
    public static final boolean isViewAvailable() {
        return Companion.isViewAvailable();
    }

    public static final /* synthetic */ Project access$getProject$p(ActivityView $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/ActivityView$Companion;", "", "()V", "NOTIFICATION_DISMISSED_KEY", "", "URL_PREFIX", "isViewAvailable", "", "isViewEnabled", "show", "", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "activityScope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "openDiffWhenLoaded", "Lcom/intellij/platform/lvcs/impl/ui/ActivityView;", "intellij.platform.lvcs.impl"})
    @SourceDebugExtension(value={"SMAP\nActivityView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityView.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityView$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,296:1\n42#2,3:297\n*S KotlinDebug\n*F\n+ 1 ActivityView.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityView$Companion\n*L\n283#1:297,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void show(@NotNull Project project2, @NotNull IdeaGateway gateway, @NotNull ActivityScope activityScope) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
            Intrinsics.checkNotNullParameter((Object)activityScope, (String)"activityScope");
            LocalHistoryCounter.INSTANCE.logLocalHistoryOpened(activityScope);
            if (ActivityToolWindow.INSTANCE.showTab(project2, (Function1<? super Content, Boolean>)((Function1)new Function1<Content, Boolean>(activityScope){
                final /* synthetic */ ActivityScope $activityScope;
                {
                    this.$activityScope = $activityScope;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Content content) {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    JComponent jComponent = content.getComponent();
                    ActivityView activityView = jComponent instanceof ActivityView ? (ActivityView)((Object)jComponent) : null;
                    return Intrinsics.areEqual((Object)(activityView != null ? activityView.getActivityScope() : null), (Object)this.$activityScope);
                }
            }))) {
                return;
            }
            ActivityView activityView = new ActivityView(project2, gateway, activityScope);
            if (Registry.is((String)"lvcs.open.diff.automatically") && !VcsEditorTabFilesManager.Companion.getInstance().getShouldOpenInNewWindow()) {
                this.openDiffWhenLoaded(activityView);
            }
            Content content = ContentFactory.getInstance().createContent((JComponent)((Object)activityView), ActivityScopeKt.getPresentableName(activityScope), false);
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
            Content content2 = content;
            content2.setPreferredFocusableComponent(activityView.getPreferredFocusedComponent());
            content2.setDisposer((Disposable)activityView);
            ActivityToolWindow.showTab(project2, content2);
            ActivityToolWindow.INSTANCE.onContentVisibilityChanged$intellij_platform_lvcs_impl(project2, content2, activityView, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(activityView){
                final /* synthetic */ ActivityView $activityView;
                {
                    this.$activityView = $activityView;
                    super(1);
                }

                public final void invoke(boolean isVisible2) {
                    ActivityView.access$getModel$p(this.$activityView).setVisible(isVisible2);
                }
            }));
        }

        private final void openDiffWhenLoaded(ActivityView $this$openDiffWhenLoaded) {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            Disposer.register((Disposable)$this$openDiffWhenLoaded, (Disposable)disposable2);
            $this$openDiffWhenLoaded.model.addListener(new ActivityModelListener(disposable2, $this$openDiffWhenLoaded){
                final /* synthetic */ Disposable $disposable;
                final /* synthetic */ ActivityView $this_openDiffWhenLoaded;
                {
                    this.$disposable = $disposable;
                    this.$this_openDiffWhenLoaded = $receiver;
                }

                public void onItemsLoadingStopped(@NotNull ActivityData data2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)data2), (String)"data");
                    if (data2.getItems().isEmpty()) {
                        Disposer.dispose((Disposable)this.$disposable);
                    }
                }

                public void onDiffDataLoaded(@Nullable ActivityDiffData diffData2) {
                    if (diffData2 != null) {
                        this.$this_openDiffWhenLoaded.showDiff$intellij_platform_lvcs_impl();
                        Disposer.dispose((Disposable)this.$disposable);
                    }
                }
            }, disposable2);
        }

        @JvmStatic
        public final boolean isViewEnabled() {
            if (!this.isViewAvailable()) {
                return false;
            }
            boolean $i$f$service = false;
            Class<ActivityViewApplicationSettings> serviceClass$iv = ActivityViewApplicationSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return ((ActivityViewApplicationSettings)((Object)object)).isActivityToolWindowEnabled();
        }

        @JvmStatic
        public final boolean isViewAvailable() {
            if (AppMode.isRemoteDevHost()) {
                return false;
            }
            return Registry.is((String)"lvcs.show.activity.view");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

