/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.logger;

import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.platform.ml.Environment;
import com.intellij.platform.ml.Feature;
import com.intellij.platform.ml.Session;
import com.intellij.platform.ml.TierInstance;
import com.intellij.platform.ml.impl.MLTaskApproach;
import com.intellij.platform.ml.impl.apiPlatform.MLApiPlatform;
import com.intellij.platform.ml.impl.logger.EventIdRecordingMLEvent;
import com.intellij.platform.ml.impl.logger.FusSessionEventBuilder;
import com.intellij.platform.ml.impl.logger.SessionFields;
import com.intellij.platform.ml.impl.monitoring.MLApproachInitializationListener;
import com.intellij.platform.ml.impl.monitoring.MLApproachListener;
import com.intellij.platform.ml.impl.monitoring.MLSessionListener;
import com.intellij.platform.ml.impl.monitoring.MLTaskGroupListener;
import com.intellij.platform.ml.impl.session.AnalysedTierData;
import com.intellij.platform.ml.impl.session.DescribedTierData;
import com.intellij.platform.ml.impl.session.Level;
import com.intellij.platform.ml.impl.session.SessionTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u00042\u00020\u0005:\u0003 !\"B)\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger;", "R", "P", "", "Lcom/intellij/platform/ml/impl/logger/EventIdRecordingMLEvent;", "Lcom/intellij/platform/ml/impl/monitoring/MLTaskGroupListener;", "approach", "Lcom/intellij/platform/ml/impl/MLTaskApproach;", "configuration", "Lcom/intellij/platform/ml/impl/logger/FusSessionEventBuilder$FusScheme;", "apiPlatform", "Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;", "(Lcom/intellij/platform/ml/impl/MLTaskApproach;Lcom/intellij/platform/ml/impl/logger/FusSessionEventBuilder$FusScheme;Lcom/intellij/platform/ml/impl/apiPlatform/MLApiPlatform;)V", "approachListeners", "", "Lcom/intellij/platform/ml/impl/monitoring/MLTaskGroupListener$ApproachListeners;", "getApproachListeners", "()Ljava/util/Collection;", "declaration", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getDeclaration", "()[Lcom/intellij/internal/statistic/eventLog/events/EventField;", "[Lcom/intellij/internal/statistic/eventLog/events/EventField;", "eventName", "", "getEventName", "()Ljava/lang/String;", "fusDeclaration", "Lcom/intellij/platform/ml/impl/logger/SessionFields;", "loggingScheme", "Lcom/intellij/platform/ml/impl/logger/FusSessionEventBuilder;", "ApproachLogger", "InitializationLogger", "SessionLogger", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class MLSessionFinishedLogger<R, P>
extends EventIdRecordingMLEvent
implements MLTaskGroupListener {
    @NotNull
    private final MLApiPlatform apiPlatform;
    @NotNull
    private final FusSessionEventBuilder<P> loggingScheme;
    @NotNull
    private final SessionFields<P> fusDeclaration;
    @NotNull
    private final EventField<?>[] declaration;
    @NotNull
    private final String eventName;
    @NotNull
    private final Collection<MLTaskGroupListener.ApproachListeners<?, ?>> approachListeners;

    public MLSessionFinishedLogger(@NotNull MLTaskApproach<P> approach, @NotNull FusSessionEventBuilder.FusScheme<P> configuration, @NotNull MLApiPlatform apiPlatform) {
        Intrinsics.checkNotNullParameter(approach, (String)"approach");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
        this.apiPlatform = apiPlatform;
        this.loggingScheme = configuration.createEventBuilder(approach.getApproachDeclaration());
        this.fusDeclaration = this.loggingScheme.buildFusDeclaration();
        this.declaration = this.fusDeclaration.getFields();
        this.eventName = approach.getTask().getName() + ".finished";
        this.approachListeners = CollectionsKt.listOf(MLTaskGroupListener.ApproachListeners.Companion.monitoredBy(approach.getClass(), new InitializationLogger()));
    }

    @Override
    @NotNull
    public EventField<?>[] getDeclaration() {
        return this.declaration;
    }

    @Override
    @NotNull
    public String getEventName() {
        return this.eventName;
    }

    @Override
    @NotNull
    public Collection<MLTaskGroupListener.ApproachListeners<?, ?>> getApproachListeners() {
        return this.approachListeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger$ApproachLogger;", "Lcom/intellij/platform/ml/impl/monitoring/MLApproachListener;", "(Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger;)V", "onFailedToStartSession", "", "failure", "Lcom/intellij/platform/ml/Session$StartOutcome$Failure;", "onFailedToStartSessionWithException", "exception", "", "onStartedSession", "Lcom/intellij/platform/ml/impl/monitoring/MLSessionListener;", "session", "Lcom/intellij/platform/ml/Session;", "intellij.platform.ml.impl"})
    public final class ApproachLogger
    implements MLApproachListener<R, P> {
        @Override
        public void onFailedToStartSessionWithException(@NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        }

        @Override
        public void onFailedToStartSession(@NotNull Session.StartOutcome.Failure<P> failure2) {
            Intrinsics.checkNotNullParameter(failure2, (String)"failure");
        }

        @Override
        @NotNull
        public MLSessionListener<R, P> onStartedSession(@NotNull Session<P> session) {
            Intrinsics.checkNotNullParameter(session, (String)"session");
            return new SessionLogger();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger$InitializationLogger;", "Lcom/intellij/platform/ml/impl/monitoring/MLApproachInitializationListener;", "(Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger;)V", "onAttemptedToStartSession", "Lcom/intellij/platform/ml/impl/monitoring/MLApproachListener;", "permanentSessionEnvironment", "Lcom/intellij/platform/ml/Environment;", "intellij.platform.ml.impl"})
    public final class InitializationLogger
    implements MLApproachInitializationListener<R, P> {
        @Override
        @NotNull
        public MLApproachListener<R, P> onAttemptedToStartSession(@NotNull Environment permanentSessionEnvironment) {
            Intrinsics.checkNotNullParameter((Object)permanentSessionEnvironment, (String)"permanentSessionEnvironment");
            return new ApproachLogger();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0086\u0001\u0010\u0003\u001a\u00020\u00042|\u0010\u0005\u001ax\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007j\u0002`\u000b\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\u0007j\b\u0012\u0004\u0012\u00020\u000e`\u000f\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00100\u0007j\b\u0012\u0004\u0012\u00020\u0010`\u000f0\fj\u0002`\u0011\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0012H\u0016Jv\u0010\u0013\u001a\u00020\u00042l\u0010\u0005\u001ah\u0012\u0004\u0012\u00028\u0000\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00100\u0007j\b\u0012\u0004\u0012\u00020\u0010`\u000f\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00100\u0007j\b\u0012\u0004\u0012\u00020\u0010`\u000f0\fj\u0002`\u0014\u0012\u0004\u0012\u00028\u00010\u0006j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger$SessionLogger;", "Lcom/intellij/platform/ml/impl/monitoring/MLSessionListener;", "(Lcom/intellij/platform/ml/impl/logger/MLSessionFinishedLogger;)V", "onSessionAnalysisFinished", "", "sessionTree", "Lcom/intellij/platform/ml/impl/session/SessionTree$RootContainer;", "", "", "", "Lcom/intellij/platform/ml/Feature;", "Lcom/intellij/platform/ml/impl/session/SessionAnalysis;", "Lcom/intellij/platform/ml/impl/session/Level;", "Lcom/intellij/platform/ml/TierInstance;", "Lcom/intellij/platform/ml/impl/session/AnalysedTierData;", "Lcom/intellij/platform/ml/PerTierInstance;", "Lcom/intellij/platform/ml/impl/session/DescribedTierData;", "Lcom/intellij/platform/ml/impl/session/AnalysedLevel;", "Lcom/intellij/platform/ml/impl/session/AnalysedRootContainer;", "onSessionDescriptionFinished", "Lcom/intellij/platform/ml/impl/session/DescribedLevel;", "Lcom/intellij/platform/ml/impl/session/DescribedRootContainer;", "intellij.platform.ml.impl"})
    public final class SessionLogger
    implements MLSessionListener<R, P> {
        @Override
        public void onSessionDescriptionFinished(@NotNull SessionTree.RootContainer<R, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, P> sessionTree) {
            Intrinsics.checkNotNullParameter(sessionTree, (String)"sessionTree");
        }

        @Override
        public void onSessionAnalysisFinished(@NotNull SessionTree.RootContainer<Map<String, Set<Feature>>, Level<Map<TierInstance<?>, AnalysedTierData>, Map<TierInstance<?>, DescribedTierData>>, P> sessionTree) {
            Intrinsics.checkNotNullParameter(sessionTree, (String)"sessionTree");
            VarargEventId eventId = MLSessionFinishedLogger.this.getEventId(MLSessionFinishedLogger.this.apiPlatform);
            EventPair<?>[] fusEventData = MLSessionFinishedLogger.this.loggingScheme.buildRecord(sessionTree, MLSessionFinishedLogger.this.fusDeclaration);
            eventId.log(Arrays.copyOf(fusEventData, fusEventData.length));
        }
    }
}

