/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.ide.DataManager;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpellcheckerIcons;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SaveTo
implements SpellCheckerQuickFix,
LowPriorityAction {
    @Nullable
    private DictionaryLayer myLayer;
    private String myWord;

    public SaveTo(@NotNull DictionaryLayer layer) {
        if (layer == null) {
            SaveTo.$$$reportNull$$$0(0);
        }
        this.myLayer = null;
        this.myLayer = layer;
    }

    public SaveTo(String word) {
        this.myLayer = null;
        this.myWord = word;
    }

    public SaveTo(String word, @Nullable DictionaryLayer layer) {
        this.myLayer = null;
        this.myWord = word;
        this.myLayer = layer;
    }

    @NotNull
    public String getName() {
        String string2 = SpellCheckerBundle.message("save.0.to.dictionary.fix", this.myWord != null ? SpellCheckerBundle.message("0.in.quotes", this.myWord) : "");
        if (string2 == null) {
            SaveTo.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = SpellCheckerBundle.message("save.0.to.dictionary.fix", "");
        if (string2 == null) {
            SaveTo.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            SaveTo.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            SaveTo.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile psiFile2 = psiElement.getContainingFile();
        TextRange wordRange = descriptor.getTextRangeInElement().shiftRight(psiElement.getTextRange().getStartOffset());
        String wordToSave = this.myWord != null ? this.myWord : ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement());
        SaveTo.applyFix(project2, psiFile2, wordRange, wordToSave, this.myLayer);
    }

    public static void applyFix(@NotNull Project project2, PsiFile psiFile2, TextRange wordRange, String wordToSave, @Nullable DictionaryLayer layer) {
        if (project2 == null) {
            SaveTo.$$$reportNull$$$0(5);
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            if (layer == null) {
                JBList dictList = new JBList((Collection)ContainerUtil.map(DictionaryLayersProvider.getAllLayers(project2), it -> it.getName()));
                JBPopupFactory.getInstance().createListPopupBuilder((JList)dictList).setTitle(SpellCheckerBundle.message("select.dictionary.title", new Object[0])).setItemChosenCallback(() -> CommandProcessor.getInstance().executeCommand(project2, () -> SaveTo.acceptWord(wordToSave, DictionaryLayersProvider.getLayer(project2, (String)dictList.getSelectedValue()), psiFile2, wordRange), SpellCheckerBundle.message("save.0.to.dictionary.action", wordToSave), null)).createPopup().showInBestPositionFor(context);
            } else {
                SaveTo.acceptWord(wordToSave, layer, psiFile2, wordRange);
            }
        });
    }

    private static void acceptWord(String word, @Nullable DictionaryLayer layer, PsiFile file, TextRange wordRange) {
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
        Project project2 = file.getProject();
        SpellCheckerManager.getInstance(project2).acceptWordAsCorrect$intellij_spellchecker(word, file.getViewProvider().getVirtualFile(), project2, layer);
        UpdateHighlightersUtil.removeHighlightersWithExactRange((Document)file.getViewProvider().getDocument(), (Project)project2, (Segment)wordRange, (String)"SpellCheckingInspection");
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    public static String getFixName() {
        return SpellCheckerBundle.message("save.0.to.dictionary.fix", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

