/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.ui.DomColumnInfo;
import com.intellij.util.xml.ui.ErrorableTableCellRenderer;
import java.lang.reflect.Type;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ChildGenericValueColumnInfo<T extends DomElement>
extends DomColumnInfo<T, String> {
    private final TableCellEditor myEditor;
    private final DomFixedChildDescription myChildDescription;

    public ChildGenericValueColumnInfo(@NlsContexts.ColumnName String name, @NotNull DomFixedChildDescription description2, TableCellRenderer renderer2, TableCellEditor editor) {
        if (description2 == null) {
            ChildGenericValueColumnInfo.$$$reportNull$$$0(0);
        }
        super(name, renderer2);
        this.myEditor = editor;
        this.myChildDescription = description2;
    }

    public ChildGenericValueColumnInfo(@NlsContexts.ColumnName String name, DomFixedChildDescription description2, TableCellEditor editor) {
        this(name, description2, new DefaultTableCellRenderer(), editor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChildGenericValueColumnInfo that = (ChildGenericValueColumnInfo)((Object)o);
        return this.myChildDescription.equals(that.myChildDescription);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myChildDescription.hashCode();
        return result2;
    }

    public final TableCellEditor getEditor(T value2) {
        return this.myEditor;
    }

    public final Class<T> getColumnClass() {
        return ClassUtil.getRawType((Type)this.myChildDescription.getType());
    }

    public TableCellRenderer getCustomizedRenderer(T domElement, TableCellRenderer renderer2) {
        assert (domElement.isValid());
        return this.getErrorableCellRenderer(renderer2, domElement);
    }

    public DefaultTableCellRenderer getErrorableCellRenderer(TableCellRenderer renderer2, T domElement) {
        return new ErrorableTableCellRenderer<GenericDomValue>(this.getGenericValue(domElement), renderer2, (DomElement)domElement);
    }

    public void setValue(T o, String aValue) {
        this.getGenericValue(o).setStringValue(aValue);
    }

    protected final GenericDomValue getGenericValue(T o) {
        return (GenericDomValue)this.myChildDescription.getValues((DomElement)o).get(0);
    }

    public final String valueOf(T object) {
        if (!object.isValid()) {
            return null;
        }
        String stringValue = this.getGenericValue(object).getStringValue();
        return StringUtil.isEmpty((String)stringValue) ? this.getEmptyValuePresentation(object) : stringValue;
    }

    protected final DomFixedChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    protected String getEmptyValuePresentation(T object) {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/xml/ui/ChildGenericValueColumnInfo", "<init>"));
    }
}

