/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.formatting.LineWrappingUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import com.intellij.vcs.commit.message.BodyLimitInspectionOptions;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BodyLimitInspection
extends BaseCommitMessageInspection {
    public int RIGHT_MARGIN = 72;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string2 = VcsBundle.message("inspection.BodyLimitInspection.display.name", new Object[0]);
        if (string2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public ConfigurableUi<Project> createOptionsConfigurable() {
        return new BodyLimitInspectionOptions(this);
    }

    @Override
    protected ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull Document document2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            BodyLimitInspection.$$$reportNull$$$0(1);
        }
        if (document2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            BodyLimitInspection.$$$reportNull$$$0(3);
        }
        return (ProblemDescriptor[])IntStream.range(1, document2.getLineCount()).mapToObj(line -> {
            String problemText = VcsBundle.message("commit.message.inspection.message.body.lines.should.not.exceed.characters", this.RIGHT_MARGIN);
            return BodyLimitInspection.checkRightMargin(file, document2, manager, isOnTheFly, line, this.RIGHT_MARGIN, problemText, new WrapLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix());
        }).filter(Predicates.nonNull()).toArray(ProblemDescriptor[]::new);
    }

    @Override
    public boolean canReformat(@NotNull Project project2, @NotNull Document document2) {
        if (project2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(4);
        }
        if (document2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(5);
        }
        return this.hasProblems(project2, document2);
    }

    @Override
    public void reformat(@NotNull Project project2, @NotNull Document document2) {
        if (project2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(6);
        }
        if (document2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(7);
        }
        new WrapLineQuickFix().doApplyFix(project2, document2, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/message/BodyLimitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/message/BodyLimitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canReformat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }

    protected class WrapLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected WrapLineQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string2 = VcsBundle.message("commit.message.intention.family.name.wrap.line", new Object[0]);
            if (string2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        public void doApplyFix(@NotNull Project project2, @NotNull Document document2, @Nullable ProblemDescriptor descriptor) {
            Editor editor;
            if (project2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(1);
            }
            if (document2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(2);
            }
            if ((editor = CommitMessage.getEditor(document2)) != null) {
                TextRange range;
                TextRange textRange = range = descriptor != null && descriptor.getLineNumber() >= 0 ? DocumentUtil.getLineTextRange((Document)document2, (int)descriptor.getLineNumber()) : WrapLineQuickFix.getBodyRange(document2);
                if (!range.isEmpty()) {
                    WrapLineQuickFix.wrapLines(project2, editor, document2, BodyLimitInspection.this.RIGHT_MARGIN, range);
                }
            }
        }

        @NotNull
        private static TextRange getBodyRange(@NotNull Document document2) {
            if (document2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(3);
            }
            TextRange textRange = document2.getLineCount() > 1 ? TextRange.create((int)document2.getLineStartOffset(1), (int)document2.getTextLength()) : TextRange.EMPTY_RANGE;
            if (textRange == null) {
                WrapLineQuickFix.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        private static void wrapLines(@NotNull Project project2, @NotNull Editor editor, @NotNull Document document2, int rightMargin, @NotNull TextRange range) {
            if (project2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                WrapLineQuickFix.$$$reportNull$$$0(6);
            }
            if (document2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(7);
            }
            if (range == null) {
                WrapLineQuickFix.$$$reportNull$$$0(8);
            }
            List<TextRange> enabledRanges = Collections.singletonList(TextRange.create((int)0, (int)document2.getTextLength()));
            LineWrappingUtil.doWrapLongLinesIfNecessary((Editor)editor, (Project)project2, (Document)document2, (int)range.getStartOffset(), (int)range.getEndOffset(), enabledRanges, (int)rightMargin);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 5, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/message/BodyLimitInspection$WrapLineQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/message/BodyLimitInspection$WrapLineQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBodyRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getBodyRange";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapLines";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 5, 6, 7, 8 -> new IllegalArgumentException(string2);
            };
        }
    }
}

