/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentLinearGraphImpl
implements LinearGraph {
    @NotNull
    private final Flags mySimpleNodes;
    @NotNull
    private final IntList myNodeToEdgeIndex;
    @NotNull
    private final IntList myLongEdges;

    PermanentLinearGraphImpl(@NotNull Flags simpleNodes, int[] nodeToEdgeIndex, int[] longEdges) {
        if (simpleNodes == null) {
            PermanentLinearGraphImpl.$$$reportNull$$$0(0);
        }
        this.mySimpleNodes = simpleNodes;
        this.myNodeToEdgeIndex = CompressedIntList.newInstance(nodeToEdgeIndex);
        this.myLongEdges = CompressedIntList.newInstance(longEdges);
    }

    @Override
    public int nodesCount() {
        return this.mySimpleNodes.size();
    }

    @Override
    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter2) {
        boolean hasUpSimpleEdge;
        if (filter2 == null) {
            PermanentLinearGraphImpl.$$$reportNull$$$0(1);
        }
        SmartList result2 = new SmartList();
        boolean bl = hasUpSimpleEdge = nodeIndex != 0 && this.mySimpleNodes.get(nodeIndex - 1);
        if (hasUpSimpleEdge && filter2.upNormal) {
            result2.add(new GraphEdge(nodeIndex - 1, nodeIndex, null, GraphEdgeType.USUAL));
        }
        for (int i = this.myNodeToEdgeIndex.get(nodeIndex); i < this.myNodeToEdgeIndex.get(nodeIndex + 1); ++i) {
            int adjacentNode = this.myLongEdges.get(i);
            if (adjacentNode < 0 && filter2.special) {
                result2.add(GraphEdge.createEdgeWithTargetId(nodeIndex, adjacentNode, GraphEdgeType.NOT_LOAD_COMMIT));
            }
            if (adjacentNode < 0) continue;
            if (nodeIndex > adjacentNode && filter2.upNormal) {
                result2.add(new GraphEdge(adjacentNode, nodeIndex, null, GraphEdgeType.USUAL));
            }
            if (nodeIndex >= adjacentNode || !filter2.downNormal) continue;
            result2.add(new GraphEdge(nodeIndex, adjacentNode, null, GraphEdgeType.USUAL));
        }
        if (this.mySimpleNodes.get(nodeIndex) && filter2.downNormal) {
            result2.add(new GraphEdge(nodeIndex, nodeIndex + 1, null, GraphEdgeType.USUAL));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PermanentLinearGraphImpl.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    @NotNull
    public GraphNode getGraphNode(int nodeIndex) {
        return new GraphNode(nodeIndex);
    }

    @Override
    public int getNodeId(int nodeIndex) {
        assert (nodeIndex >= 0 && nodeIndex < this.nodesCount()) : "Bad nodeIndex: " + nodeIndex;
        return nodeIndex;
    }

    @Override
    @Nullable
    public Integer getNodeIndex(int nodeId) {
        if (nodeId >= 0 && nodeId < this.nodesCount()) {
            return nodeId;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleNodes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentEdges";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

