/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.history.VcsLogFileHistoryFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.BranchFilterModel;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponentAction;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002$%BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020!H\u0007J\u0006\u0010\"\u001a\u00020!J\b\u0010#\u001a\u00020\u001cH\u0007R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterUi;", "Lcom/intellij/vcs/log/VcsLogFilterUi;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "properties", "Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "initialFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "filterConsumer", "Ljava/util/function/Consumer;", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/history/FileHistoryUiProperties;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogFilterCollection;Ljava/util/function/Consumer;)V", "branchFilterModel", "Lcom/intellij/vcs/log/ui/filter/BranchFilterModel;", "propertiesWrapper", "Lcom/intellij/vcs/log/history/FileHistoryFilterUi$PropertiesWrapper;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "getVisiblePack", "()Lcom/intellij/vcs/log/visible/VisiblePack;", "setVisiblePack", "(Lcom/intellij/vcs/log/visible/VisiblePack;)V", "clearFilters", "", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getFilters", "hasBranchFilter", "", "isBranchFilterEnabled", "resetFiltersToDefault", "BranchFilterComponent", "PropertiesWrapper", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryFilterUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterUi.kt\ncom/intellij/vcs/log/history/FileHistoryFilterUi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1747#2,3:108\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterUi.kt\ncom/intellij/vcs/log/history/FileHistoryFilterUi\n*L\n57#1:108,3\n*E\n"})
public final class FileHistoryFilterUi
implements VcsLogFilterUi {
    @NotNull
    private final FilePath path;
    @Nullable
    private final Hash hash;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VcsLogData data;
    @NotNull
    private final VcsLogFilterCollection initialFilters;
    @NotNull
    private final PropertiesWrapper propertiesWrapper;
    @NotNull
    private final BranchFilterModel branchFilterModel;
    @NotNull
    private VisiblePack visiblePack;

    public FileHistoryFilterUi(@NotNull FilePath path2, @Nullable Hash hash2, @NotNull VirtualFile root, @NotNull FileHistoryUiProperties properties2, @NotNull VcsLogData data2, @NotNull VcsLogFilterCollection initialFilters, @NotNull Consumer<VcsLogFilterCollection> filterConsumer) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)initialFilters, (String)"initialFilters");
        Intrinsics.checkNotNullParameter(filterConsumer, (String)"filterConsumer");
        this.path = path2;
        this.hash = hash2;
        this.root = root;
        this.data = data2;
        this.initialFilters = initialFilters;
        this.propertiesWrapper = new PropertiesWrapper(properties2);
        VisiblePack visiblePack = VisiblePack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"EMPTY");
        this.visiblePack = visiblePack;
        Supplier<VisiblePack> supplier = () -> FileHistoryFilterUi._init_$lambda$0(this);
        VcsLogStorage vcsLogStorage = this.data.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
        this.branchFilterModel = new BranchFilterModel(supplier, vcsLogStorage, CollectionsKt.listOf((Object)this.root), this.propertiesWrapper, this.initialFilters);
        this.branchFilterModel.setVisibleRoots$intellij_platform_vcs_log_impl(CollectionsKt.listOf((Object)this.root));
        this.branchFilterModel.addSetFilterListener(() -> FileHistoryFilterUi._init_$lambda$1(filterConsumer, this));
    }

    @NotNull
    public final VisiblePack getVisiblePack() {
        return this.visiblePack;
    }

    public final void setVisiblePack(@NotNull VisiblePack visiblePack) {
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"<set-?>");
        this.visiblePack = visiblePack;
    }

    @Override
    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFileHistoryFilter fileFilter = new VcsLogFileHistoryFilter(this.path, this.hash);
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{fileFilter, this.branchFilterModel.getBranchFilter(), this.branchFilterModel.getRevisionFilter(), this.branchFilterModel.getRangeFilter()};
        return VcsLogFilterObject.collection(vcsLogFilterArray);
    }

    @RequiresEdt
    public final boolean hasBranchFilter() {
        BranchFilters branchFilters = (BranchFilters)this.branchFilterModel.getFilter();
        return branchFilters != null ? !branchFilters.isEmpty() : false;
    }

    public final boolean isBranchFilterEnabled() {
        boolean bl;
        block5: {
            VcsLogIndex vcsLogIndex = this.data.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"getIndex(...)");
            DataPackBase dataPackBase = this.visiblePack.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)dataPackBase, (String)"getDataPack(...)");
            if (FileHistoryFilterer.Companion.canFilterWithIndex$intellij_platform_vcs_log_impl(vcsLogIndex, this.root, dataPackBase)) {
                return true;
            }
            Object object = this.data.getLogProviders().get(this.root);
            if (object == null || (object = object.getFileHistoryHandler(this.data.getProject())) == null) {
                return false;
            }
            Object handler2 = object;
            Set<VcsLogFilterCollection.FilterKey<?>> supportedFilters = handler2.getSupportedFilters(this.root, this.path, this.hash);
            Iterable $this$any$iv = BranchFilterModel.Companion.getBranchFilterKeys$intellij_platform_vcs_log_impl();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsLogFilterCollection.FilterKey it = (VcsLogFilterCollection.FilterKey)element$iv;
                    boolean bl2 = false;
                    if (!supportedFilters.contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @RequiresEdt
    public final void resetFiltersToDefault() {
        this.branchFilterModel.setFilter(BranchFilters.Companion.fromCollection(this.initialFilters));
    }

    @RequiresEdt
    public final void clearFilters() {
        this.branchFilterModel.setFilter(null);
    }

    @NotNull
    public final ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new BranchFilterComponent());
        return (ActionGroup)actionGroup;
    }

    private static final VisiblePack _init_$lambda$0(FileHistoryFilterUi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.visiblePack;
    }

    private static final void _init_$lambda$1(Consumer $filterConsumer, FileHistoryFilterUi this$0) {
        Intrinsics.checkNotNullParameter((Object)$filterConsumer, (String)"$filterConsumer");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $filterConsumer.accept(this$0.getFilters());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0017\u0010\u000b\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterUi$BranchFilterComponent;", "Lcom/intellij/vcs/log/ui/filter/VcsLogPopupComponentAction;", "(Lcom/intellij/vcs/log/history/FileHistoryFilterUi;)V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getTargetComponent", "Lorg/jetbrains/annotations/NotNull;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "intellij.platform.vcs.log.impl"})
    private final class BranchFilterComponent
    extends VcsLogPopupComponentAction {
        public BranchFilterComponent() {
            Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.branch.filter.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            super(supplier);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            JComponent it = jComponent = new BranchFilterPopupComponent(FileHistoryFilterUi.this.propertiesWrapper, FileHistoryFilterUi.this.branchFilterModel).initUi();
            boolean bl = false;
            it.setEnabled(presentation2.isEnabled());
            JComponent jComponent2 = jComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"also(...)");
            return jComponent2;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(FileHistoryFilterUi.this.isBranchFilterEnabled());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        @Nullable
        protected JComponent getTargetComponent(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileHistoryUi fileHistoryUi2 = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
            return fileHistoryUi2 != null ? fileHistoryUi2.getToolbar() : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0097\u0001J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0097\u0001J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0016J\u001d\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0096\u0001J\"\u0010\u0019\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0097\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u001c\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\t2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0011\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0097\u0001J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\tH\u0016J*\u0010\u001f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010 \u001a\u0002H\u0016H\u0097\u0003\u00a2\u0006\u0002\u0010!R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterUi$PropertiesWrapper;", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "properties", "Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "(Lcom/intellij/vcs/log/history/FileHistoryUiProperties;)V", "filters", "", "", "", "addChangeListener", "", "listener", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$PropertiesChangeListener;", "parent", "Lcom/intellij/openapi/Disposable;", "addRecentlyFilteredGroup", "filterName", "values", "", "exists", "", "T", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "get", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;)Ljava/lang/Object;", "getFilterValues", "getRecentlyFilteredGroups", "removeChangeListener", "saveFilterValues", "set", "value", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;Ljava/lang/Object;)V", "intellij.platform.vcs.log.impl"})
    private static final class PropertiesWrapper
    implements MainVcsLogUiProperties,
    VcsLogUiProperties {
        @NotNull
        private final FileHistoryUiProperties properties;
        @NotNull
        private final Map<String, List<String>> filters;

        public PropertiesWrapper(@NotNull FileHistoryUiProperties properties2) {
            Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
            this.properties = properties2;
            this.filters = new LinkedHashMap();
        }

        @Override
        @RequiresEdt
        public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.properties.addChangeListener(listener2);
        }

        @Override
        @RequiresEdt
        public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2, @NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.properties.addChangeListener(listener2, parent);
        }

        @Override
        public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
            Intrinsics.checkNotNullParameter(property2, (String)"property");
            return this.properties.exists(property2);
        }

        @Override
        @RequiresEdt
        public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
            Intrinsics.checkNotNullParameter(property2, (String)"property");
            return this.properties.get(property2);
        }

        @Override
        @RequiresEdt
        public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.properties.removeChangeListener(listener2);
        }

        @Override
        @RequiresEdt
        public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2, T value2) {
            Intrinsics.checkNotNullParameter(property2, (String)"property");
            this.properties.set(property2, value2);
        }

        @Override
        @Nullable
        public List<String> getFilterValues(@NotNull String filterName) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            return this.filters.get(filterName);
        }

        @Override
        public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values2) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            if (values2 != null) {
                this.filters.put(filterName, values2);
            } else {
                this.filters.remove(filterName);
            }
        }

        @Override
        public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values2) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            this.properties.addRecentlyFilteredGroup$intellij_platform_vcs_log_impl(filterName, values2);
        }

        @Override
        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            return this.properties.getRecentlyFilteredGroups$intellij_platform_vcs_log_impl(filterName);
        }
    }
}

