/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    @NotNull
    private final Map<String, Map<String, Color>> myPath2Palette;
    @NotNull
    private final List<FilePath> myPaths;

    public VcsLogColorManagerImpl(@NotNull Collection<? extends FilePath> paths, @NotNull List<Color> defaultPalette, AdditionalColorSpace ... additionalColorSpaces) {
        if (paths == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(0);
        }
        if (defaultPalette == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(1);
        }
        this.myPaths = new ArrayList<FilePath>(paths);
        this.myPath2Palette = new HashMap<String, Map<String, Color>>();
        defaultPalette = defaultPalette.isEmpty() ? List.of(VcsLogColorManagerImpl.getDefaultRootColor()) : new ArrayList<Color>(defaultPalette);
        this.myPath2Palette.put("default", this.generateFromPalette(defaultPalette));
        for (AdditionalColorSpace colorSpace : additionalColorSpaces) {
            if (colorSpace.colorMode.equals("default") || colorSpace.palette.size() != defaultPalette.size()) continue;
            Map<String, Color> colors = this.generateFromPalette(new ArrayList<Color>(colorSpace.palette));
            this.myPath2Palette.put(colorSpace.colorMode, colors);
        }
    }

    private Map<String, Color> generateFromPalette(@NotNull List<Color> defaultPalette) {
        if (defaultPalette == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(2);
        }
        HashMap<String, Color> path2Palette = new HashMap<String, Color>();
        for (int i = 0; i < this.myPaths.size(); ++i) {
            path2Palette.put(this.myPaths.get(i).getPath(), VcsLogColorManagerImpl.getColor(i, this.myPaths.size(), defaultPalette));
        }
        return path2Palette;
    }

    @NotNull
    private static Color getColor(int rootNumber, int rootsCount, @NotNull List<Color> palette) {
        Color color2;
        int size;
        if (palette == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(3);
        }
        if (rootNumber >= (size = palette.size())) {
            double balance = (double)(rootNumber / size) / (double)(rootsCount / size);
            Color mix = ColorUtil.mix((Color)palette.get(rootNumber % size), (Color)palette.get((rootNumber + 1) % size), (double)balance);
            int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(rootsCount / size) + 1.0);
            color2 = mix instanceof JBColor ? JBColor.lazy(() -> new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)))) : new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
        } else {
            color2 = palette.get(rootNumber);
        }
        Color color3 = color2;
        if (color3 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(4);
        }
        return color3;
    }

    @Override
    @NotNull
    public Color getPathColor(@NotNull FilePath path2, @NotNull String colorMode) {
        if (path2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(5);
        }
        if (colorMode == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(6);
        }
        return this.getColor(path2.getPath(), colorMode);
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root, @NotNull String colorMode) {
        if (root == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(7);
        }
        if (colorMode == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(8);
        }
        return this.getColor(root.getPath(), colorMode);
    }

    @NotNull
    private Color getColor(@NotNull String path2, @NotNull String colorMode) {
        Map<String, Color> paletteToColor;
        Color color2;
        if (path2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(9);
        }
        if (colorMode == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(10);
        }
        if ((color2 = (paletteToColor = this.myPath2Palette.getOrDefault(colorMode, this.myPath2Palette.get("default"))).get(path2)) == null) {
            LOG.error("No color record for path " + path2 + ". All paths: " + paletteToColor);
            color2 = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        Color color3 = color2;
        if (color3 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(11);
        }
        return color3;
    }

    @NotNull
    private static Color getDefaultRootColor() {
        Color color2 = UIUtil.getTableBackground();
        if (color2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(12);
        }
        return color2;
    }

    @Override
    @NotNull
    public Collection<FilePath> getPaths() {
        List<FilePath> list2 = this.myPaths;
        if (list2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPalette";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRootColor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateFromPalette";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathColor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootColor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 11, 12, 13 -> new IllegalStateException(string2);
        };
    }

    public static class AdditionalColorSpace {
        private final String colorMode;
        private final List<Color> palette;

        AdditionalColorSpace(@NotNull String colorMode, @NotNull List<Color> palette) {
            if (colorMode == null) {
                AdditionalColorSpace.$$$reportNull$$$0(0);
            }
            if (palette == null) {
                AdditionalColorSpace.$$$reportNull$$$0(1);
            }
            this.colorMode = colorMode;
            this.palette = palette;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "colorMode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "palette";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl$AdditionalColorSpace";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

