/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    public static final JBValue TOP_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue BOTTOM_TEXT_PADDING = JBVG.value(2.0f);
    public static final JBValue RIGHT_PADDING = JBVG.value(4.0f);
    public static final JBValue LEFT_PADDING = JBVG.value(4.0f);
    public static final JBValue COMPACT_MIDDLE_PADDING = JBVG.value(2.0f);
    public static final JBValue MIDDLE_PADDING = JBVG.value(12.0f);
    public static final JBValue ICON_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue LABEL_ARC = JBVG.value(6.0f);
    private static final int MAX_LENGTH = 22;
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final LabelIconCache myIconCache;
    @NotNull
    private final UpdateScaleHelper myUpdateScaleHelper;
    @NotNull
    protected List<Pair<String, LabelIcon>> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    protected Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;
    private boolean myIsOpaque;
    private boolean myCompact;
    private boolean myLeftAligned;

    public LabelPainter(@NotNull JComponent component2, @NotNull LabelIconCache iconCache) {
        if (component2 == null) {
            LabelPainter.$$$reportNull$$$0(0);
        }
        if (iconCache == null) {
            LabelPainter.$$$reportNull$$$0(1);
        }
        this.myUpdateScaleHelper = new UpdateScaleHelper();
        this.myLabels = new ArrayList<Pair<String, LabelIcon>>();
        this.myHeight = JBUIScale.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myIsOpaque = true;
        this.myComponent = component2;
        this.myIconCache = iconCache;
    }

    public void updateHeight() {
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
    }

    public void customizePainter(@NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth, @NotNull List<? extends RefGroup> refGroups) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(2);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(3);
        }
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(4);
        }
        this.myBackground = background;
        this.myForeground = foreground;
        this.updateHeight();
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myGreyBackground = ExperimentalUI.isNewUI() ? null : LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation2 = this.calculatePresentation(refGroups, metrics, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation2.first;
        this.myWidth = (Integer)presentation2.second;
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth, boolean compact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(5);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(6);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(7);
        }
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = new ArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create(labels, (Object)width);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(8);
            }
            return pair;
        }
        if (compact) {
            return this.calculateCompactPresentation(refGroups, fontMetrics, background, availableWidth);
        }
        return this.calculateLongPresentation(refGroups, fontMetrics, background, availableWidth);
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculateCompactPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(9);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(10);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(11);
        }
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList<Pair> labels = new ArrayList<Pair>();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create(labels, (Object)width);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(12);
            }
            return pair;
        }
        for (RefGroup refGroup : refGroups) {
            List<Color> colors = refGroup.getColors();
            LabelIcon labelIcon = this.getIcon(fontMetrics.getHeight(), background, colors);
            int newWidth = width + labelIcon.getIconWidth() + (refGroup != ContainerUtil.getLastItem(refGroups) ? COMPACT_MIDDLE_PADDING.get() : 0);
            String text2 = LabelPainter.shortenRefName(refGroup.getName(), fontMetrics, availableWidth - newWidth);
            newWidth += fontMetrics.stringWidth(text2);
            labels.add(Pair.create((Object)text2, (Object)labelIcon));
            width = newWidth += LabelPainter.getIconTextPadding();
        }
        Pair pair = Pair.create(labels, (Object)width);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculateLongPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(14);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(15);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(16);
        }
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList<Pair> labels = new ArrayList<Pair>();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create(labels, (Object)width);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(17);
            }
            return pair;
        }
        int height = fontMetrics.getHeight();
        for (int i = 0; i < refGroups.size(); ++i) {
            RefGroup group2 = refGroups.get(i);
            int doNotFitWidth = 0;
            if (i < refGroups.size() - 1) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List<Color> colors = group2.getColors();
            LabelIcon labelIcon = this.getIcon(height, background, colors);
            int newWidth = width + labelIcon.getIconWidth() + (i != refGroups.size() - 1 ? MIDDLE_PADDING.get() : 0);
            String text2 = LabelPainter.getGroupText(group2, fontMetrics, availableWidth - newWidth - doNotFitWidth);
            newWidth += fontMetrics.stringWidth(text2);
            if (availableWidth - (newWidth += LabelPainter.getIconTextPadding()) - doNotFitWidth < 0) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i, refGroups.size())));
                String name = labels.isEmpty() ? text2 : "";
                labels.add(Pair.create((Object)name, (Object)lastIcon));
                width += fontMetrics.stringWidth(name) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text2, (Object)labelIcon));
            width = newWidth;
        }
        Pair pair = Pair.create(labels, (Object)width);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    private LabelIcon getIcon(int height, @NotNull Color background, @NotNull List<? extends Color> colors) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(19);
        }
        if (colors == null) {
            LabelPainter.$$$reportNull$$$0(20);
        }
        LabelIcon labelIcon = this.myIconCache.getIcon(this.myComponent, height, background, colors);
        if (labelIcon == null) {
            LabelPainter.$$$reportNull$$$0(21);
        }
        return labelIcon;
    }

    @NotNull
    private static List<Color> getColors(@NotNull Collection<? extends RefGroup> groups) {
        if (groups == null) {
            LabelPainter.$$$reportNull$$$0(22);
        }
        LinkedHashMap<Color, Integer> usedColors = new LinkedHashMap<Color, Integer>();
        for (RefGroup refGroup : groups) {
            List<Color> colors = refGroup.getColors();
            for (Color color2 : colors) {
                Integer count = (Integer)usedColors.get(color2);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color2, count + 1);
            }
        }
        ArrayList<Color> result2 = new ArrayList<Color>();
        for (Map.Entry entry2 : usedColors.entrySet()) {
            result2.add((Color)entry2.getKey());
            if ((Integer)entry2.getValue() <= 1) continue;
            result2.add((Color)entry2.getKey());
        }
        ArrayList<Color> arrayList = result2;
        if (arrayList == null) {
            LabelPainter.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group2, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (group2 == null) {
            LabelPainter.$$$reportNull$$$0(24);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(25);
        }
        if (!group2.isExpanded()) {
            return LabelPainter.shortenRefName(group2.getName(), fontMetrics, availableWidth);
        }
        StringBuilder text2 = new StringBuilder();
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i = 0; i < group2.getRefs().size(); ++i) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i == group2.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(group2.getRefs().get(i).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text2.append(remainder);
                break;
            }
            text2.append(firstRef ? "" : separator).append(refName);
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        String string2 = text2.toString();
        if (string2 == null) {
            LabelPainter.$$$reportNull$$$0(26);
        }
        return string2;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<? extends RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(27);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(28);
        }
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return CurrentBranchComponent.getBranchPresentationBackground(background);
        }
        for (RefGroup refGroup : refGroups) {
            boolean paintGreyBackground;
            if (refGroup.isExpanded()) {
                paintGreyBackground = ContainerUtil.find(refGroup.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !refGroup.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return CurrentBranchComponent.getBranchPresentationBackground(background);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull @NlsSafe String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            LabelPainter.$$$reportNull$$$0(29);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(30);
        }
        if (fontMetrics.stringWidth((String)refName) > availableWidth && ((String)refName).length() > 22) {
            int separatorIndex = ((String)refName).indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + ((String)refName).substring(separatorIndex);
            }
            if (availableWidth > 0) {
                String string2 = VcsLogUiUtil.shortenTextToFit((String)refName, fontMetrics, availableWidth, 22, "\u2026");
                if (string2 == null) {
                    LabelPainter.$$$reportNull$$$0(31);
                }
                return string2;
            }
            String string3 = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)"\u2026");
            if (string3 == null) {
                LabelPainter.$$$reportNull$$$0(32);
            }
            return string3;
        }
        String string4 = refName;
        if (string4 == null) {
            LabelPainter.$$$reportNull$$$0(33);
        }
        return string4;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            LabelPainter.$$$reportNull$$$0(34);
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.getFractionalMetricsValue()).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.getTextAntiAliasingValue());
        g2.setFont(LabelPainter.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        if (this.myIsOpaque) {
            g2.setColor(this.myBackground);
            g2.fillRect(x, y, this.myWidth, height);
        }
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get());
        }
        x += LEFT_PADDING.get();
        for (Pair<String, LabelIcon> label2 : this.myLabels) {
            LabelIcon icon2 = (LabelIcon)label2.second;
            String text2 = (String)label2.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - MIDDLE_PADDING.get() / 3, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), icon2.getIconWidth() + fontMetrics.stringWidth(text2) + 2 * MIDDLE_PADDING.get() / 3, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get(), LABEL_ARC.get(), LABEL_ARC.get()));
            }
            icon2.paintIcon(null, g2, x, y + (height - icon2.getIconHeight()) / 2);
            x += icon2.getIconWidth();
            g2.setColor(this.myForeground);
            g2.drawString(text2, x += LabelPainter.getIconTextPadding(), y + baseLine);
            x += fontMetrics.stringWidth(text2) + (this.myCompact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get());
        }
        config.restore();
    }

    private static int getIconTextPadding() {
        return ExperimentalUI.isNewUI() ? ICON_TEXT_PADDING.get() : 0;
    }

    private Object getTextAntiAliasingValue() {
        return Objects.requireNonNullElse(this.myComponent.getClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING), AntialiasingType.getKeyForCurrentScope((boolean)false));
    }

    private Object getFractionalMetricsValue() {
        return Objects.requireNonNullElse(this.myComponent.getClientProperty(RenderingHints.KEY_FRACTIONALMETRICS), UISettings.Companion.getPreferredFractionalMetricsValue());
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        this.myUpdateScaleHelper.saveScaleAndRunIfChanged(this::updateHeight);
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return this.myLeftAligned;
    }

    public static Font getReferenceFont() {
        Font font = GraphCommitCellRenderer.getLabelFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }

    public void setLeftAligned(boolean leftAligned) {
        this.myLeftAligned = leftAligned;
    }

    public void setOpaque(boolean isOpaque) {
        this.myIsOpaque = isOpaque;
    }

    public void clear() {
        this.myLabels.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 13, 17, 18, 21, 23, 26, 31, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconCache";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refGroups";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCompactPresentation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLongPresentation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupText";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizePainter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculatePresentation";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateCompactPresentation";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateLongPresentation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getGroupText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "calculateGreyBackground";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shortenRefName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 12, 13, 17, 18, 21, 23, 26, 31, 32, 33 -> new IllegalStateException(string2);
        };
    }
}

