/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J:\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer;", "Lcom/intellij/vcs/log/ui/table/RootCellRenderer;", "properties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "stripePart", "Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion$RootStripePart;", "getRootNameInsets", "Ljava/awt/Insets;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "paintBackground", "", "g", "Ljava/awt/Graphics2D;", "x", "width", "height", "Companion", "intellij.platform.vcs.log.impl"})
public final class NewUiRootCellRenderer
extends RootCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Companion.RootStripePart stripePart;

    public NewUiRootCellRenderer(@NotNull VcsLogUiProperties properties2, @NotNull VcsLogColorManager colorManager) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        super(properties2, colorManager);
        this.stripePart = Companion.RootStripePart.SINGLE;
        this.setTextAlign(2);
    }

    @Override
    protected void paintBackground(@NotNull Graphics2D g, int x, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.myBorderColor);
        g.fillRect(x, 0, width, height);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int y = 0;
        int x2 = NewUiRootCellRenderer.Companion.getLEFT_RIGHT_GAP();
        int arc = NewUiRootCellRenderer.Companion.getARC();
        int stripeWidth = this.isNarrow ? NewUiRootCellRenderer.Companion.getNARROW_STRIPE_WIDTH() : width - 2 * NewUiRootCellRenderer.Companion.getLEFT_RIGHT_GAP();
        g.setColor(this.myColor);
        switch (WhenMappings.$EnumSwitchMapping$0[this.stripePart.ordinal()]) {
            case 1: {
                g.fillRoundRect(x2, y, stripeWidth, height + arc, arc, arc);
                break;
            }
            case 2: {
                g.fillRect(x2, y, stripeWidth, height);
                break;
            }
            case 3: {
                g.fillRoundRect(x2, y - arc, stripeWidth, height + NewUiRootCellRenderer.Companion.getBOTTOM_GAP(), arc, arc);
                break;
            }
            case 4: {
                g.fillRoundRect(x2, y, stripeWidth, height - NewUiRootCellRenderer.Companion.getBOTTOM_GAP(), arc, arc);
            }
        }
        config.restore();
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2, int column) {
        Color color2;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Component renderer2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column);
        this.stripePart = NewUiRootCellRenderer.Companion.getRootPart((FilePath)value2, table, row2, column);
        if (this.isNarrow) {
            Color color3 = ((VcsLogGraphTable)((Object)table)).getStyle(row2, column, hasFocus, false, false).getBackground();
            color2 = color3;
            Intrinsics.checkNotNull((Object)color3);
        } else {
            color2 = VcsLogGraphTable.getTableBackground();
        }
        this.myBorderColor = color2;
        Intrinsics.checkNotNull((Object)renderer2);
        return renderer2;
    }

    @Override
    @NotNull
    protected Insets getRootNameInsets() {
        JBInsets jBInsets = JBUI.insets((int)0, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion;", "", "()V", "ARC", "", "getARC", "()I", "BOTTOM_GAP", "getBOTTOM_GAP", "LEFT_RIGHT_GAP", "getLEFT_RIGHT_GAP", "NARROW_STRIPE_WIDTH", "getNARROW_STRIPE_WIDTH", "getRootPart", "Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion$RootStripePart;", "current", "Lcom/intellij/openapi/vcs/FilePath;", "table", "Ljavax/swing/JTable;", "row", "column", "RootStripePart", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final int getLEFT_RIGHT_GAP() {
            return JBUIScale.scale((int)2);
        }

        private final int getBOTTOM_GAP() {
            return JBUIScale.scale((int)2);
        }

        private final int getARC() {
            return JBUIScale.scale((int)4);
        }

        private final int getNARROW_STRIPE_WIDTH() {
            return JBUIScale.scale((int)4);
        }

        private final RootStripePart getRootPart(FilePath current, JTable table, int row2, int column) {
            if (current == null) {
                return RootStripePart.SINGLE;
            }
            Object prev = row2 > 0 ? table.getValueAt(row2 - 1, column) : null;
            Object next = row2 <= table.getRowCount() - 2 ? table.getValueAt(row2 + 1, column) : null;
            boolean isPrevSame = prev != null && Intrinsics.areEqual((Object)prev, (Object)current);
            boolean isNextSame = next != null && Intrinsics.areEqual((Object)next, (Object)current);
            return isPrevSame && isNextSame ? RootStripePart.MIDDLE : (!isPrevSame && !isNextSame ? RootStripePart.SINGLE : (isPrevSame ? RootStripePart.END : RootStripePart.START));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion$RootStripePart;", "", "(Ljava/lang/String;I)V", "START", "MIDDLE", "END", "SINGLE", "intellij.platform.vcs.log.impl"})
        private static final class RootStripePart
        extends Enum<RootStripePart> {
            public static final /* enum */ RootStripePart START = new RootStripePart();
            public static final /* enum */ RootStripePart MIDDLE = new RootStripePart();
            public static final /* enum */ RootStripePart END = new RootStripePart();
            public static final /* enum */ RootStripePart SINGLE = new RootStripePart();
            private static final /* synthetic */ RootStripePart[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static RootStripePart[] values() {
                return (RootStripePart[])$VALUES.clone();
            }

            public static RootStripePart valueOf(String value2) {
                return Enum.valueOf(RootStripePart.class, value2);
            }

            @NotNull
            public static EnumEntries<RootStripePart> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = rootStripePartArray = new RootStripePart[]{RootStripePart.START, RootStripePart.MIDDLE, RootStripePart.END, RootStripePart.SINGLE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.RootStripePart.values().length];
            try {
                nArray[Companion.RootStripePart.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.RootStripePart.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.RootStripePart.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.RootStripePart.SINGLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

