/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.RangeFilterResult;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a6\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001a*\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a6\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u001aH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "filterByRange", "Lcom/intellij/vcs/log/visible/RangeFilterResult;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "rangeFilter", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "getCommitsByRange", "Lit/unimi/dsi/fastutil/ints/IntSet;", "root", "range", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/CommitId;", "resolveCommit", "refName", "", "resolveCommits", "vcsLogStorage", "Lcom/intellij/vcs/log/VcsLogRangeFilter$RefRange;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogRangeFilterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogRangeFilterUtil.kt\ncom/intellij/vcs/log/visible/VcsLogRangeFilterUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n46#2,5:92\n46#2,5:97\n*S KotlinDebug\n*F\n+ 1 VcsLogRangeFilterUtil.kt\ncom/intellij/vcs/log/visible/VcsLogRangeFilterUtilKt\n*L\n66#1:92,5\n70#1:97,5\n*E\n"})
public final class VcsLogRangeFilterUtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final RangeFilterResult filterByRange(@NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull DataPack dataPack, @NotNull VcsLogRangeFilter rangeFilter) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)rangeFilter, (String)"rangeFilter");
        IntOpenHashSet set = new IntOpenHashSet();
        for (VcsLogRangeFilter.RefRange range : rangeFilter.getRanges()) {
            boolean rangeResolvedAnywhere = false;
            Iterator<Map.Entry<VirtualFile, ? extends VcsLogProvider>> iterator = logProviders.entrySet().iterator();
            while (iterator.hasNext()) {
                VirtualFile root = iterator.next().getKey();
                Pair<CommitId, CommitId> resolvedRange = VcsLogRangeFilterUtilKt.resolveCommits(storage, dataPack, root, range);
                if (resolvedRange == null) continue;
                IntSet commits2 = VcsLogRangeFilterUtilKt.getCommitsByRange(storage, dataPack, root, resolvedRange);
                if (commits2 == null) {
                    return RangeFilterResult.Error.INSTANCE;
                }
                set.addAll((IntCollection)commits2);
                rangeResolvedAnywhere = true;
            }
            if (rangeResolvedAnywhere) continue;
            LOG.warn("Range limits unresolved for: " + range);
            return RangeFilterResult.InvalidRange.INSTANCE;
        }
        return new RangeFilterResult.Commits((IntSet)set);
    }

    private static final IntSet getCommitsByRange(VcsLogStorage storage, DataPack dataPack, VirtualFile root, Pair<CommitId, CommitId> range) {
        Hash hash2 = ((CommitId)range.getFirst()).getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"getHash(...)");
        int fromIndex = storage.getCommitIndex(hash2, root);
        Hash hash3 = ((CommitId)range.getSecond()).getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash3, (String)"getHash(...)");
        int toIndex = storage.getCommitIndex(hash3, root);
        return DataPackUtilKt.subgraphDifference(dataPack, toIndex, fromIndex);
    }

    private static final Pair<CommitId, CommitId> resolveCommits(VcsLogStorage vcsLogStorage, DataPack dataPack, VirtualFile root, VcsLogRangeFilter.RefRange range) {
        CommitId commitId2 = VcsLogRangeFilterUtilKt.resolveCommit(vcsLogStorage, dataPack, root, range.getExclusiveRef());
        if (commitId2 == null) {
            boolean bl = false;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Can not resolve " + range.getExclusiveRef() + " in " + root + " for range " + range, e$iv);
            }
            return null;
        }
        CommitId from = commitId2;
        CommitId commitId3 = VcsLogRangeFilterUtilKt.resolveCommit(vcsLogStorage, dataPack, root, range.getInclusiveRef());
        if (commitId3 == null) {
            boolean bl = false;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl3 = false;
                logger.debug("Can not resolve " + range.getInclusiveRef() + " in " + root + " for range " + range, e$iv);
            }
            return null;
        }
        CommitId to = commitId3;
        return TuplesKt.to((Object)from, (Object)to);
    }

    private static final CommitId resolveCommit(VcsLogStorage storage, DataPack dataPack, VirtualFile root, String refName) {
        if (VcsLogUtil.isFullHash(refName)) {
            CommitId commitId2 = new CommitId(HashImpl.build(refName), root);
            return storage.containsCommit(commitId2) ? commitId2 : null;
        }
        RefsModel refsModel = dataPack.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        VcsRef ref = DataPackUtilKt.findBranch(refsModel, refName, root);
        if (ref != null) {
            return new CommitId(ref.getCommitHash(), root);
        }
        if (refName.length() >= 8 && VcsLogUtil.HASH_REGEX.matcher(refName).matches()) {
            return storage.findCommitId(new CommitIdByStringCondition(refName));
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.vcs.log.visible.VcsLogRangeFilterUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

