/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes;

import com.intellij.diagnostic.PluginException;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.util.text.SemVer;
import com.intellij.webSymbols.webTypes.WebTypesEmbeddedIconLoader;
import com.intellij.webSymbols.webTypes.WebTypesScopeBase;
import com.intellij.webSymbols.webTypes.WebTypesSymbolTypeSupportFactory;
import com.intellij.webSymbols.webTypes.WebTypesVersionsRegistry;
import com.intellij.webSymbols.webTypes.impl.WebTypesDefinitionsEP;
import com.intellij.webSymbols.webTypes.json.WebTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000  2\u00020\u0001:\u0003 !\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultWebTypesScope", "Lcom/intellij/webSymbols/webTypes/WebTypesScopeBase;", "getDefaultWebTypesScope", "()Lcom/intellij/webSymbols/webTypes/WebTypesScopeBase;", "packagesEnabledByDefault", "", "", "Lcom/intellij/util/text/SemVer;", "getPackagesEnabledByDefault", "()Ljava/util/Map;", "state", "Lcom/intellij/openapi/util/ClearableLazyValue;", "Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "webTypesEnabledPackages", "", "getWebTypesEnabledPackages", "()Ljava/util/Set;", "dispose", "", "getWebTypes", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "packageName", "packageVersion", "Companion", "DefaultWebTypesScope", "State", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebTypesEmbeddedDefinitionsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n11#2:131\n*S KotlinDebug\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader\n*L\n34#1:131\n*E\n"})
public final class WebTypesEmbeddedDefinitionsLoader
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ClearableLazyValue<State> state;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public WebTypesEmbeddedDefinitionsLoader(@NotNull Project project2) {
        void it;
        ClearableLazyValue clearableLazyValue;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ClearableLazyValue clearableLazyValue2 = clearableLazyValue = ClearableLazyValue.create(() -> WebTypesEmbeddedDefinitionsLoader.state$lambda$0(this));
        WebTypesEmbeddedDefinitionsLoader webTypesEmbeddedDefinitionsLoader = this;
        boolean bl = false;
        WebTypesDefinitionsEP.Companion.getEP_NAME().addChangeListener(() -> WebTypesEmbeddedDefinitionsLoader.state$lambda$3$lambda$1((ClearableLazyValue)it), (Disposable)this);
        WebTypesDefinitionsEP.Companion.getEP_NAME_DEPRECATED$intellij_platform_webSymbols().addChangeListener(() -> WebTypesEmbeddedDefinitionsLoader.state$lambda$3$lambda$2((ClearableLazyValue)it), (Disposable)this);
        ClearableLazyValue clearableLazyValue3 = clearableLazyValue;
        Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue3, (String)"also(...)");
        webTypesEmbeddedDefinitionsLoader.state = clearableLazyValue3;
    }

    private final Set<String> getWebTypesEnabledPackages() {
        return ((State)this.state.getValue()).getVersionsRegistry().getPackages();
    }

    private final Map<String, SemVer> getPackagesEnabledByDefault() {
        return ((State)this.state.getValue()).getPackagesEnabledByDefault();
    }

    private final WebTypesScopeBase getDefaultWebTypesScope() {
        return ((State)this.state.getValue()).getDefaultWebTypesScope();
    }

    private final Pair<PluginDescriptor, WebTypes> getWebTypes(String packageName, SemVer packageVersion) {
        return ((State)this.state.getValue()).getVersionsRegistry().get(packageName, packageVersion);
    }

    public void dispose() {
    }

    private static final State state$lambda$0(WebTypesEmbeddedDefinitionsLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new State(this$0.project);
    }

    private static final void state$lambda$3$lambda$1(ClearableLazyValue $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.drop();
    }

    private static final void state$lambda$3$lambda$2(ClearableLazyValue $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.drop();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebTypesEmbeddedDefinitionsLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00142\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "forPackage", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "project", "Lcom/intellij/openapi/project/Project;", "packageName", "", "packageVersion", "Lcom/intellij/util/text/SemVer;", "getDefaultWebTypesScope", "Lcom/intellij/webSymbols/webTypes/WebTypesScopeBase;", "getInstance", "Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader;", "getPackagesEnabledByDefault", "", "getWebTypesEnabledPackages", "", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebTypesEmbeddedDefinitionsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,130:1\n31#2,2:131\n*S KotlinDebug\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$Companion\n*L\n20#1:131,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebTypesEmbeddedDefinitionsLoader getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<WebTypesEmbeddedDefinitionsLoader> serviceClass$iv = WebTypesEmbeddedDefinitionsLoader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WebTypesEmbeddedDefinitionsLoader)object;
        }

        @Nullable
        public final Pair<PluginDescriptor, WebTypes> forPackage(@NotNull Project project2, @NotNull String packageName, @Nullable SemVer packageVersion) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return this.getInstance(project2).getWebTypes(packageName, packageVersion);
        }

        @NotNull
        public final Set<String> getWebTypesEnabledPackages(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(project2).getWebTypesEnabledPackages();
        }

        @NotNull
        public final Map<String, SemVer> getPackagesEnabledByDefault(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(project2).getPackagesEnabledByDefault();
        }

        @NotNull
        public final WebTypesScopeBase getDefaultWebTypesScope(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(project2).getDefaultWebTypesScope();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\bH\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$DefaultWebTypesScope;", "Lcom/intellij/webSymbols/webTypes/WebTypesScopeBase;", "state", "Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;Lcom/intellij/openapi/project/Project;)V", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebTypesEmbeddedDefinitionsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$DefaultWebTypesScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
    private static final class DefaultWebTypesScope
    extends WebTypesScopeBase {
        @NotNull
        private final State state;
        @NotNull
        private final Project project;

        public DefaultWebTypesScope(@NotNull State state, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.state = state;
            this.project = project2;
            for (Map.Entry<String, SemVer> entry2 : this.state.getPackagesEnabledByDefault().entrySet()) {
                Pair<PluginDescriptor, WebTypes> pair;
                if (this.state.getVersionsRegistry().get(entry2.getKey(), entry2.getValue()) == null) continue;
                boolean bl = false;
                PluginDescriptor pluginDescriptor = (PluginDescriptor)pair.component1();
                WebTypes webTypes = (WebTypes)pair.component2();
                this.addWebTypes(webTypes, new WebTypesScopeBase.WebTypesJsonOriginImpl(webTypes, WebTypesSymbolTypeSupportFactory.Companion.get$default(WebTypesSymbolTypeSupportFactory.Companion, webTypes, null, null, 6, null), this.project, null, null, (Function1)new Function1<String, Icon>((Object)new WebTypesEmbeddedIconLoader(pluginDescriptor)){

                    @NotNull
                    public final Icon invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((WebTypesEmbeddedIconLoader)this.receiver).loadIcon(p0);
                    }
                }, null, 24, null));
            }
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DefaultWebTypesScope && Intrinsics.areEqual((Object)((DefaultWebTypesScope)other).state, (Object)this.state);
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        @Override
        @NotNull
        public Pointer<? extends WebTypesScopeBase> createPointer() {
            Project project2 = this.state.getProject();
            return () -> DefaultWebTypesScope.createPointer$lambda$1(project2);
        }

        private static final WebTypesScopeBase createPointer$lambda$1(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            if ($project.isDisposed()) {
                return null;
            }
            return ((State)Companion.getInstance($project).state.getValue()).getDefaultWebTypesScope();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultWebTypesScope", "Lcom/intellij/webSymbols/webTypes/WebTypesScopeBase;", "getDefaultWebTypesScope", "()Lcom/intellij/webSymbols/webTypes/WebTypesScopeBase;", "packagesEnabledByDefault", "", "", "Lcom/intellij/util/text/SemVer;", "getPackagesEnabledByDefault", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "versionsRegistry", "Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry;", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "getVersionsRegistry", "()Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry;", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.webSymbols"})
    private static final class State {
        @NotNull
        private final Project project;
        @NotNull
        private final WebTypesVersionsRegistry<Pair<PluginDescriptor, WebTypes>> versionsRegistry;
        @NotNull
        private final Map<String, SemVer> packagesEnabledByDefault;
        @NotNull
        private final WebTypesScopeBase defaultWebTypesScope;

        public State(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
            this.versionsRegistry = new WebTypesVersionsRegistry();
            HashMap<String, SemVer> packagesEnabledByDefault = new HashMap<String, SemVer>();
            for (WebTypesDefinitionsEP ep : CollectionsKt.plus((Collection)WebTypesDefinitionsEP.Companion.getEP_NAME().getExtensionList(), (Iterable)WebTypesDefinitionsEP.Companion.getEP_NAME_DEPRECATED$intellij_platform_webSymbols().getExtensionList())) {
                try {
                    SemVer semVer;
                    Object object = ep.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(...)");
                    WebTypes webTypes = (WebTypes)object;
                    Intrinsics.checkNotNull((Object)SemVer.parseFromText((String)webTypes.getVersion()));
                    if (Intrinsics.areEqual((Object)ep.enableByDefault, (Object)true)) {
                        packagesEnabledByDefault.merge(webTypes.getName(), semVer, (arg_0, arg_1) -> State._init_$lambda$0(3.INSTANCE, arg_0, arg_1));
                    }
                    String string2 = webTypes.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    this.versionsRegistry.put(string2, semVer, (Pair<PluginDescriptor, WebTypes>)new Pair((Object)ep.getPluginDescriptor(), (Object)webTypes));
                }
                catch (PluginException e) {
                    LOG.error((Throwable)e);
                }
            }
            this.packagesEnabledByDefault = packagesEnabledByDefault;
            this.defaultWebTypesScope = new DefaultWebTypesScope(this, this.project);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final WebTypesVersionsRegistry<Pair<PluginDescriptor, WebTypes>> getVersionsRegistry() {
            return this.versionsRegistry;
        }

        @NotNull
        public final Map<String, SemVer> getPackagesEnabledByDefault() {
            return this.packagesEnabledByDefault;
        }

        @NotNull
        public final WebTypesScopeBase getDefaultWebTypesScope() {
            return this.defaultWebTypesScope;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof State && Intrinsics.areEqual((Object)this.project, (Object)((State)other).project) && Intrinsics.areEqual(this.versionsRegistry, ((State)other).versionsRegistry) && Intrinsics.areEqual(this.packagesEnabledByDefault, ((State)other).packagesEnabledByDefault);
        }

        public int hashCode() {
            return this.project.hashCode();
        }

        @NotNull
        public String toString() {
            return "WebTypesEmbeddedDefinitionsLoaderState: project=" + this.project + "; versionsRegistry=" + this.versionsRegistry + "; packagesEnabledByDefault=" + this.packagesEnabledByDefault;
        }

        private static final SemVer _init_$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (SemVer)$tmp0.invoke(p0, p1);
        }
    }
}

