/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepeatedSpaceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(0);
        }
        return new RepeatedSpaceVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection", "buildVisitor"));
    }

    private static class RepeatedSpaceVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RepeatedSpaceVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar aChar) {
            if (!RepeatedSpaceVisitor.isSpace(aChar) || RepeatedSpaceVisitor.isSpace(aChar.getPrevSibling()) || RepeatedSpaceVisitor.isInEscapeSequence(aChar)) {
                return;
            }
            PsiElement parent = aChar.getParent();
            if (parent instanceof RegExpClass || parent instanceof RegExpCharRange) {
                return;
            }
            int count = 1;
            int length = aChar.getTextLength();
            PsiElement next = aChar.getNextSibling();
            while (RepeatedSpaceVisitor.isSpace(next)) {
                ++count;
                length += next.getTextLength();
                next = next.getNextSibling();
            }
            if (count > 1) {
                String message2 = RegExpBundle.message("inspection.warning.consecutive.spaces.in.regexp", count);
                int offset = aChar.getStartOffsetInParent();
                this.myHolder.registerProblem(parent, new TextRange(offset, offset + length), message2, new LocalQuickFix[]{new RepeatedSpaceFix(count)});
            }
        }

        private static boolean isInEscapeSequence(RegExpChar aChar) {
            PsiElement prev = aChar.getPrevSibling();
            while (prev instanceof RegExpChar) {
                prev = prev.getPrevSibling();
            }
            if (RepeatedSpaceVisitor.isEscapeSequenceStart(prev)) {
                return true;
            }
            PsiElement parent = aChar.getParent();
            if (prev != null || !(parent instanceof RegExpBranch)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof RegExpPattern && RepeatedSpaceVisitor.isEscapeSequenceStart(grandParent.getPrevSibling());
        }

        private static boolean isEscapeSequenceStart(@Nullable PsiElement element) {
            return element instanceof PsiWhiteSpace && "\\Q".equals(InjectedLanguageManager.getInstance((Project)element.getProject()).getUnescapedText(element));
        }

        private static boolean isSpace(PsiElement element) {
            if (!(element instanceof RegExpChar)) {
                return false;
            }
            RegExpChar aChar = (RegExpChar)element;
            return aChar.getType() == RegExpChar.Type.CHAR && aChar.getValue() == 32;
        }
    }

    private static class RepeatedSpaceFix
    extends ModCommandQuickFix {
        private final int myCount;

        RepeatedSpaceFix(int count) {
            this.myCount = count;
        }

        @Nls
        @NotNull
        public String getName() {
            String string2 = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{" {" + this.myCount + "}"});
            if (string2 == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.replace.with.space.and.repeated.quantifier", new Object[0]);
            if (string2 == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project2 == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RegExpBranch)) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    RepeatedSpaceFix.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            TextRange range = descriptor.getTextRangeInElement();
            StringBuilder text2 = new StringBuilder();
            boolean inserted = false;
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!range.contains(child.getStartOffsetInParent())) {
                    text2.append(injectedLanguageManager.getUnescapedText(child));
                    continue;
                }
                if (inserted) continue;
                text2.append(" {").append(this.myCount).append('}');
                inserted = true;
            }
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, e -> RegExpReplacementUtil.replaceInContext(e, text2.toString()));
            if (modCommand == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

