/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.git.table;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.git.record.HistoryRecord;
import com.intellij.settingsSync.git.renderers.SettingsHistoryEmptyCellRenderer;
import com.intellij.settingsSync.git.renderers.SettingsHistoryFileCellRenderer;
import com.intellij.settingsSync.git.renderers.SettingsHistoryNodeCellRenderer;
import com.intellij.settingsSync.git.renderers.SettingsHistoryRestoreCellRenderer;
import com.intellij.settingsSync.git.renderers.SettingsHistorySubtitleRenderer;
import com.intellij.settingsSync.git.renderers.SettingsHistoryTitleCellRenderer;
import com.intellij.settingsSync.git.table.FileRow;
import com.intellij.settingsSync.git.table.SeparatorRow;
import com.intellij.settingsSync.git.table.SettingsHistoryTableModel;
import com.intellij.settingsSync.git.table.SettingsHistoryTableRow;
import com.intellij.settingsSync.git.table.SubtitleRow;
import com.intellij.settingsSync.git.table.TitleRow;
import com.intellij.ui.SingleSelectionModel;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.CommitSelectionImpl;
import com.intellij.vcs.log.ui.table.VcsLogCommitList;
import com.intellij.vcs.log.ui.table.VcsLogCommitListModel;
import git4idea.repo.GitRepositoryManager;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0003EFGB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0017H\u0016J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0013H\u0016J\b\u00105\u001a\u00020\u0004H\u0016J\u0010\u00106\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0013H\u0016J\u0018\u0010<\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0018\u0010C\u001a\u00020,2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010D\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/settingsSync/git/table/SettingsHistoryTable;", "Lcom/intellij/ui/table/JBTable;", "Lcom/intellij/vcs/log/ui/table/VcsLogCommitList;", "tableModel", "Lcom/intellij/settingsSync/git/table/SettingsHistoryTableModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/settingsSync/git/table/SettingsHistoryTableModel;Lcom/intellij/openapi/project/Project;)V", "emptyRenderer", "Lcom/intellij/settingsSync/git/renderers/SettingsHistoryEmptyCellRenderer;", "fileRenderer", "Lcom/intellij/settingsSync/git/renderers/SettingsHistoryFileCellRenderer;", "hoveredRecord", "Lcom/intellij/settingsSync/git/record/HistoryRecord;", "getHoveredRecord", "()Lcom/intellij/settingsSync/git/record/HistoryRecord;", "setHoveredRecord", "(Lcom/intellij/settingsSync/git/record/HistoryRecord;)V", "hoveredRow", "", "getHoveredRow", "()I", "isResetHovered", "", "()Z", "setResetHovered", "(Z)V", "listModel", "Lcom/intellij/vcs/log/ui/table/VcsLogCommitListModel;", "getListModel", "()Lcom/intellij/vcs/log/ui/table/VcsLogCommitListModel;", "nodeRenderer", "Lcom/intellij/settingsSync/git/renderers/SettingsHistoryNodeCellRenderer;", "restoreRenderer", "Lcom/intellij/settingsSync/git/renderers/SettingsHistoryRestoreCellRenderer;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "getSelection", "()Lcom/intellij/vcs/log/VcsLogCommitSelection;", "subtitleRenderer", "Lcom/intellij/settingsSync/git/renderers/SettingsHistorySubtitleRenderer;", "titleRenderer", "Lcom/intellij/settingsSync/git/renderers/SettingsHistoryTitleCellRenderer;", "changeSelection", "", "rowIndex", "columnIndex", "toggle", "extend", "getCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "row", "column", "getModel", "getRecordAtRow", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getValueAt", "Lcom/intellij/settingsSync/git/table/SettingsHistoryTableRow;", "isMouseOverRevertButton", "e", "Ljava/awt/event/MouseEvent;", "openChange", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "performRevertAtRow", "setExactWidthForColumn", "width", "Companion", "MouseActionHandler", "MouseMotionHandler", "intellij.settingsSync.git"})
@SourceDebugExtension(value={"SMAP\nSettingsHistoryTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsHistoryTable.kt\ncom/intellij/settingsSync/git/table/SettingsHistoryTable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,244:1\n11095#2:245\n11430#2,3:246\n179#3,2:249\n1855#4,2:251\n11#5:253\n*S KotlinDebug\n*F\n+ 1 SettingsHistoryTable.kt\ncom/intellij/settingsSync/git/table/SettingsHistoryTable\n*L\n126#1:245\n126#1:246,3\n144#1:249,2\n157#1:251,2\n35#1:253\n*E\n"})
public final class SettingsHistoryTable
extends JBTable
implements VcsLogCommitList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsHistoryTableModel tableModel;
    @NotNull
    private final Project project;
    @NotNull
    private final SettingsHistoryNodeCellRenderer nodeRenderer;
    @NotNull
    private final SettingsHistoryTitleCellRenderer titleRenderer;
    @NotNull
    private final SettingsHistorySubtitleRenderer subtitleRenderer;
    @NotNull
    private final SettingsHistoryFileCellRenderer fileRenderer;
    @NotNull
    private final SettingsHistoryRestoreCellRenderer restoreRenderer;
    @NotNull
    private final SettingsHistoryEmptyCellRenderer emptyRenderer;
    private boolean isResetHovered;
    @Nullable
    private HistoryRecord hoveredRecord;
    @NotNull
    private static final Logger logger;

    public SettingsHistoryTable(@NotNull SettingsHistoryTableModel tableModel, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((TableModel)tableModel);
        this.tableModel = tableModel;
        this.project = project;
        this.nodeRenderer = new SettingsHistoryNodeCellRenderer();
        this.titleRenderer = new SettingsHistoryTitleCellRenderer();
        this.subtitleRenderer = new SettingsHistorySubtitleRenderer();
        this.fileRenderer = new SettingsHistoryFileCellRenderer();
        this.restoreRenderer = new SettingsHistoryRestoreCellRenderer();
        this.emptyRenderer = new SettingsHistoryEmptyCellRenderer();
        this.autoResizeMode = 3;
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.showVerticalLines = false;
        this.showHorizontalLines = false;
        this.setExactWidthForColumn(0, 32);
        this.setExactWidthForColumn(2, 34);
        this.selectionModel = (ListSelectionModel)new SingleSelectionModel();
        this.putClientProperty(RenderingUtil.PAINT_HOVERED_BACKGROUND, false);
        this.addMouseListener(new MouseActionHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
    }

    public final boolean isResetHovered() {
        return this.isResetHovered;
    }

    public final void setResetHovered(boolean bl) {
        this.isResetHovered = bl;
    }

    public final int getHoveredRow() {
        return TableHoverListener.getHoveredRow((JTable)((JTable)((Object)this)));
    }

    @Nullable
    public final HistoryRecord getHoveredRecord() {
        return this.hoveredRecord;
    }

    public final void setHoveredRecord(@Nullable HistoryRecord historyRecord) {
        this.hoveredRecord = historyRecord;
    }

    private final void setExactWidthForColumn(int columnIndex, int width) {
        TableColumn tableColumn;
        TableColumn $this$setExactWidthForColumn_u24lambda_u240 = tableColumn = this.columnModel.getColumn(columnIndex);
        boolean bl = false;
        $this$setExactWidthForColumn_u24lambda_u240.setPreferredWidth(width);
        $this$setExactWidthForColumn_u24lambda_u240.setMaxWidth(width);
        $this$setExactWidthForColumn_u24lambda_u240.setMinWidth(width);
    }

    @NotNull
    public SettingsHistoryTableModel getModel() {
        TableModel tableModel = super.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type com.intellij.settingsSync.git.table.SettingsHistoryTableModel");
        return (SettingsHistoryTableModel)tableModel;
    }

    @NotNull
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return (TableCellRenderer)((Object)this.nodeRenderer);
        }
        SettingsHistoryTableRow rowEntity = this.getValueAt(row, column);
        if (column == 1) {
            TableCellRenderer tableCellRenderer;
            SettingsHistoryTableRow settingsHistoryTableRow;
            if (rowEntity instanceof SeparatorRow) {
                if (this.getRowHeight(row) != 16) {
                    this.setRowHeight(row, 16);
                }
            } else if (this.getRowHeight(row) != 24) {
                this.setRowHeight(row, 24);
            }
            if ((settingsHistoryTableRow = rowEntity) instanceof TitleRow) {
                tableCellRenderer = (TableCellRenderer)((Object)this.titleRenderer);
            } else if (settingsHistoryTableRow instanceof SubtitleRow) {
                tableCellRenderer = (TableCellRenderer)((Object)this.subtitleRenderer);
            } else if (settingsHistoryTableRow instanceof FileRow) {
                tableCellRenderer = (TableCellRenderer)((Object)this.fileRenderer);
            } else if (settingsHistoryTableRow instanceof SeparatorRow) {
                tableCellRenderer = (TableCellRenderer)((Object)this.emptyRenderer);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return tableCellRenderer;
        }
        if (column == 2) {
            if (rowEntity instanceof TitleRow) {
                return (TableCellRenderer)((Object)this.restoreRenderer);
            }
            return (TableCellRenderer)((Object)this.emptyRenderer);
        }
        return (TableCellRenderer)((Object)this.emptyRenderer);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        SettingsHistoryTableRow row = this.getValueAt(rowIndex, 0);
        if (!(row instanceof SeparatorRow) && !(row instanceof SubtitleRow)) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    @NotNull
    public SettingsHistoryTableRow getValueAt(int row, int column) {
        Object object = super.getValueAt(row, column);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.settingsSync.git.table.SettingsHistoryTableRow");
        return (SettingsHistoryTableRow)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsLogCommitSelection getSelection() {
        void $this$mapTo$iv$iv;
        int[] nArray = this.selectionModel.getSelectedIndices();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
        int[] $this$map$iv = nArray;
        boolean $i$f$map = false;
        int[] nArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.tableModel.getVisiblePack$intellij_settingsSync_git().getVisibleGraph().getVisibleRowIndex((Object)this.getRecordAtRow((int)it).getCommitId()));
        }
        int[] visibleGraphRows = CollectionsKt.toIntArray((Collection)CollectionsKt.distinct((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv))));
        VcsLogData vcsLogData = this.tableModel.getLogData();
        VisibleGraph visibleGraph = this.tableModel.getVisiblePack$intellij_settingsSync_git().getVisibleGraph();
        Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"getVisibleGraph(...)");
        return (VcsLogCommitSelection)new CommitSelectionImpl(vcsLogData, visibleGraph, visibleGraphRows);
    }

    @NotNull
    public VcsLogCommitListModel getListModel() {
        return this.tableModel;
    }

    private final HistoryRecord getRecordAtRow(int rowIndex) {
        return this.getValueAt(rowIndex, 0).getRecord();
    }

    private final void performRevertAtRow(int rowIndex) {
        HistoryRecord recordToRestore;
        HistoryRecord historyRecord = recordToRestore = rowIndex == 0 ? SettingsHistoryTable.performRevertAtRow$getNextDistinctRecord(this, 0) : this.getRecordAtRow(rowIndex);
        if (recordToRestore == null) {
            logger.warn("Failed to get record to restore. Row index = " + rowIndex);
            return;
        }
        String string = recordToRestore.getId().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String commitHash = string;
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.RestoreSettingsSnapshot(commitHash, () -> SettingsHistoryTable.performRevertAtRow$lambda$4(this)));
    }

    private final Collection<VirtualFile> getRoots() {
        Collection collection = this.getModel().getLogData().getRoots();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRoots(...)");
        return collection;
    }

    private final boolean isMouseOverRevertButton(int rowIndex, MouseEvent e) {
        SettingsHistoryTableRow row = this.getValueAt(rowIndex, 0);
        return row instanceof TitleRow && this.columnAtPoint(e.getPoint()) == 2;
    }

    private final void openChange(Change change) {
        ShowDiffContext showDiffContext;
        ShowDiffContext $this$openChange_u24lambda_u245 = showDiffContext = new ShowDiffContext();
        boolean bl = false;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ChangesUtil.getFilePath((Change)change).getName(), (String)"getName(...)");
        $this$openChange_u24lambda_u245.putChangeContext(change, DiffUserDataKeysEx.VCS_DIFF_EDITOR_TAB_TITLE, (Object)SettingsSyncBundle.INSTANCE.message("ui.toolwindow.editor.diff.tab.title", objectArray));
        ShowDiffContext showDiffContext2 = showDiffContext;
        ShowDiffAction.showDiffForChange((Project)this.project, (ListSelection)ListSelection.create((List)CollectionsKt.listOf((Object)change), (Object)change), (ShowDiffContext)showDiffContext2);
    }

    private static final HistoryRecord performRevertAtRow$getNextDistinctRecord(SettingsHistoryTable this$0, int rowIndex) {
        Object v0;
        block1: {
            HistoryRecord currentRecord = this$0.getRecordAtRow(rowIndex);
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)(rowIndex + 1), (int)this$0.getRowCount()))), (Function1)((Function1)new Function1<Integer, HistoryRecord>(this$0){
                final /* synthetic */ SettingsHistoryTable this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final HistoryRecord invoke(int it) {
                    return SettingsHistoryTable.access$getRecordAtRow(this.this$0, it);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HistoryRecord it = (HistoryRecord)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)currentRecord))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void performRevertAtRow$lambda$4(SettingsHistoryTable this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getInstance(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        Iterable $this$forEach$iv = this$0.getRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            repositoryManager.updateRepository(it);
        }
    }

    public static final /* synthetic */ HistoryRecord access$getRecordAtRow(SettingsHistoryTable $this, int rowIndex) {
        return $this.getRecordAtRow(rowIndex);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsHistoryTable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SettingsHistoryTable.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/git/table/SettingsHistoryTable$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/git/table/SettingsHistoryTable$MouseActionHandler;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/settingsSync/git/table/SettingsHistoryTable;)V", "handleRowClick", "", "rowIndex", "", "e", "Ljava/awt/event/MouseEvent;", "handleTitleRowClick", "row", "Lcom/intellij/settingsSync/git/table/SettingsHistoryTableRow;", "mouseClicked", "mouseEntered", "mouseExited", "intellij.settingsSync.git"})
    @SourceDebugExtension(value={"SMAP\nSettingsHistoryTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsHistoryTable.kt\ncom/intellij/settingsSync/git/table/SettingsHistoryTable$MouseActionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
    private final class MouseActionHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(@Nullable MouseEvent e) {
            block1: {
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) break block1;
                MouseEvent mouseEvent2 = mouseEvent;
                SettingsHistoryTable settingsHistoryTable = SettingsHistoryTable.this;
                MouseEvent it = mouseEvent2;
                boolean bl = false;
                int rowIndex = settingsHistoryTable.rowAtPoint(it.getPoint());
                if (rowIndex != -1) {
                    this.handleRowClick(rowIndex, it);
                }
            }
        }

        @Override
        public void mouseEntered(@Nullable MouseEvent e) {
            block0: {
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) break block0;
                MouseEvent mouseEvent2 = mouseEvent;
                SettingsHistoryTable settingsHistoryTable = SettingsHistoryTable.this;
                MouseEvent it = mouseEvent2;
                boolean bl = false;
                settingsHistoryTable.repaint();
            }
        }

        @Override
        public void mouseExited(@Nullable MouseEvent e) {
            block0: {
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) break block0;
                MouseEvent mouseEvent2 = mouseEvent;
                SettingsHistoryTable settingsHistoryTable = SettingsHistoryTable.this;
                MouseEvent it = mouseEvent2;
                boolean bl = false;
                settingsHistoryTable.repaint();
            }
        }

        private final void handleRowClick(int rowIndex, MouseEvent e) {
            SettingsHistoryTableRow row = SettingsHistoryTable.this.getValueAt(rowIndex, 0);
            if (row instanceof TitleRow) {
                this.handleTitleRowClick(row, rowIndex, e);
            } else if (row instanceof FileRow) {
                SettingsHistoryTable.this.openChange(((FileRow)row).getChange());
            }
            SettingsHistoryTable.this.repaint();
        }

        private final void handleTitleRowClick(SettingsHistoryTableRow row, int rowIndex, MouseEvent e) {
            boolean isMouseOverRevert;
            boolean bl = isMouseOverRevert = SettingsHistoryTable.this.columnAtPoint(e.getPoint()) == 2;
            if (isMouseOverRevert) {
                SettingsHistoryTable.this.performRevertAtRow(rowIndex);
            } else {
                SettingsHistoryTableModel settingsHistoryTableModel = SettingsHistoryTable.this.getModel();
                Intrinsics.checkNotNull((Object)row, (String)"null cannot be cast to non-null type com.intellij.settingsSync.git.table.TitleRow");
                settingsHistoryTableModel.toggleRowExpanding((TitleRow)row);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/git/table/SettingsHistoryTable$MouseMotionHandler;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/settingsSync/git/table/SettingsHistoryTable;)V", "getHoveredRecord", "Lcom/intellij/settingsSync/git/record/HistoryRecord;", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.settingsSync.git"})
    private final class MouseMotionHandler
    extends MouseAdapter {
        @Override
        public void mouseMoved(@Nullable MouseEvent e) {
            block1: {
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) break block1;
                MouseEvent mouseEvent2 = mouseEvent;
                SettingsHistoryTable settingsHistoryTable = SettingsHistoryTable.this;
                MouseEvent it = mouseEvent2;
                boolean bl = false;
                int rowIndex = settingsHistoryTable.rowAtPoint(it.getPoint());
                boolean oldIsResetHovered = settingsHistoryTable.isResetHovered();
                settingsHistoryTable.setResetHovered(rowIndex != -1 && settingsHistoryTable.isMouseOverRevertButton(rowIndex, it));
                HistoryRecord oldHoveredRecord = settingsHistoryTable.getHoveredRecord();
                settingsHistoryTable.setHoveredRecord(this.getHoveredRecord());
                if (oldIsResetHovered != settingsHistoryTable.isResetHovered() || !Intrinsics.areEqual((Object)oldHoveredRecord, (Object)settingsHistoryTable.getHoveredRecord())) {
                    settingsHistoryTable.repaint();
                }
            }
        }

        private final HistoryRecord getHoveredRecord() {
            int hoveredRowIndex = SettingsHistoryTable.this.getHoveredRow();
            if (hoveredRowIndex == -1) {
                return null;
            }
            SettingsHistoryTableRow row = SettingsHistoryTable.this.getValueAt(hoveredRowIndex, 0);
            if (row instanceof SeparatorRow) {
                return null;
            }
            return row.getRecord();
        }
    }
}

