/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.exp.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.exp.feedback.BlockTerminalFeedbackDialog;
import org.jetbrains.plugins.terminal.exp.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackEvent;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackMoment;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J \u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/terminal/exp/feedback/BlockTerminalSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "()V", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "checkIdeIsSuitable", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "forTest", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterDialogClosedOk", "", "updateStateAfterNotificationShowed", "intellij.terminal"})
public final class BlockTerminalSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2024, 8, 1);
    private final boolean requireIdeEAP;

    public BlockTerminalSurveyConfig() {
        this.surveyId = "new_terminal";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!forTest) {
            TerminalUsageTriggerCollector.INSTANCE.triggerFeedbackSurveyEvent$intellij_terminal(project, TerminalFeedbackEvent.DIALOG_SHOWN, BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project));
        }
        return new BlockTerminalFeedbackDialog(project, forTest);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageTriggerCollector.INSTANCE.triggerFeedbackSurveyEvent$intellij_terminal(project, TerminalFeedbackEvent.FEEDBACK_SENT, BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project));
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isJetBrainsProduct();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageLocalStorage usageStorage = TerminalUsageLocalStorage.Companion.getInstance();
        return !usageStorage.getState().getFeedbackNotificationShown() && (usageStorage.getExecutedCommandsNumber() >= 15 || usageStorage.getExecutedCommandsNumber() > 0 && BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project) == TerminalFeedbackMoment.ON_DISABLING);
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = TerminalBundle.message("feedback.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = TerminalBundle.message("feedback.notification.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new RequestFeedbackNotification("Feedback In IDE", string, string2);
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageLocalStorage.Companion.getInstance().getState().setFeedbackNotificationShown(true);
        TerminalUsageTriggerCollector.INSTANCE.triggerFeedbackSurveyEvent$intellij_terminal(project, TerminalFeedbackEvent.NOTIFICATION_SHOWN, BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project));
    }
}

