/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.AccountsPanelFactory;
import com.intellij.collaboration.auth.ui.login.LoginModel;
import com.intellij.collaboration.auth.ui.login.TokenLoginDialog;
import com.intellij.collaboration.auth.ui.login.TokenLoginInputPanelFactory;
import com.intellij.collaboration.auth.ui.login.TokenLoginPanelModel;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginErrorStatusPresenter;
import org.jetbrains.plugins.gitlab.authentication.GitLabSecurityUtil;
import org.jetbrains.plugins.gitlab.authentication.LoginResult;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabProjectDefaultAccountHolder;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabChooseAccountDialog;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\r\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0001\u00a2\u0006\u0002\b\u000eJ$\u0010\u000f\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJC\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00122\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0019H\u0001\u00a2\u0006\u0002\b\u001aJO\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00122\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0019H\u0001\u00a2\u0006\u0002\b\u001aJ7\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u000b\u0010 \u001a\u00070\n\u00a2\u0006\u0002\b!2\u0006\u0010\"\u001a\u00020\u0010H\u0002JA\u0010#\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u00042\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0019H\u0001\u00a2\u0006\u0002\b%JM\u0010#\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0019H\u0001\u00a2\u0006\u0002\b%\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil;", "", "()V", "chooseAccount", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "description", "", "Lorg/jetbrains/annotations/Nls;", "accounts", "", "chooseAccount$intellij_vcs_gitlab", "isAccountUnique", "", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "username", "logInViaToken", "Lorg/jetbrains/plugins/gitlab/authentication/LoginResult;", "Ljavax/swing/JComponent;", "serverPath", "uniqueAccountPredicate", "Lkotlin/Function2;", "logInViaToken$intellij_vcs_gitlab", "requiredUsername", "showLoginDialog", "", "model", "Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "title", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "serverFieldDisabled", "updateToken", "account", "updateToken$intellij_vcs_gitlab", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabLoginUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabLoginUtil.kt\norg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n14#2:144\n31#3,2:145\n2624#4,3:147\n*S KotlinDebug\n*F\n+ 1 GitLabLoginUtil.kt\norg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil\n*L\n50#1:144\n126#1:145,2\n136#1:147,3\n*E\n"})
public final class GitLabLoginUtil {
    @NotNull
    public static final GitLabLoginUtil INSTANCE = new GitLabLoginUtil();

    private GitLabLoginUtil() {
    }

    @RequiresEdt
    @NotNull
    public final LoginResult logInViaToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabServerPath serverPath, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        return this.logInViaToken$intellij_vcs_gitlab(project, parentComponent, serverPath, null, uniqueAccountPredicate);
    }

    public static /* synthetic */ LoginResult logInViaToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabServerPath gitLabServerPath, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            gitLabServerPath = GitLabServerPath.Companion.getDEFAULT_SERVER();
        }
        return gitLabLoginUtil.logInViaToken$intellij_vcs_gitlab(project, jComponent, gitLabServerPath, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult logInViaToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabServerPath serverPath, @Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        LoginResult loginResult2;
        GitLabTokenLoginPanelModel gitLabTokenLoginPanelModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        GitLabTokenLoginPanelModel $this$logInViaToken_u24lambda_u240 = gitLabTokenLoginPanelModel = new GitLabTokenLoginPanelModel(requiredUsername, uniqueAccountPredicate);
        boolean bl = false;
        $this$logInViaToken_u24lambda_u240.setServerUri(serverPath.getUri());
        GitLabTokenLoginPanelModel model = gitLabTokenLoginPanelModel;
        String dialogTitle = GitLabBundle.message("account.add.dialog.title", new Object[0]);
        int exitCode = this.showLoginDialog(project, parentComponent, model, dialogTitle, false);
        switch (exitCode) {
            case 0: {
                Object $this$asSafely$iv = model.getLoginState().getValue();
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof LoginModel.LoginState.Connected)) {
                    object = null;
                }
                LoginModel.LoginState.Connected connected = (LoginModel.LoginState.Connected)object;
                if (connected == null) {
                    return LoginResult.Failure.INSTANCE;
                }
                LoginModel.LoginState.Connected loginResult3 = connected;
                return new LoginResult.Success(new GitLabAccount(null, loginResult3.getUsername(), model.getServerPath(), 1, null), model.getToken());
            }
            case 2: {
                loginResult2 = LoginResult.OtherMethod.INSTANCE;
                break;
            }
            default: {
                loginResult2 = LoginResult.Failure.INSTANCE;
            }
        }
        return loginResult2;
    }

    public static /* synthetic */ LoginResult logInViaToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabServerPath gitLabServerPath, String string, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            gitLabServerPath = GitLabServerPath.Companion.getDEFAULT_SERVER();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return gitLabLoginUtil.logInViaToken$intellij_vcs_gitlab(project, jComponent, gitLabServerPath, string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult updateToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabAccount account, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        return this.updateToken$intellij_vcs_gitlab(project, parentComponent, account, null, uniqueAccountPredicate);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult updateToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabAccount account, @Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        GitLabTokenLoginPanelModel gitLabTokenLoginPanelModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        Function2 predicateWithoutCurrent2 = (Function2)new Function2<GitLabServerPath, String, Boolean>(account, uniqueAccountPredicate){
            final /* synthetic */ GitLabAccount $account;
            final /* synthetic */ Function2<GitLabServerPath, String, Boolean> $uniqueAccountPredicate;
            {
                this.$account = $account;
                this.$uniqueAccountPredicate = $uniqueAccountPredicate;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull GitLabServerPath serverPath, @NotNull String username) {
                Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                return Intrinsics.areEqual((Object)serverPath, (Object)this.$account.getServer()) && Intrinsics.areEqual((Object)username, (Object)this.$account.getName()) ? true : (Boolean)this.$uniqueAccountPredicate.invoke((Object)serverPath, (Object)username);
            }
        };
        GitLabTokenLoginPanelModel $this$updateToken_u24lambda_u241 = gitLabTokenLoginPanelModel = new GitLabTokenLoginPanelModel(requiredUsername, (Function2<? super GitLabServerPath, ? super String, Boolean>)predicateWithoutCurrent2);
        boolean bl = false;
        $this$updateToken_u24lambda_u241.setServerUri(account.getServer().getUri());
        GitLabTokenLoginPanelModel model = gitLabTokenLoginPanelModel;
        String title2 = GitLabBundle.message("account.update.dialog.title", new Object[0]);
        int exitState = this.showLoginDialog(project, parentComponent, model, title2, true);
        LoginModel.LoginState loginState = (LoginModel.LoginState)model.getLoginState().getValue();
        if (exitState == 0 && loginState instanceof LoginModel.LoginState.Connected) {
            return new LoginResult.Success(new GitLabAccount(null, ((LoginModel.LoginState.Connected)loginState).getUsername(), model.getServerPath(), 1, null), model.getToken());
        }
        return LoginResult.Failure.INSTANCE;
    }

    public static /* synthetic */ LoginResult updateToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabAccount gitLabAccount, String string, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return gitLabLoginUtil.updateToken$intellij_vcs_gitlab(project, jComponent, gitLabAccount, string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    private final int showLoginDialog(Project project, JComponent parentComponent, GitLabTokenLoginPanelModel model, String title2, boolean serverFieldDisabled) {
        TokenLoginDialog dialog2 = new TokenLoginDialog(project, (Component)parentComponent, (LoginModel)model, title2, model.getTryGitAuthorizationSignal(), (Function1)new Function1<CoroutineScope, DialogPanel>(model, serverFieldDisabled){
            final /* synthetic */ GitLabTokenLoginPanelModel $model;
            final /* synthetic */ boolean $serverFieldDisabled;
            {
                this.$model = $model;
                this.$serverFieldDisabled = $serverFieldDisabled;
                super(1);
            }

            @NotNull
            public final DialogPanel invoke(@NotNull CoroutineScope $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                CoroutineScope cs = $this$$receiver;
                Object[] objectArray = new Object[]{GitLabSecurityUtil.INSTANCE.getMASTER_SCOPES()};
                return new TokenLoginInputPanelFactory((TokenLoginPanelModel)this.$model).createIn(cs, this.$serverFieldDisabled, CollaborationToolsBundle.message((String)"clone.dialog.insufficient.scopes", (Object[])objectArray), (ErrorStatusPresenter)new GitLabLoginErrorStatusPresenter(cs, this.$model), (Function1)new Function1<Panel, Unit>(cs){
                    final /* synthetic */ CoroutineScope $cs;
                    {
                        this.$cs = $cs;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$createIn) {
                        Intrinsics.checkNotNullParameter((Object)$this$createIn, (String)"$this$createIn");
                        boolean $i$f$service = false;
                        Class<GitLabAccountManager> serviceClass$iv = GitLabAccountManager.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                        }
                        AccountsPanelFactory.Companion.addWarningForPersistentCredentials$default((AccountsPanelFactory.Companion)AccountsPanelFactory.Companion, (CoroutineScope)this.$cs, (Flow)((GitLabAccountManager)object).getCanPersistCredentials(), (Function1)((Function1)new Function1<Function1<? super Panel, ? extends Unit>, Panel>((Object)$this$createIn){

                            @NotNull
                            public final Panel invoke(@NotNull Function1<? super Panel, Unit> p0) {
                                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                                return ((Panel)this.receiver).panel(p0);
                            }
                        }), null, (int)8, null);
                    }
                });
            }
        });
        dialog2.showAndGet();
        return dialog2.getExitCode();
    }

    @RequiresEdt
    @Nullable
    public final GitLabAccount chooseAccount$intellij_vcs_gitlab(@NotNull Project project, @Nullable Component parentComponent, @Nullable String description, @NotNull Collection<GitLabAccount> accounts) {
        GitLabAccount gitLabAccount;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
        GitLabChooseAccountDialog dialog2 = new GitLabChooseAccountDialog(project, parentComponent, accounts, false, true, null, description, null, 160, null);
        if (dialog2.showAndGet()) {
            GitLabAccount account = dialog2.getAccount();
            if (dialog2.getSetDefault()) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GitLabProjectDefaultAccountHolder> serviceClass$iv = GitLabProjectDefaultAccountHolder.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((GitLabProjectDefaultAccountHolder)((Object)object)).setAccount((Account)account);
            }
            gitLabAccount = account;
        } else {
            gitLabAccount = null;
        }
        return gitLabAccount;
    }

    public final boolean isAccountUnique(@NotNull Collection<GitLabAccount> accounts, @NotNull GitLabServerPath server, @NotNull String username) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Iterable $this$none$iv = accounts;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GitLabAccount it = (GitLabAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getServer(), (Object)server) && Intrinsics.areEqual((Object)it.getName(), (Object)username))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

