/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.StartupImportIcons;
import com.intellij.ide.startup.importSettings.data.BaseSetting;
import com.intellij.ide.startup.importSettings.data.Multiple;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.SimpleActionDescriptor;
import com.intellij.ide.startup.importSettings.transfer.DemoShortcut;
import com.intellij.ide.startup.importSettings.transfer.FeatureSetting;
import com.intellij.ide.startup.importSettings.transfer.RecentProjectSetting;
import com.intellij.ide.startup.importSettings.transfer.TransferableSetting;
import com.intellij.ide.startup.importSettings.transfer.TransferableSettingGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/TransferableSetting;", "Lcom/intellij/ide/startup/importSettings/data/BaseSetting;", "id", "", "name", "icon", "Ljavax/swing/Icon;", "comment", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getId", "getName", "Companion", "intellij.ide.startup.importSettings"})
public class TransferableSetting
implements BaseSetting {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Icon icon;
    @Nullable
    private final String comment;
    @NotNull
    public static final String UI_ID = "ui";
    @NotNull
    public static final String KEYMAP_ID = "keymap";
    @NotNull
    public static final String PLUGINS_ID = "plugins";
    @NotNull
    public static final String RECENT_PROJECTS_ID = "recentProjects";

    public TransferableSetting(@NotNull String id, @NotNull String name, @NotNull Icon icon, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.comment = comment;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/TransferableSetting$Companion;", "", "()V", "KEYMAP_ID", "", "PLUGINS_ID", "RECENT_PROJECTS_ID", "UI_ID", "keymap", "Lcom/intellij/ide/startup/importSettings/data/Multiple;", "Lcom/intellij/ide/startup/importSettings/models/Keymap;", "plugins", "features", "", "Lcom/intellij/ide/startup/importSettings/models/FeatureInfo;", "recentProjects", "projects", "", "Lcom/intellij/ide/startup/importSettings/models/RecentPathInfo;", "uiTheme", "Lcom/intellij/ide/startup/importSettings/transfer/TransferableSetting;", "laf", "Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "intellij.ide.startup.importSettings"})
    @SourceDebugExtension(value={"SMAP\nTransferableSetting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransferableSetting.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferableSetting$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,175:1\n1#2:176\n1549#3:177\n1620#3,3:178\n1360#3:181\n1446#3,2:182\n1549#3:186\n1620#3,3:187\n1448#3,3:190\n1549#3:193\n1620#3,3:194\n1549#3:197\n1620#3,3:198\n1549#3:201\n1620#3,3:202\n9#4:184\n9#4:185\n*S KotlinDebug\n*F\n+ 1 TransferableSetting.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferableSetting$Companion\n*L\n54#1:177\n54#1:178,3\n55#1:181\n55#1:182,2\n64#1:186\n64#1:187,3\n55#1:190,3\n82#1:193\n82#1:194,3\n95#1:197\n95#1:198,3\n96#1:201\n96#1:202,3\n57#1:184\n61#1:185\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TransferableSetting uiTheme(@NotNull ILookAndFeel laf) {
            Intrinsics.checkNotNullParameter((Object)laf, (String)"laf");
            String themeName = laf.getPreview().getName();
            String string = ImportSettingsBundle.INSTANCE.message("transfer.settings.ui-theme", new Object[0]);
            Icon icon = StartupImportIcons.Icons.ColorPicker;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ColorPicker");
            return new TransferableSetting(TransferableSetting.UI_ID, string, icon, themeName);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Multiple keymap(@NotNull Keymap keymap) {
            List list;
            List list2;
            String string;
            int customShortcutCount;
            Object[] objectArray;
            List<KeyBinding> customShortcuts;
            Intrinsics.checkNotNullParameter((Object)keymap, (String)TransferableSetting.KEYMAP_ID);
            PatchedKeymap patchedKeymap = keymap instanceof PatchedKeymap ? (PatchedKeymap)keymap : null;
            List<KeyBinding> list3 = customShortcuts = patchedKeymap != null ? patchedKeymap.getOverrides() : null;
            if (list3 != null) {
                objectArray = (Object[])list3;
                int n = 0;
                for (Object object2 : objectArray) {
                    void it;
                    KeyBinding keyBinding = (KeyBinding)object2;
                    int collection = n;
                    boolean bl = false;
                    int n2 = it.getShortcuts().size();
                    n = collection + n2;
                }
                v2 = n;
            } else {
                v2 = customShortcutCount = 0;
            }
            if (customShortcutCount == 0) {
                string = keymap.getDisplayName();
            } else {
                objectArray = new Object[]{keymap.getDisplayName(), customShortcutCount};
                string = ImportSettingsBundle.INSTANCE.message("transfer.settings.keymap-with-custom-shortcuts", objectArray);
            }
            String title = string;
            Iterable $this$map$iv = keymap.getDemoShortcuts();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it;
                SimpleActionDescriptor simpleActionDescriptor = (SimpleActionDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DemoShortcut(it.getHumanName(), it.getDefaultShortcut()));
            }
            List examples = (List)destination$iv$iv;
            List<KeyBinding> list4 = customShortcuts;
            if (list4 != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = list4;
                boolean list5 = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list6;
                    AnAction anAction;
                    KeyBinding shortcut = (KeyBinding)element$iv$iv;
                    boolean bl = false;
                    AnAction anAction2 = anAction = ActionManager.getInstance().getAction(shortcut.getActionId());
                    if (anAction2 == null) {
                        Companion $this$keymap_u24lambda_u245_u24lambda_u242 = Companion;
                        boolean bl2 = false;
                        Companion $this$thisLogger$iv = $this$keymap_u24lambda_u245_u24lambda_u242;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(Companion.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Cannot find action " + shortcut.getActionId() + ".");
                        list6 = CollectionsKt.emptyList();
                    } else {
                        Intrinsics.checkNotNull((Object)anAction2);
                        AnAction action2 = anAction;
                        if (StringKt.nullize$default((String)action2.getTemplateText(), (boolean)false, (int)1, null) == null) {
                            Companion $this$keymap_u24lambda_u245_u24lambda_u243 = Companion;
                            boolean bl3 = false;
                            Companion $this$thisLogger$iv = $this$keymap_u24lambda_u245_u24lambda_u243;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(Companion.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.error("Cannot determine text of action " + shortcut.getActionId() + ".");
                            list6 = CollectionsKt.emptyList();
                        } else {
                            void $this$mapTo$iv$iv2;
                            Iterable $this$map$iv2 = shortcut.getShortcuts();
                            boolean $i$f$map2 = false;
                            Iterable $this$keymap_u24lambda_u245_u24lambda_u243 = $this$map$iv2;
                            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                void it;
                                String name;
                                KeyboardShortcut keyboardShortcut = (KeyboardShortcut)item$iv$iv;
                                Collection collection = destination$iv$iv3;
                                boolean bl4 = false;
                                collection.add(new DemoShortcut(name, it));
                            }
                            list6 = (List)destination$iv$iv3;
                        }
                    }
                    Iterable list$iv$iv = list6;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = null;
            }
            List custom = list2;
            List $this$keymap_u24lambda_u246 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$keymap_u24lambda_u246.add(examples);
            List list7 = custom;
            if (list7 != null) {
                List p0 = list7;
                boolean bl5 = false;
                $this$keymap_u24lambda_u246.add(p0);
            }
            List items2 = CollectionsKt.build((List)list);
            String string2 = ImportSettingsBundle.INSTANCE.message("transfer.settings.keymap", new Object[0]);
            Icon icon = StartupImportIcons.Icons.Keyboard;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Keyboard");
            return new TransferableSettingGroup(TransferableSetting.KEYMAP_ID, string2, icon, title, items2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Multiple plugins(@NotNull Collection<? extends FeatureInfo> features) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(features, (String)"features");
            int limitForPreview = 3;
            List items2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)features), (Function1)plugins.items.1.INSTANCE), (Function1)plugins.items.2.INSTANCE));
            Iterable $this$map$iv = CollectionsKt.take((Iterable)items2, (int)limitForPreview);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FeatureSetting featureSetting = (FeatureSetting)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getNameForPreview());
            }
            String string = NlsMessages.formatNarrowAndList((Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatNarrowAndList(...)");
            String comment = string;
            List itemGroups = items2.size() > limitForPreview ? CollectionsKt.listOf((Object)items2) : CollectionsKt.emptyList();
            String string2 = ImportSettingsBundle.INSTANCE.message("transfer.settings.plugins", new Object[0]);
            Icon icon = StartupImportIcons.Icons.Plugin;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Plugin");
            return new TransferableSettingGroup(TransferableSetting.PLUGINS_ID, string2, icon, comment, itemGroups);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Multiple recentProjects(@NotNull List<RecentPathInfo> projects) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            int limitForPreview = 6;
            Iterable $this$map$iv = projects;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p0;
                RecentPathInfo recentPathInfo = (RecentPathInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RecentProjectSetting((RecentPathInfo)p0));
            }
            List items2 = (List)destination$iv$iv;
            Iterable $this$map$iv2 = CollectionsKt.take((Iterable)items2, (int)limitForPreview);
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RecentProjectSetting recentProjectSetting = (RecentProjectSetting)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getName());
            }
            String string = NlsMessages.formatNarrowAndList((Collection)((List)destination$iv$iv2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatNarrowAndList(...)");
            String comment = string;
            List itemGroups = items2.size() > limitForPreview ? CollectionsKt.listOf((Object)items2) : CollectionsKt.emptyList();
            String string2 = ImportSettingsBundle.INSTANCE.message("transfer.settings.recent-projects", new Object[0]);
            Icon icon = StartupImportIcons.Icons.Recent;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Recent");
            return new TransferableSettingGroup(TransferableSetting.RECENT_PROJECTS_ID, string2, icon, comment, itemGroups);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

