/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/squareup/wire/internal/LongArrayList;", "", "initialCapacity", "", "(I)V", "data", "", "size", "add", "", "long", "", "ensureCapacity", "minCapacity", "isNotEmpty", "", "toArray", "toString", "", "Companion", "wire-runtime"})
public final class LongArrayList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] data;
    private int size;

    public LongArrayList(int initialCapacity) {
        this.data = new long[initialCapacity];
    }

    @NotNull
    public final long[] toArray() {
        if (this.size < this.data.length) {
            long[] lArray = Arrays.copyOf(this.data, this.size);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.data = lArray;
        }
        return this.data;
    }

    public final void add(long l2) {
        this.ensureCapacity(this.size + 1);
        int n = this.size;
        this.size = n + 1;
        this.data[n] = l2;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            long[] lArray = Arrays.copyOf(this.data, Math.max(this.data.length * 3 / 2 + 1, minCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.data = lArray;
        }
    }

    @NotNull
    public String toString() {
        long[] lArray = Arrays.copyOf(this.data, this.size);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        String string = Arrays.toString(lArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/internal/LongArrayList$Companion;", "", "()V", "forDecoding", "Lcom/squareup/wire/internal/LongArrayList;", "minLengthInBytes", "", "minimumElementByteSize", "wire-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongArrayList forDecoding(long minLengthInBytes, long minimumElementByteSize) {
            int minElements = (int)RangesKt.coerceAtMost((long)(minLengthInBytes / minimumElementByteSize), (long)Integer.MAX_VALUE);
            return new LongArrayList(minElements);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

