/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.CborEncoder;
import kotlinx.serialization.cbor.internal.CborListWriter;
import kotlinx.serialization.cbor.internal.CborMapWriter;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J)\u0010'\u001a\u00020\u0014\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0006\u0010\u0015\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u00101\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u00102\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "encoder", "Lkotlinx/serialization/cbor/internal/CborEncoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborEncoder;)V", "encodeByteArrayAsByteString", "", "getEncoder", "()Lkotlinx/serialization/cbor/internal/CborEncoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "", "value", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescriptor", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeNull", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeShort", "", "encodeString", "", "endStructure", "shouldEncodeElementDefault", "writeBeginToken", "kotlinx-serialization-cbor"})
public class CborWriter
extends AbstractEncoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborEncoder encoder;
    private boolean encodeByteArrayAsByteString;

    public CborWriter(@NotNull Cbor cbor, @NotNull CborEncoder encoder) {
        Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        this.cbor = cbor;
        this.encoder = encoder;
    }

    @NotNull
    protected final CborEncoder getEncoder() {
        return this.encoder;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.cbor.getSerializersModule();
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        if (this.encodeByteArrayAsByteString && Intrinsics.areEqual((Object)serializer2.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            this.encoder.encodeByteString((byte[])value);
        } else {
            this.encodeByteArrayAsByteString = this.encodeByteArrayAsByteString || EncodingKt.access$isInlineByteString(serializer2.getDescriptor());
            super.encodeSerializableValue(serializer2, value);
        }
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.cbor.getEncodeDefaults$kotlinx_serialization_cbor();
    }

    protected void writeBeginToken() {
        this.encoder.startMap();
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        CborWriter writer = (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) ? true : serialKind instanceof PolymorphicKind) ? (CborWriter)new CborListWriter(this.cbor, this.encoder) : (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? (CborWriter)new CborMapWriter(this.cbor, this.encoder) : new CborWriter(this.cbor, this.encoder));
        writer.writeBeginToken();
        return (CompositeEncoder)writer;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encoder.end();
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeByteArrayAsByteString = EncodingKt.access$isByteString(descriptor, index);
        String name = descriptor.getElementName(index);
        this.encoder.encodeString(name);
        return true;
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encoder.encodeString(value);
    }

    public void encodeFloat(float value) {
        this.encoder.encodeFloat(value);
    }

    public void encodeDouble(double value) {
        this.encoder.encodeDouble(value);
    }

    public void encodeChar(char value) {
        this.encoder.encodeNumber(value);
    }

    public void encodeByte(byte value) {
        this.encoder.encodeNumber(value);
    }

    public void encodeShort(short value) {
        this.encoder.encodeNumber(value);
    }

    public void encodeInt(int value) {
        this.encoder.encodeNumber(value);
    }

    public void encodeLong(long value) {
        this.encoder.encodeNumber(value);
    }

    public void encodeBoolean(boolean value) {
        this.encoder.encodeBoolean(value);
    }

    public void encodeNull() {
        this.encoder.encodeNull();
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encoder.encodeString(enumDescriptor.getElementName(index));
    }
}

