/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.Filter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IFilter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IParser;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.AbstractFiltersHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.AutoChoices;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.ChoiceRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.CustomChoice;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IFilterEditor;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IParserModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.ChoiceMatch;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.EditorComponent;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.PopupComponent;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser.DateComparator;

public class FilterEditor
extends JComponent
implements IFilterEditor {
    private static final long serialVersionUID = 6908400421021655278L;
    private Set<CustomChoice> customChoices;
    private AutoChoices autoChoices;
    private Format format;
    private Comparator comparator;
    private Comparator choicesComparator;
    private final Class<?> modelClass;
    private boolean ignoreCase;
    private boolean enabledUI = true;
    EditorFilter filter = new EditorFilter();
    AbstractFiltersHandler filtersHandler;
    EditorComponent editor;
    PopupComponent popup;
    int modelIndex;

    public FilterEditor(AbstractFiltersHandler filtersHandler, int modelIndex, Class<?> modelClass) {
        this.setOpaque(false);
        this.setBackground(Gray.TRANSPARENT);
        this.filtersHandler = filtersHandler;
        this.modelIndex = modelIndex;
        this.modelClass = modelClass;
        this.format = this.getParserModel().getFormat(modelClass);
        this.ignoreCase = this.getParserModel().isIgnoreCase();
        this.comparator = this.getParserModel().getComparator(modelClass);
        this.choicesComparator = modelClass.equals(String.class) || modelClass.isEnum() ? null : this.comparator;
        this.setLayout(new BorderLayout());
        this.setBorder(IdeBorderFactory.createBorder((int)12));
        this.popup = new PopupComponent(this, this.format, this.getChoicesComparator(), this.getStringComparator()){

            @Override
            protected void choiceSelected(Object selection) {
                FilterEditor.this.popupSelection(selection);
            }
        };
        this.editor = new EditorComponent(this, this.popup);
        this.setupComponent(this.editor);
        this.add((Component)this.editor, "Center");
        this.editor.updateParser();
    }

    @Override
    public int getModelIndex() {
        return this.modelIndex;
    }

    @Override
    public Class<?> getModelClass() {
        return this.modelClass;
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void resetFilter() {
        this.popup.clearHistory();
        this.setEditorContent(CustomChoice.MATCH_ALL);
        this.requestChoices();
    }

    @Override
    public void setContent(Object content2) {
        this.setEditorContent(content2 == null || "".equals(content2) ? CustomChoice.MATCH_ALL : content2);
    }

    @Override
    public Object getContent() {
        return this.editor.getContent();
    }

    @Override
    public void setAutoChoices(AutoChoices autoChoices) {
        if (autoChoices != null && autoChoices != this.autoChoices) {
            this.autoChoices = autoChoices;
            ?[] enums = this.modelClass.getEnumConstants();
            if (Boolean.class == this.modelClass || enums != null && enums.length <= 8) {
                this.setEditable(this.editor.isAutoCompletion() || autoChoices == AutoChoices.DISABLED);
                this.setMaxHistory(0);
            } else {
                this.requestChoices();
            }
        }
    }

    @Override
    public AutoChoices getAutoChoices() {
        return this.autoChoices;
    }

    @Override
    public void setCustomChoices(Set<CustomChoice> choices) {
        this.customChoices = choices == null || choices.isEmpty() ? null : new HashSet<CustomChoice>(choices);
        this.requestChoices();
    }

    @Override
    public Set<CustomChoice> getCustomChoices() {
        return this.customChoices == null ? new HashSet<CustomChoice>() : new HashSet<CustomChoice>(this.customChoices);
    }

    @Override
    public void setUserInteractionEnabled(boolean enable) {
        this.enabledUI = enable;
        this.setFilterEnabled(this.filter.isEnabled());
    }

    @Override
    public boolean isUserInteractionEnabled() {
        return this.enabledUI;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.getRenderer() == null) {
            this.editor.setTextMode(editable);
            this.requestChoices();
        }
    }

    @Override
    public boolean isEditable() {
        return this.editor.isEditableContent();
    }

    @Override
    public void setIgnoreCase(boolean set) {
        if (this.ignoreCase != set) {
            this.ignoreCase = set;
            this.formatOrComparatorUpdated();
        }
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setFormat(Format format) {
        if (this.format != format) {
            this.format = format;
            if (format != null && this.comparator instanceof DateComparator && Date.class.isAssignableFrom(this.modelClass)) {
                this.setComparator(DateComparator.getDateComparator(format));
            } else {
                this.formatOrComparatorUpdated();
            }
        }
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setComparator(Comparator comparator) {
        if (comparator != this.comparator && comparator != null) {
            this.comparator = comparator;
            this.formatOrComparatorUpdated();
        }
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public void setChoicesComparator(Comparator comparator) {
        this.choicesComparator = comparator;
        this.formatOrComparatorUpdated();
    }

    @Override
    public Comparator getChoicesComparator() {
        return this.choicesComparator;
    }

    @Override
    public void setAutoCompletion(boolean enable) {
        this.editor.setAutoCompletion(enable);
    }

    @Override
    public boolean isAutoCompletion() {
        return this.editor.isAutoCompletion();
    }

    @Override
    public void setInstantFiltering(boolean enable) {
        this.editor.setInstantFiltering(enable);
    }

    @Override
    public boolean isAllowedInstantVanishing() {
        return this.editor.isAllowedInstantVanishing();
    }

    @Override
    public void setAllowedInstantVanishing(boolean enable) {
        this.editor.setAllowedInstantVanishing(enable);
    }

    @Override
    public boolean isInstantFiltering() {
        return this.editor.isInstantFiltering();
    }

    @Override
    public void setMaxHistory(int size2) {
        this.popup.setMaxHistory(size2);
    }

    @Override
    public int getMaxHistory() {
        return this.popup.getMaxHistory();
    }

    @Override
    public void setHistory(List<Object> history) {
        this.popup.setHistory(history);
    }

    @Override
    public List<Object> getHistory() {
        return this.popup.getHistory();
    }

    @Override
    public void setRenderer(ChoiceRenderer renderer) {
        if (renderer != this.getRenderer()) {
            if (renderer == null) {
                this.popup.setStringContent(this.format, this.choicesComparator, this.getStringComparator());
                this.editor.setTextMode(true);
            } else {
                this.popup.setRenderedContent(renderer, this.choicesComparator == null ? this.comparator : this.choicesComparator, this.getStringComparator());
                this.editor.setRenderMode();
            }
            this.requestChoices();
        }
    }

    @Override
    public ChoiceRenderer getRenderer() {
        return this.popup.getFilterRenderer().getUserRenderer();
    }

    public boolean isEditing() {
        return this.editor.isFocused() && this.isEnabled();
    }

    public void setChoices(Collection<?> choices) {
        this.popup.clearChoices();
        this.addChoices(choices);
    }

    public int getChoicesSize() {
        return this.popup.getChoicesSize();
    }

    public void addChoices(Collection<?> choices) {
        this.popup.addChoices(choices, this.editor.getChoicesParser());
    }

    public void setWarning(boolean warning) {
        this.editor.setWarning(warning);
    }

    void setFilterEnabled(boolean enabled) {
        boolean bl = enabled = enabled && this.enabledUI;
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.popup.getFilterRenderer().setEnabled(enabled);
            this.editor.setEnabled(enabled);
        }
    }

    void filterUpdated(RowFilter editorFilter) {
        this.filter.editorFilterUpdated(editorFilter);
    }

    boolean attemptFilterUpdate(RowFilter editorFilter) {
        return this.filter.attemptEditorFilterUpdate(editorFilter);
    }

    IParser createParser() {
        return this.getParserModel().createParser(this);
    }

    void triggerPopup(Object source2) {
        if (!this.popup.isMenuCanceledForMouseEvent(source2)) {
            this.editor.requestFocus();
            if (this.showChoices()) {
                this.popup.setPopupFocused(true);
            }
        }
    }

    private void setEditorContent(Object content2) {
        this.editor.setContent(content2);
    }

    private void requestChoices() {
        if (this.isEnabled()) {
            this.filtersHandler.updateEditorChoices(this);
        }
    }

    private void formatOrComparatorUpdated() {
        boolean updated;
        ChoiceRenderer lcr = this.getRenderer();
        if (lcr == null) {
            updated = this.popup.setStringContent(this.format, this.choicesComparator, this.getStringComparator());
            this.editor.updateParser();
        } else {
            updated = this.popup.setRenderedContent(lcr, this.choicesComparator == null ? this.comparator : this.choicesComparator, this.getStringComparator());
        }
        if (updated) {
            this.requestChoices();
        }
    }

    private IParserModel getParserModel() {
        return this.filtersHandler.getParserModel();
    }

    private Comparator<String> getStringComparator() {
        return this.getParserModel().getStringComparator(this.ignoreCase);
    }

    private void setupComponent(JComponent component) {
        component.setFocusable(true);
        this.setupEnterKey(component);
        this.setupEscKey(component);
        this.setupHomeKey(component);
        this.setupHomeCtrlKey(component);
        this.setupEndKey(component);
        this.setupEndCtrlKey(component);
        this.setupUpKey(component);
        this.setupUpCtrlKey(component);
        this.setupUpPageKey(component);
        this.setupDownPageKey(component);
        this.setupDownKey(component);
        this.setupDownCtrlKey(component);
    }

    void popupSelection(Object selection) {
        if (selection != null) {
            this.setEditorContent(selection);
            this.filter.consolidateFilter();
        }
    }

    boolean showChoices() {
        if (!this.popup.isVisible() && this.editor.isValid()) {
            if (!this.popup.display(this.editor)) {
                return false;
            }
            ChoiceMatch cm = this.popup.selectBestMatch(this.editor.getContent());
            if (cm.content == null) {
                this.popup.selectBestMatch("");
            }
        }
        return true;
    }

    private void setupEnterKey(JComponent component) {
        @NlsSafe String actionName = "FCB_ENTER";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = 6926912268574067920L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isPopupFocused()) {
                    FilterEditor.this.popupSelection(FilterEditor.this.popup.getSelection());
                } else {
                    FilterEditor.this.filter.consolidateFilter();
                }
                FilterEditor.this.popup.hide();
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), actionName);
    }

    private void setupEscKey(JComponent component) {
        @NlsSafe String actionName = "FCB_ESC";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = -4351240441578952476L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.popup.hide();
                Object object = e.getSource();
                if (object instanceof JTextField) {
                    JTextField textField = (JTextField)object;
                    textField.setCaretPosition(textField.getCaretPosition());
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), actionName);
    }

    private void setupEndKey(JComponent component) {
        @NlsSafe String actionName = "FCB_END";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = -2777729244353281164L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object;
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectLast(false) || !((object = e.getSource()) instanceof JTextField))) {
                    JTextField textField = (JTextField)object;
                    textField.setCaretPosition(textField.getText().length());
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(35, 0), actionName);
    }

    private void setupEndCtrlKey(JComponent component) {
        @NlsSafe String actionName = "FCB_END_CTRL";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = 1945871436968682881L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object;
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectLast(true) || !((object = e.getSource()) instanceof JTextField))) {
                    JTextField textField = (JTextField)object;
                    textField.setCaretPosition(textField.getText().length());
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(35, 2), actionName);
    }

    private void setupHomeCtrlKey(JComponent component) {
        @NlsSafe String actionName = "FCB_HOME_CTRL";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = 3916227645612863334L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object;
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectFirst(true) || !((object = e.getSource()) instanceof JTextField))) {
                    JTextField textField = (JTextField)object;
                    textField.setCaretPosition(0);
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(36, 2), actionName);
    }

    private void setupHomeKey(JComponent component) {
        @NlsSafe String actionName = "FCB_HOME";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = -1583258893221830664L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object;
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectFirst(false) || !((object = e.getSource()) instanceof JTextField))) {
                    JTextField textField = (JTextField)object;
                    textField.setCaretPosition(0);
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(36, 0), actionName);
    }

    private void setupDownPageKey(JComponent component) {
        @NlsSafe String actionName = "FCB_PAGE_DOWN";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = -1187830005921916553L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    boolean focusPopup = FilterEditor.this.popup.isPopupFocused();
                    FilterEditor.this.popup.selectDownPage();
                    FilterEditor.this.popup.setPopupFocused(focusPopup);
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(34, 0), actionName);
    }

    private void setupUpPageKey(JComponent component) {
        @NlsSafe String actionName = "FCB_PAGE_UP";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = 6590487133211390977L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    boolean focusPopup = FilterEditor.this.popup.isPopupFocused();
                    FilterEditor.this.popup.selectUpPage();
                    FilterEditor.this.popup.setPopupFocused(focusPopup);
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(33, 0), actionName);
    }

    private void setupUpCtrlKey(JComponent component) {
        @NlsSafe String actionName = "FCB_UP_CTRL";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = 746565926592574009L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isPopupFocused() && !FilterEditor.this.popup.selectUp(true)) {
                    FilterEditor.this.popup.setPopupFocused(false);
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(38, 2), actionName);
    }

    private void setupUpKey(JComponent component) {
        @NlsSafe String actionName = "FCB_UP";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = 4555560696351340571L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectUp(false);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                        if (!FilterEditor.this.popup.isPopupFocused()) {
                            FilterEditor.this.popup.hide();
                        }
                    }
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), actionName);
    }

    private void setupDownCtrlKey(JComponent component) {
        @NlsSafe String actionName = "FCB_DOWN_CTRL";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = -8075976293862885060L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectDown(true);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(40, 2), actionName);
    }

    private void setupDownKey(JComponent component) {
        @NlsSafe String actionName = "FCB_DOWN";
        AbstractAction action2 = new AbstractAction(actionName){
            private static final long serialVersionUID = -4133513199725709434L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectDown(false);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action2);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), actionName);
    }

    public final class EditorFilter
    extends Filter {
        RowFilter delegate;
        boolean toBeConsolidated;
        boolean reportOnConsolidation;

        @Override
        public boolean include(RowFilter.Entry entry2) {
            return this.delegate == null || this.delegate.include(entry2);
        }

        @Override
        public void setEnabled(boolean enable) {
            if (enable != this.isEnabled()) {
                FilterEditor.this.setFilterEnabled(enable);
                this.delegate = enable ? FilterEditor.this.editor.getFilter() : null;
                super.setEnabled(enable);
            }
        }

        public RowFilter getDelegate() {
            return this.delegate;
        }

        public void editorFilterUpdated(RowFilter filter2) {
            if (this.isEnabled() && filter2 != this.delegate) {
                this.delegate = filter2;
                this.reportFilterUpdatedToObservers();
                this.reportOnConsolidation = false;
                if (FilterEditor.this.editor.isFocused()) {
                    this.toBeConsolidated = true;
                } else {
                    FilterEditor.this.filtersHandler.consolidateFilterChanges(FilterEditor.this.modelIndex);
                }
            }
        }

        public boolean attemptEditorFilterUpdate(RowFilter filter2) {
            this.delegate = filter2;
            boolean ret = FilterEditor.this.filtersHandler.applyEditorFilter(this);
            if (ret) {
                this.toBeConsolidated = true;
                this.reportOnConsolidation = false;
            } else {
                this.reportOnConsolidation = true;
            }
            return ret;
        }

        public void consolidateFilter() {
            if (this.isEnabled()) {
                FilterEditor.this.editor.consolidateFilter();
                if (this.reportOnConsolidation) {
                    this.reportOnConsolidation = false;
                    this.reportFilterUpdatedToObservers();
                }
                if (this.toBeConsolidated) {
                    this.toBeConsolidated = false;
                    boolean warning = FilterEditor.this.filtersHandler.consolidateFilterChanges(FilterEditor.this.modelIndex);
                    FilterEditor.this.editor.setWarning(warning);
                    if (FilterEditor.this.editor.isValidContent() && !warning) {
                        FilterEditor.this.popup.addHistory(FilterEditor.this.editor.getContent());
                    }
                }
            }
        }
    }
}

