/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

public class YAMLDuplicatedKeysInspection
extends LocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            YAMLDuplicatedKeysInspection.$$$reportNull$$$0(0);
        }
        return new YamlPsiElementVisitor(){

            @Override
            public void visitMapping(@NotNull YAMLMapping mapping) {
                if (mapping == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap occurrences = new MultiMap();
                for (YAMLKeyValue keyValue : mapping.getKeyValues()) {
                    String keyName = keyValue.getKeyText().trim();
                    if (keyName.equals("<<") || keyName.isEmpty()) continue;
                    occurrences.putValue((Object)keyName, (Object)keyValue);
                }
                for (Map.Entry entry : occurrences.entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    ((Collection)entry.getValue()).forEach(duplicatedKey -> {
                        assert (duplicatedKey.getKey() != null);
                        assert (duplicatedKey.getParentMapping() != null) : "This key is gotten from mapping";
                        holder.registerProblem(duplicatedKey.getKey(), YAMLBundle.message("YAMLDuplicatedKeysInspection.duplicated.key", entry.getKey()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveDuplicatedKeyQuickFix()});
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$1", "visitMapping"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection", "buildVisitor"));
    }

    private static class RemoveDuplicatedKeyQuickFix
    implements LocalQuickFix {
        private RemoveDuplicatedKeyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message("YAMLDuplicatedKeysInspection.remove.key.quickfix.name", new Object[0]);
            if (string == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLKeyValue keyVal;
            if (project == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(2);
            }
            if ((keyVal = (YAMLKeyValue)descriptor.getPsiElement().getParent()) == null || keyVal.getParentMapping() == null) {
                return;
            }
            keyVal.getParentMapping().deleteKeyValue(keyVal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$RemoveDuplicatedKeyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$RemoveDuplicatedKeyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

