/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.AnalyzeKeyPairResult;
import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.LogOnceService;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.ValidKeyPair;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0006\u0010\u0014\u001a\u00020\r\u001a\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0016\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0007\u001a\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0002H\u0001\u001a5\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\b\b\u0003\u0010 \u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001f0#H\u0000\u00a2\u0006\u0002\u0010$\u001a\u000e\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017\u001a\u0014\u0010'\u001a\u00020\u0002*\u00020(2\u0006\u0010)\u001a\u00020\u0002H\u0002\u001a\f\u0010*\u001a\u00020+*\u00020(H\u0002\u001a\n\u0010,\u001a\u00020\u001a*\u00020-\"\u001c\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00020\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\"\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"DO_NOT_ESCAPE_CMD_ARGS", "Lcom/intellij/openapi/util/Key;", "", "getDO_NOT_ESCAPE_CMD_ARGS", "()Lcom/intellij/openapi/util/Key;", "PREFER_IPV6_STACK", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "SSH_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getSSH_LOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "overriddenHomeSshDirectory", "Ljava/nio/file/Path;", "analyzeKeyPair", "Lcom/intellij/ssh/AnalyzeKeyPairResult;", "privateKeyFile", "Ljava/io/File;", "sshBackendLibrary", "Lcom/intellij/ssh/SshBackendLibrary;", "getHomeSshDirectory", "isPassphraseMayBeRequired", "privateKeyPath", "", "isPrivateKeyNotEncrypted", "overrideHomeSshDirectory", "", "path", "setPreferIPv6Stack", "value", "wrapBlockingSshCall", "T", "title", "canBeCancelled", "handler", "Lkotlin/Function0;", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "wrapIPv6Address", "host", "checkCanAuthenticate", "Lcom/intellij/ssh/SessionConfig;", "addToPool", "connect", "Lcom/intellij/ssh/SshSession;", "doNotEscapeArgs", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.platform.ssh"})
@JvmName(name="Ssh")
@SourceDebugExtension(value={"SMAP\nssh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ssh.kt\ncom/intellij/ssh/Ssh\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n42#2,3:433\n42#2,3:436\n1#3:439\n*S KotlinDebug\n*F\n+ 1 ssh.kt\ncom/intellij/ssh/Ssh\n*L\n260#1:433,3\n264#1:436,3\n*E\n"})
public final class Ssh {
    @NotNull
    private static final Key<Boolean> DO_NOT_ESCAPE_CMD_ARGS;
    private static Boolean PREFER_IPV6_STACK;
    @Nullable
    private static Path overriddenHomeSshDirectory;
    @NotNull
    private static final Logger SSH_LOG;

    @NotNull
    public static final Key<Boolean> getDO_NOT_ESCAPE_CMD_ARGS() {
        return DO_NOT_ESCAPE_CMD_ARGS;
    }

    public static final void doNotEscapeArgs(@NotNull GeneralCommandLine $this$doNotEscapeArgs) {
        Intrinsics.checkNotNullParameter((Object)$this$doNotEscapeArgs, (String)"<this>");
        $this$doNotEscapeArgs.putUserData(DO_NOT_ESCAPE_CMD_ARGS, (Object)true);
    }

    private static final SshSession connect(SessionConfig $this$connect) {
        boolean $i$f$service = false;
        Class<SshConnectionService> serviceClass$iv = SshConnectionService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return ((SshConnectionService)object).connect($this$connect);
    }

    private static final boolean checkCanAuthenticate(SessionConfig $this$checkCanAuthenticate, boolean addToPool) {
        boolean $i$f$service = false;
        Class<SshConnectionService> serviceClass$iv = SshConnectionService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return ((SshConnectionService)object).checkCanAuthenticate($this$checkCanAuthenticate, addToPool);
    }

    @NotNull
    public static final String wrapIPv6Address(@NotNull String host2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Boolean bl = PREFER_IPV6_STACK;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"PREFER_IPV6_STACK");
        if (bl.booleanValue() && StringsKt.contains$default((CharSequence)host2, (CharSequence)":", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)host2, (String)"[", (boolean)false, (int)2, null)) {
            return "[" + host2 + "]";
        }
        return host2;
    }

    @TestOnly
    public static final void setPreferIPv6Stack(boolean value) {
        PREFER_IPV6_STACK = value;
    }

    @NotNull
    public static final Path getHomeSshDirectory() {
        Path path = overriddenHomeSshDirectory;
        if (path == null) {
            String[] stringArray = new String[]{".ssh"};
            Path path2 = Paths.get(SystemProperties.getUserHome(), stringArray);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        }
        return path;
    }

    @TestOnly
    public static final void overrideHomeSshDirectory(@Nullable Path path) {
        overriddenHomeSshDirectory = path;
    }

    @NotNull
    public static final AnalyzeKeyPairResult analyzeKeyPair(@NotNull File privateKeyFile, @NotNull SshBackendLibrary sshBackendLibrary) {
        AnalyzeKeyPairResult analyzeKeyPairResult;
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        Intrinsics.checkNotNullParameter((Object)((Object)sshBackendLibrary), (String)"sshBackendLibrary");
        try {
            if (WhenMappings.$EnumSwitchMapping$0[sshBackendLibrary.ordinal()] != 1) {
                throw new NoWhenBranchMatchedException();
            }
            analyzeKeyPairResult = UtilKt.analyzeKeyPairSshj(privateKeyFile);
        }
        catch (IOException e) {
            String string;
            String string2 = e.getMessage();
            if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = ((CharSequence)it).length() > 0 ? string3 : null;
            } else {
                string = null;
            }
            String string4 = string;
            analyzeKeyPairResult = new InvalidKeyPair(string4);
        }
        return analyzeKeyPairResult;
    }

    @RequiresBackgroundThread
    public static final boolean isPassphraseMayBeRequired(@NotNull String privateKeyPath, @NotNull SshBackendLibrary sshBackendLibrary) {
        AnalyzeKeyPairResult result2;
        Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
        Intrinsics.checkNotNullParameter((Object)((Object)sshBackendLibrary), (String)"sshBackendLibrary");
        return StringUtil.isEmptyOrSpaces((String)privateKeyPath) ? false : ((result2 = Ssh.analyzeKeyPair(new File(privateKeyPath), sshBackendLibrary)) instanceof ValidKeyPair ? ((ValidKeyPair)result2).getEncrypted() : false);
    }

    public static final boolean isPrivateKeyNotEncrypted(@NotNull String privateKeyPath, @NotNull SshBackendLibrary sshBackendLibrary) {
        Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
        Intrinsics.checkNotNullParameter((Object)((Object)sshBackendLibrary), (String)"sshBackendLibrary");
        AnalyzeKeyPairResult result2 = Ssh.analyzeKeyPair(new File(privateKeyPath), sshBackendLibrary);
        return result2 instanceof ValidKeyPair ? !((ValidKeyPair)result2).getEncrypted() : false;
    }

    public static final <T> T wrapBlockingSshCall(@NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @NotNull Function0<? extends T> handler) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isHeadlessEnvironment()) {
            object = handler.invoke();
        } else if (app.isDispatchThread() || app.isWriteIntentLockAcquired()) {
            LogOnceService.Companion.getInstance().error(SSH_LOG, new Throwable("Blocking SSH method called from the dispatch or write thread"));
            object = CoreProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Ssh.wrapBlockingSshCall$lambda$1(handler), title, canBeCancelled, null);
        } else {
            object = app.isReadAccessAllowed() ? ProgressIndicatorUtils.awaitWithCheckCanceled(ProcessIOExecutorService.INSTANCE.submit(() -> Ssh.wrapBlockingSshCall$lambda$2(handler))) : handler.invoke();
        }
        return (T)object;
    }

    public static /* synthetic */ Object wrapBlockingSshCall$default(String string, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = SshBundle.message("ssh.connection.progress.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = string2;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return Ssh.wrapBlockingSshCall(string, bl, function0);
    }

    @NotNull
    public static final Logger getSSH_LOG() {
        return SSH_LOG;
    }

    private static final Object wrapBlockingSshCall$lambda$1(Function0 $handler) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        return $handler.invoke();
    }

    private static final Object wrapBlockingSshCall$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke();
    }

    public static final /* synthetic */ SshSession access$connect(SessionConfig $receiver) {
        return Ssh.connect($receiver);
    }

    public static final /* synthetic */ boolean access$checkCanAuthenticate(SessionConfig $receiver, boolean addToPool) {
        return Ssh.checkCanAuthenticate($receiver, addToPool);
    }

    static {
        Key key = Key.create((String)"GeneralCommandLine.do.not.escape.args");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DO_NOT_ESCAPE_CMD_ARGS = key;
        PREFER_IPV6_STACK = Boolean.valueOf(System.getProperty("java.net.preferIPv6Stack", "false"));
        Logger logger = Logger.getInstance((String)"com.intellij.ssh.Ssh");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SSH_LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SshBackendLibrary.values().length];
            try {
                nArray[SshBackendLibrary.SSHJ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

