/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck;

import ai.grazie.detector.heuristics.rule.RuleFilter;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.CollectionsKt;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.spellcheck.GrazieSpellcheckerLifecycle;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0002J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "MAX_SUGGESTIONS_COUNT", "", "checkers", "Lkotlin/Lazy;", "", "Lcom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle$SpellerTool;", "executeScope", "getExecuteScope$annotations", "()V", "filter", "Lai/grazie/detector/heuristics/rule/RuleFilter;", "getFilter", "()Lai/grazie/detector/heuristics/rule/RuleFilter;", "filter$delegate", "Lkotlin/Lazy;", "filterCheckers", "", "word", "", "getSuggestions", "initCheckers", "isCorrect", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "update", "", "prevState", "Lcom/intellij/grazie/GrazieConfig$State;", "newState", "SpellerTool", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieSpellchecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1855#2,2:150\n*S KotlinDebug\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle\n*L\n119#1:150,2\n*E\n"})
public final class GrazieSpellcheckerLifecycle
implements GrazieStateLifecycle {
    private final int MAX_SUGGESTIONS_COUNT;
    @NotNull
    private final Lazy filter$delegate;
    @NotNull
    private final CoroutineScope executeScope;
    @NotNull
    private volatile Lazy<? extends Collection<SpellerTool>> checkers;

    public GrazieSpellcheckerLifecycle(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.MAX_SUGGESTIONS_COUNT = 3;
        this.filter$delegate = LazyKt.lazy((Function0)filter.2.INSTANCE);
        this.executeScope = CoroutineScopeKt.childScope$default((CoroutineScope)cs, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault().limitedParallelism(1)), (boolean)false, (int)2, null);
        this.checkers = this.initCheckers();
    }

    private final RuleFilter getFilter() {
        Lazy lazy = this.filter$delegate;
        return (RuleFilter)lazy.getValue();
    }

    private static /* synthetic */ void getExecuteScope$annotations() {
    }

    private final Set<SpellerTool> filterCheckers(String word) {
        Collection checkers = (Collection)this.checkers.getValue();
        if (checkers.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set<Language> preferred = this.getFilter().filter(kotlin.collections.CollectionsKt.listOf((Object)word)).getPreferred();
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)checkers), (Function1)((Function1)new Function1<SpellerTool, Boolean>(preferred){
            final /* synthetic */ Set<Language> $preferred;
            {
                this.$preferred = $preferred;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SpellerTool checker) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
                    Iterable $this$any$iv = this.$preferred;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Language it = (Language)((Object)element$iv);
                            boolean bl2 = false;
                            if (!checker.getLang().equalsTo(it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        })));
    }

    private final Lazy<Collection<SpellerTool>> initCheckers() {
        return LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<LinkedHashSet<SpellerTool>>(this){
            final /* synthetic */ GrazieSpellcheckerLifecycle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LinkedHashSet<SpellerTool> invoke() {
                return CollectionsKt.toLinkedSet(SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)GrazieConfig.Companion.get().getAvailableLanguages()), (Function1)initCheckers.1.INSTANCE), (Function1)((Function1)new Function1<Lang, SpellerTool>(this.this$0){
                    final /* synthetic */ GrazieSpellcheckerLifecycle this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final SpellerTool invoke(@NotNull Lang lang) {
                        SpellerTool spellerTool;
                        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
                        ProgressManager.checkCanceled();
                        JLanguageTool tool = LangTool.INSTANCE.getTool(lang);
                        List<SpellingCheckRule> list = tool.getAllSpellingCheckRules();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSpellingCheckRules(...)");
                        SpellingCheckRule spellingCheckRule = (SpellingCheckRule)kotlin.collections.CollectionsKt.firstOrNull(list);
                        if (spellingCheckRule != null) {
                            SpellingCheckRule spellingCheckRule2 = spellingCheckRule;
                            GrazieSpellcheckerLifecycle grazieSpellcheckerLifecycle = this.this$0;
                            SpellingCheckRule it = spellingCheckRule2;
                            boolean bl = false;
                            spellerTool = new SpellerTool(tool, lang, it, GrazieSpellcheckerLifecycle.access$getMAX_SUGGESTIONS_COUNT$p(grazieSpellcheckerLifecycle));
                        } else {
                            spellerTool = null;
                        }
                        return spellerTool;
                    }
                })));
            }
        }));
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.checkers = this.initCheckers();
        BuildersKt.launch$default((CoroutineScope)this.executeScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GrazieSpellcheckerLifecycle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GrazieSpellcheckerLifecycle.access$getCheckers$p(this.this$0).getValue();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Boolean isCorrect(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Set<SpellerTool> myCheckers = this.filterCheckers(word);
        boolean isAlien = false;
        isAlien = true;
        Iterable $this$forEach$iv = myCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpellerTool speller = (SpellerTool)element$iv;
            boolean bl = false;
            Boolean bl2 = speller.check(word);
            if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)bl2, (Object)false)) continue;
            isAlien = false;
        }
        return isAlien ? null : Boolean.valueOf(false);
    }

    @NotNull
    public final Collection<String> getSuggestions(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Set<SpellerTool> filtered = this.filterCheckers(word);
        if (filtered.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getGlobalProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"notNullize(...)");
        ProgressIndicator indicator = progressIndicator;
        Object object = ApplicationUtil.runWithCheckCanceled(() -> GrazieSpellcheckerLifecycle.getSuggestions$lambda$1(filtered, indicator, word), (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWithCheckCanceled(...)");
        return (Collection)object;
    }

    private static final LinkedHashSet getSuggestions$lambda$1(Set $filtered, ProgressIndicator $indicator, String $word) {
        Intrinsics.checkNotNullParameter((Object)$filtered, (String)"$filtered");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
        return CollectionsKt.toLinkedSet(SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)$filtered), (Function1)((Function1)new Function1<SpellerTool, Set<? extends String>>($indicator, $word){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ String $word;
            {
                this.$indicator = $indicator;
                this.$word = $word;
                super(1);
            }

            @NotNull
            public final Set<String> invoke(@NotNull SpellerTool speller) {
                Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
                this.$indicator.checkCanceled();
                return speller.suggest(this.$word);
            }
        }))));
    }

    public static final /* synthetic */ int access$getMAX_SUGGESTIONS_COUNT$p(GrazieSpellcheckerLifecycle $this) {
        return $this.MAX_SUGGESTIONS_COUNT;
    }

    public static final /* synthetic */ Lazy access$getCheckers$p(GrazieSpellcheckerLifecycle $this) {
        return $this.checkers;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00d6\u0001J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!2\u0006\u0010\"\u001a\u00020\u0016J\t\u0010#\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle$SpellerTool;", "", "tool", "Lorg/languagetool/JLanguageTool;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "speller", "Lorg/languagetool/rules/spelling/SpellingCheckRule;", "suggestLimit", "", "(Lorg/languagetool/JLanguageTool;Lcom/intellij/grazie/jlanguage/Lang;Lorg/languagetool/rules/spelling/SpellingCheckRule;I)V", "getLang", "()Lcom/intellij/grazie/jlanguage/Lang;", "getSpeller", "()Lorg/languagetool/rules/spelling/SpellingCheckRule;", "getSuggestLimit", "()I", "getTool", "()Lorg/languagetool/JLanguageTool;", "check", "", "word", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "suggest", "", "text", "toString", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieSpellchecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle$SpellerTool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n9972#2:150\n10394#2,2:151\n10396#2,3:157\n1549#3:153\n1620#3,3:154\n*S KotlinDebug\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieSpellcheckerLifecycle$SpellerTool\n*L\n82#1:150\n82#1:151,2\n82#1:157,3\n83#1:153\n83#1:154,3\n*E\n"})
    public static final class SpellerTool {
        @NotNull
        private final JLanguageTool tool;
        @NotNull
        private final Lang lang;
        @NotNull
        private final SpellingCheckRule speller;
        private final int suggestLimit;

        public SpellerTool(@NotNull JLanguageTool tool, @NotNull Lang lang, @NotNull SpellingCheckRule speller, int suggestLimit) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            this.tool = tool;
            this.lang = lang;
            this.speller = speller;
            this.suggestLimit = suggestLimit;
        }

        @NotNull
        public final JLanguageTool getTool() {
            return this.tool;
        }

        @NotNull
        public final Lang getLang() {
            return this.lang;
        }

        @NotNull
        public final SpellingCheckRule getSpeller() {
            return this.speller;
        }

        public final int getSuggestLimit() {
            return this.suggestLimit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Boolean check(@NotNull String word) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            SpellingCheckRule spellingCheckRule = this.speller;
            synchronized (spellingCheckRule) {
                block4: {
                    boolean bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)word)) break block4;
                    Boolean bl3 = true;
                    return bl3;
                }
                bl = (Boolean)ClassLoaderUtil.computeWithClassLoader((ClassLoader)GraziePlugin.INSTANCE.getClassLoader(), () -> SpellerTool.check$lambda$1$lambda$0(this, word));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<String> suggest(@NotNull String text2) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            SpellingCheckRule spellingCheckRule = this.speller;
            synchronized (spellingCheckRule) {
                boolean bl = false;
                Set set2 = (Set)ClassLoaderUtil.computeWithClassLoader((ClassLoader)GraziePlugin.INSTANCE.getClassLoader(), () -> SpellerTool.suggest$lambda$5$lambda$4(this, text2));
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                set = set2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"synchronized(...)");
            return set;
        }

        @NotNull
        public final JLanguageTool component1() {
            return this.tool;
        }

        @NotNull
        public final Lang component2() {
            return this.lang;
        }

        @NotNull
        public final SpellingCheckRule component3() {
            return this.speller;
        }

        public final int component4() {
            return this.suggestLimit;
        }

        @NotNull
        public final SpellerTool copy(@NotNull JLanguageTool tool, @NotNull Lang lang, @NotNull SpellingCheckRule speller, int suggestLimit) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            return new SpellerTool(tool, lang, speller, suggestLimit);
        }

        public static /* synthetic */ SpellerTool copy$default(SpellerTool spellerTool, JLanguageTool jLanguageTool, Lang lang, SpellingCheckRule spellingCheckRule, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                jLanguageTool = spellerTool.tool;
            }
            if ((n2 & 2) != 0) {
                lang = spellerTool.lang;
            }
            if ((n2 & 4) != 0) {
                spellingCheckRule = spellerTool.speller;
            }
            if ((n2 & 8) != 0) {
                n = spellerTool.suggestLimit;
            }
            return spellerTool.copy(jLanguageTool, lang, spellingCheckRule, n);
        }

        @NotNull
        public String toString() {
            return "SpellerTool(tool=" + this.tool + ", lang=" + this.lang + ", speller=" + this.speller + ", suggestLimit=" + this.suggestLimit + ")";
        }

        public int hashCode() {
            int result2 = this.tool.hashCode();
            result2 = result2 * 31 + this.lang.hashCode();
            result2 = result2 * 31 + this.speller.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.suggestLimit);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpellerTool)) {
                return false;
            }
            SpellerTool spellerTool = (SpellerTool)other;
            if (!Intrinsics.areEqual((Object)this.tool, (Object)spellerTool.tool)) {
                return false;
            }
            if (this.lang != spellerTool.lang) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.speller, (Object)spellerTool.speller)) {
                return false;
            }
            return this.suggestLimit == spellerTool.suggestLimit;
        }

        private static final Boolean check$lambda$1$lambda$0(SpellerTool this$0, String $word) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
            RuleMatch[] ruleMatchArray = this$0.speller.match(this$0.tool.getRawAnalyzedSentence($word));
            Intrinsics.checkNotNullExpressionValue((Object)ruleMatchArray, (String)"match(...)");
            if (((Object[])ruleMatchArray).length == 0) {
                if (!this$0.speller.isMisspelled($word)) {
                    bl = true;
                } else {
                    String mutated = $word + StringsKt.last((CharSequence)$word) + StringsKt.last((CharSequence)$word);
                    RuleMatch[] ruleMatchArray2 = this$0.speller.match(this$0.tool.getRawAnalyzedSentence(mutated));
                    Intrinsics.checkNotNullExpressionValue((Object)ruleMatchArray2, (String)"match(...)");
                    bl = ((Object[])ruleMatchArray2).length == 0 ? null : Boolean.valueOf(true);
                }
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private static final Set suggest$lambda$5$lambda$4(SpellerTool this$0, String $text) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            RuleMatch[] ruleMatchArray = this$0.speller.match(this$0.tool.getRawAnalyzedSentence($text));
            Intrinsics.checkNotNullExpressionValue((Object)ruleMatchArray, (String)"match(...)");
            Object[] $this$flatMap$iv = ruleMatchArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                RuleMatch match = (RuleMatch)element$iv$iv;
                boolean bl = false;
                List<String> list = match.getSuggestedReplacements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestedReplacements(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string3 = $text;
                    int n = match.getFromPos();
                    int n2 = match.getToPos();
                    Intrinsics.checkNotNull((Object)it);
                    CharSequence charSequence = (CharSequence)it;
                    collection.add(((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n2, (CharSequence)charSequence)).toString());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return kotlin.collections.CollectionsKt.toSet((Iterable)kotlin.collections.CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)this$0.suggestLimit));
        }
    }
}

