/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.language.Contributor;
import org.languagetool.language.RuleFilenameException;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;

public final class LanguageBuilder {
    private LanguageBuilder() {
    }

    public static Language makeAdditionalLanguage(File file2) throws InstantiationException, IllegalAccessException {
        return LanguageBuilder.makeLanguage(file2, true);
    }

    private static Language makeLanguage(final File file2, final boolean isAdditional) throws IllegalAccessException, InstantiationException {
        Language newLanguage;
        boolean secondPartHasCorrectLength;
        Objects.requireNonNull(file2, "file cannot be null");
        if (!file2.getName().endsWith(".xml")) {
            throw new RuleFilenameException(file2);
        }
        final String[] parts = file2.getName().split("-");
        boolean startsWithRules = parts[0].equals("rules");
        boolean bl = secondPartHasCorrectLength = parts.length == 3 && (parts[1].length() == "en".length() || parts[1].length() == "ast".length() || parts[1].length() == "en_US".length());
        if (!startsWithRules || !secondPartHasCorrectLength) {
            throw new RuleFilenameException(file2);
        }
        if (Languages.isLanguageSupported(parts[1])) {
            Language baseLanguage = (Language)Languages.getLanguageForShortCode(parts[1]).getClass().newInstance();
            newLanguage = new ExtendedLanguage(baseLanguage, parts[2].replace(".xml", ""), file2);
        } else {
            newLanguage = new Language(){

                @Override
                public Locale getLocale() {
                    return new Locale(this.getShortCode());
                }

                @Override
                public Contributor[] getMaintainers() {
                    return null;
                }

                @Override
                public String getShortCode() {
                    if (parts[1].length() == 2) {
                        return parts[1];
                    }
                    return parts[1].split("_")[0];
                }

                @Override
                public String[] getCountries() {
                    if (parts[1].length() == 2) {
                        return new String[]{""};
                    }
                    return new String[]{parts[1].split("_")[1]};
                }

                @Override
                public String getName() {
                    return parts[2].replace(".xml", "");
                }

                @Override
                public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) {
                    return Collections.emptyList();
                }

                @Override
                public List<String> getRuleFileNames() {
                    ArrayList<String> ruleFiles = new ArrayList<String>();
                    ruleFiles.add(file2.getAbsolutePath());
                    return ruleFiles;
                }

                @Override
                public boolean isExternal() {
                    return isAdditional;
                }
            };
        }
        return newLanguage;
    }

    static class ExtendedLanguage
    extends Language {
        private final Language baseLanguage;
        private final String name;
        private final File ruleFile;

        ExtendedLanguage(Language baseLanguage, String name, File ruleFile) {
            this.baseLanguage = baseLanguage;
            this.name = name;
            this.ruleFile = ruleFile;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getRuleFileNames() {
            ArrayList<String> ruleFiles = new ArrayList<String>();
            ruleFiles.addAll(this.baseLanguage.getRuleFileNames());
            ruleFiles.add(this.ruleFile.getAbsolutePath());
            return ruleFiles;
        }

        @Override
        public boolean isExternal() {
            return true;
        }

        @Override
        public Locale getLocale() {
            return this.baseLanguage.getLocale();
        }

        @Override
        public Contributor[] getMaintainers() {
            return this.baseLanguage.getMaintainers();
        }

        @Override
        public String getShortCode() {
            return this.baseLanguage.getShortCode();
        }

        @Override
        public String[] getCountries() {
            return this.baseLanguage.getCountries();
        }

        @Override
        public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
            return this.baseLanguage.getRelevantRules(messages, null, motherTongue, altLanguages);
        }

        @Override
        @Nullable
        public String getVariant() {
            return this.baseLanguage.getVariant();
        }

        @Override
        public List<String> getDefaultEnabledRulesForVariant() {
            return this.baseLanguage.getDefaultEnabledRulesForVariant();
        }

        @Override
        public List<String> getDefaultDisabledRulesForVariant() {
            return this.baseLanguage.getDefaultDisabledRulesForVariant();
        }

        @Override
        @Nullable
        public LanguageModel getLanguageModel(File indexDir) throws IOException {
            return this.baseLanguage.getLanguageModel(indexDir);
        }

        @Override
        public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
            return this.baseLanguage.getRelevantLanguageModelRules(messages, languageModel, userConfig);
        }

        @Override
        public Locale getLocaleWithCountryAndVariant() {
            return this.baseLanguage.getLocaleWithCountryAndVariant();
        }

        @Override
        @Nullable
        public Language getDefaultLanguageVariant() {
            return this.baseLanguage.getDefaultLanguageVariant();
        }

        @Override
        public Disambiguator createDefaultDisambiguator() {
            return this.baseLanguage.createDefaultDisambiguator();
        }

        @Override
        @NotNull
        public Tagger createDefaultTagger() {
            return this.baseLanguage.createDefaultTagger();
        }

        @Override
        public SentenceTokenizer createDefaultSentenceTokenizer() {
            return this.baseLanguage.createDefaultSentenceTokenizer();
        }

        @Override
        public Tokenizer createDefaultWordTokenizer() {
            return this.baseLanguage.createDefaultWordTokenizer();
        }

        @Override
        @Nullable
        public Chunker createDefaultChunker() {
            return this.baseLanguage.createDefaultChunker();
        }

        @Override
        @Nullable
        public Chunker createDefaultPostDisambiguationChunker() {
            return this.baseLanguage.createDefaultPostDisambiguationChunker();
        }

        @Override
        @Nullable
        public Synthesizer createDefaultSynthesizer() {
            return this.baseLanguage.createDefaultSynthesizer();
        }
    }
}

