/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.dataextractor;

import com.intellij.driver.model.TextData;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.CellReaderGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.DataExtractorGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.ExtractorGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextToKeyCache;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\tJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextParser;", "", "()V", "graphics", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findContainerComponent", "Ljava/awt/Component;", "component", "parseCellRenderer", "", "", "parseComponent", "Lcom/intellij/driver/model/TextData;", "textToKey", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextToKeyCache;", "parseData", "", "g", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/ExtractorGraphics2d;", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nTextParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextParser.kt\ncom/jetbrains/performancePlugin/remotedriver/dataextractor/TextParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n9#2:57\n*S KotlinDebug\n*F\n+ 1 TextParser.kt\ncom/jetbrains/performancePlugin/remotedriver/dataextractor/TextParser\n*L\n16#1:57\n*E\n"})
public final class TextParser {
    @NotNull
    public static final TextParser INSTANCE = new TextParser();
    private static final Graphics2D graphics = new BufferedImage(1, 1, 2).createGraphics();
    @NotNull
    private static final Logger logger;

    private TextParser() {
    }

    @NotNull
    public final List<TextData> parseComponent(@NotNull Component component, @NotNull TextToKeyCache textToKey) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)textToKey, (String)"textToKey");
        Component component2 = this.findContainerComponent(component);
        if (component2 == null) {
            return CollectionsKt.emptyList();
        }
        Component containerComponent = component2;
        int x = containerComponent.getLocationOnScreen().x - component.getLocationOnScreen().x;
        int y = containerComponent.getLocationOnScreen().y - component.getLocationOnScreen().y;
        List data = new ArrayList();
        Graphics2D graphics2D = graphics;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"graphics");
        DataExtractorGraphics2d g = new DataExtractorGraphics2d(graphics2D, data, new Point(x, y), textToKey);
        this.parseData(g, containerComponent);
        return CollectionsKt.distinct((Iterable)data);
    }

    @NotNull
    public final List<String> parseCellRenderer(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        List data = new ArrayList();
        Graphics2D graphics2D = graphics;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"graphics");
        CellReaderGraphics2d g = new CellReaderGraphics2d(graphics2D, data);
        this.parseData(g, component);
        return data;
    }

    private final void parseData(ExtractorGraphics2d g, Component component) {
        GuiActionRunner.execute(new GuiTask(component, g){
            final /* synthetic */ Component $component;
            final /* synthetic */ ExtractorGraphics2d $g;
            {
                this.$component = $component;
                this.$g = $g;
            }

            protected void executeInEDT() {
                try {
                    this.$component.paint(this.$g);
                }
                catch (Exception e) {
                    TextParser.access$getLogger$p().error("Text parsing error. Can't do paint on " + this.$component.getClass().getSimpleName(), (Throwable)e);
                }
            }
        });
    }

    private final Component findContainerComponent(Component component) {
        if (component.getParent() instanceof JViewport) {
            return component.getParent();
        }
        return component;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        TextParser $this$thisLogger$iv = INSTANCE;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TextParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TextParser.logger = logger;
    }
}

