/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.util.CollectionDelta;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHNotFoundException;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J2\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "adjustAssignees", "Ljava/util/concurrent/CompletableFuture;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "delta", "Lcom/intellij/collaboration/util/CollectionDelta;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "adjustLabels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "adjustReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "loadDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "progressIndicator", "updateDetails", "title", "", "description", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRDetailsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRDetailsServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n11#2:93\n*S KotlinDebug\n*F\n+ 1 GHPRDetailsServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsServiceImpl\n*L\n90#1:93\n*E\n"})
public final class GHPRDetailsServiceImpl
implements GHPRDetailsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final GithubServerPath serverPath;
    @NotNull
    private final GHRepositoryPath repoPath;
    @NotNull
    private static final Logger LOG;

    public GHPRDetailsServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.progressManager = progressManager;
        this.requestExecutor = requestExecutor;
        this.repository = repository;
        this.serverPath = this.repository.getServerPath();
        this.repoPath = this.repository.getRepositoryPath();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequest> loadDetails(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequest>(this, pullRequestId){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            @NotNull
            public final GHPullRequest invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPullRequest gHPullRequest = (GHPullRequest)GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.findOne(GHPRDetailsServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getNumber()));
                if (gHPullRequest == null) {
                    throw new GHNotFoundException("Pull request " + this.$pullRequestId.getNumber() + " does not exist");
                }
                return gHPullRequest;
            }
        }), LOG, "Error occurred while loading PR details");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequest> updateDetails(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @Nullable String title2, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, GHPullRequest>(this, pullRequestId, title2, description){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$title = $title;
                this.$description = $description;
                super(1);
            }

            @NotNull
            public final GHPullRequest invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequest)GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.update(GHPRDetailsServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getId(), this.$title, this.$description));
            }
        }), LOG, "Error occurred while loading PR details");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustReviewers(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @NotNull CollectionDelta<? extends GHPullRequestRequestedReviewer> delta2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter(delta2, (String)"delta");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, Unit>(delta2, this, pullRequestId){
            final /* synthetic */ CollectionDelta<GHPullRequestRequestedReviewer> $delta;
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.$delta = $delta;
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Collection newItems;
                Collection<String> collection;
                Collection<String> collection2;
                Collection destination$iv$iv;
                GithubApiRequestExecutor githubApiRequestExecutor;
                ProgressIndicator progressIndicator;
                GithubServerPath githubServerPath;
                String string;
                String string2;
                long l;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setText(GithubBundle.message("pull.request.details.adjusting.reviewers", new Object[0]));
                Collection removedItems = this.$delta.getRemovedItems();
                if (!removedItems.isEmpty()) {
                    GHTeam it2;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    it.setText2(GithubBundle.message("pull.request.removing.reviewers", new Object[0]));
                    Iterable iterable = CollectionsKt.filterIsInstance((Iterable)removedItems, GHUser.class);
                    l = this.$pullRequestId.getNumber();
                    string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                    string = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                    githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                    progressIndicator = it;
                    githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                    boolean $i$f$map = false;
                    void var5_12 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        GHUser gHUser = (GHUser)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(((GHUser)((Object)it2)).getLogin());
                    }
                    collection2 = (List)destination$iv$iv;
                    $this$map$iv = CollectionsKt.filterIsInstance((Iterable)removedItems, GHTeam.class);
                    collection2 = collection2;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (GHTeam)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it2.getSlug());
                    }
                    collection = (List)destination$iv$iv;
                    githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.PullRequests.Reviewers.remove(githubServerPath, string, string2, l, collection2, (List<String>)collection));
                }
                if (!(newItems = this.$delta.getNewItems()).isEmpty()) {
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    it.setText2(GithubBundle.message("pull.request.adding.reviewers", new Object[0]));
                    Iterable $i$f$map = CollectionsKt.filterIsInstance((Iterable)newItems, GHUser.class);
                    l = this.$pullRequestId.getNumber();
                    string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                    string = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                    githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                    progressIndicator = it;
                    githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        GHUser bl = (GHUser)item$iv$iv;
                        collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(it3.getLogin());
                    }
                    collection2 = (List)destination$iv$iv2;
                    $this$map$iv = CollectionsKt.filterIsInstance((Iterable)newItems, GHTeam.class);
                    $i$f$map2 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        GHTeam it3 = (GHTeam)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(it3.getSlug());
                    }
                    collection = (List)destination$iv$iv2;
                    githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.PullRequests.Reviewers.add(githubServerPath, string, string2, l, collection2, collection));
                }
            }
        }), LOG, "Error occurred while adjusting the list of reviewers");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustAssignees(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @NotNull CollectionDelta<GHUser> delta2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter(delta2, (String)"delta");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId, delta2){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ CollectionDelta<GHUser> $delta;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$delta = $delta;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setText(GithubBundle.message("pull.request.details.adjusting.assignees", new Object[0]));
                Iterable iterable = this.$delta.getNewCollection();
                String string = String.valueOf(this.$pullRequestId.getNumber());
                String string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                String string3 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                GithubServerPath githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                ProgressIndicator progressIndicator = it;
                GithubApiRequestExecutor githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                boolean $i$f$map = false;
                void var4_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    GHUser gHUser = (GHUser)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getLogin());
                }
                collection = (List)destination$iv$iv;
                githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.Issues.updateAssignees(githubServerPath, string3, string2, string, collection));
            }
        }), LOG, "Error occurred while adjusting the list of assignees");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustLabels(@NotNull ProgressIndicator indicator, @NotNull GHPRIdentifier pullRequestId, @NotNull CollectionDelta<GHLabel> delta2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter(delta2, (String)"delta");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, indicator, (Function1)new Function1<ProgressIndicator, Unit>(this, indicator, pullRequestId, delta2){
            final /* synthetic */ GHPRDetailsServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ CollectionDelta<GHLabel> $delta;
            {
                this.this$0 = $receiver;
                this.$indicator = $indicator;
                this.$pullRequestId = $pullRequestId;
                this.$delta = $delta;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setText(GithubBundle.message("pull.request.details.adjusting.labels", new Object[0]));
                Iterable iterable = this.$delta.getNewCollection();
                String string = String.valueOf(this.$pullRequestId.getNumber());
                String string2 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                String string3 = GHPRDetailsServiceImpl.access$getRepoPath$p(this.this$0).getOwner();
                GithubServerPath githubServerPath = GHPRDetailsServiceImpl.access$getServerPath$p(this.this$0);
                ProgressIndicator progressIndicator = this.$indicator;
                GithubApiRequestExecutor githubApiRequestExecutor = GHPRDetailsServiceImpl.access$getRequestExecutor$p(this.this$0);
                boolean $i$f$map = false;
                void var4_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    GHLabel gHLabel = (GHLabel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getName());
                }
                collection = (List)destination$iv$iv;
                githubApiRequestExecutor.execute(progressIndicator, (GithubApiRequest)GithubApiRequests.Repos.Issues.Labels.replace(githubServerPath, string3, string2, string, collection));
            }
        }), LOG, "Error occurred while adjusting the list of labels");
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRDetailsServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getRepository$p(GHPRDetailsServiceImpl $this) {
        return $this.repository;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GHPRDetailsServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GHRepositoryPath access$getRepoPath$p(GHPRDetailsServiceImpl $this) {
        return $this.repoPath;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRDetailsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

