/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl.configuration;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.PySdkRenderingKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/pycharm/community/ide/impl/configuration/PySdkStatusBar;", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "module", "Lcom/intellij/openapi/module/Module;", "ID", "", "createInstance", "Lcom/intellij/openapi/wm/StatusBarWidget;", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "findModule", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWidgetState", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$WidgetState;", "isEnabledForFile", "", "registerCustomListeners", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "intellij.pycharm.community.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPySdkStatusBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkStatusBar.kt\ncom/intellij/pycharm/community/ide/impl/configuration/PySdkStatusBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
final class PySdkStatusBar
extends EditorBasedStatusBarPopup {
    @Nullable
    private Module module;

    public PySdkStatusBar(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(project, false, scope);
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        EditorBasedStatusBarPopup.WidgetState widgetState;
        Module module = this.findModule(file);
        if (module == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        this.module = module;
        Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)this.module);
        if (sdk2 == null) {
            widgetState = new EditorBasedStatusBarPopup.WidgetState("", PySdkRenderingKt.getNoInterpreterMarker(), true);
        } else {
            Object[] objectArray = new Object[]{PySdkPopupFactory.Companion.descriptionInPopup(sdk2)};
            EditorBasedStatusBarPopup.WidgetState widgetState2 = new EditorBasedStatusBarPopup.WidgetState(PyBundle.message((String)"current.interpreter", (Object[])objectArray), PySdkPopupFactory.Companion.shortenNameInPopup(sdk2, 50), true);
            widgetState = widgetState2;
        }
        return widgetState;
    }

    protected boolean isEnabledForFile(@Nullable VirtualFile file) {
        return true;
    }

    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Topic topic = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ModuleRootListener(this){
            final /* synthetic */ PySdkStatusBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.update();
            }
        });
    }

    @Nullable
    protected ListPopup createPopup(@NotNull DataContext context) {
        ListPopup listPopup;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Module module = this.module;
        if (module != null) {
            Module it = module;
            boolean bl = false;
            listPopup = new PySdkPopupFactory(this.getProject(), it).createPopup(context);
        } else {
            listPopup = null;
        }
        return listPopup;
    }

    @NotNull
    public String ID() {
        return "pythonInterpreterWidget";
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (StatusBarWidget)new PySdkStatusBar(project, this.getScope());
    }

    private final Module findModule(VirtualFile file) {
        Module module;
        if (file != null && (module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.getProject())) != null) {
            return module;
        }
        return (Module)ArraysKt.singleOrNull((Object[])ModuleManager.Companion.getInstance(this.getProject()).getModules());
    }
}

