/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.introspection.ClassUtils;
import org.assertj.core.util.introspection.MemberUtils;

class FieldUtils {
    private static final Map<Class<?>, Map<String, Field>> fieldsPerClass = new ConcurrentHashMap();

    FieldUtils() {
    }

    static Field getField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Preconditions.checkArgument(cls != null, "The class must not be null", new Object[0]);
        Preconditions.checkArgument(fieldName != null, "The field name must not be null", new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = FieldUtils.getDeclaredField(fieldName, acls);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (forceAccess) {
                        field.setAccessible(true);
                    } else {
                        throw new IllegalAccessException("can not access" + fieldName + " because it is not public");
                    }
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        Field match = null;
        for (Class<?> class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                Field test2 = class1.getField(fieldName);
                Preconditions.checkArgument(match == null, "Reference to field " + fieldName + " is ambiguous relative to " + cls + "; a matching field exists on two or more implemented interfaces.", new Object[0]);
                match = test2;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    private static Field getDeclaredField(String fieldName, Class<?> acls) throws NoSuchFieldException {
        fieldsPerClass.computeIfAbsent(acls, unused -> new ConcurrentHashMap());
        if (fieldsPerClass.get(acls).containsKey(fieldName)) {
            return fieldsPerClass.get(acls).get(fieldName);
        }
        Field field = acls.getDeclaredField(fieldName);
        fieldsPerClass.get(acls).put(fieldName, field);
        return acls.getDeclaredField(fieldName);
    }

    private static Object readField(Field field, Object target) throws IllegalAccessException {
        return FieldUtils.readField(field, target, false);
    }

    private static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        Preconditions.checkArgument(field != null, "The field must not be null", new Object[0]);
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field.get(target);
    }

    static Object readField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Preconditions.checkArgument(target != null, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, fieldName, forceAccess);
        Preconditions.checkArgument(field != null, "Cannot locate field %s on %s", fieldName, cls);
        Preconditions.checkArgument(!Modifier.isStatic(field.getModifiers()), "Reading static field is not supported and field %s is static on %s", fieldName, cls);
        Preconditions.checkArgument(!field.isSynthetic(), "Reading synthetic field is not supported and field %s is", fieldName);
        return FieldUtils.readField(field, target);
    }
}

